# Test Config.py

import unittest
import sys

sys.path.insert(0, '../src/lib')
import Config

import pygtk
import gconf

class ConfigTestCase(unittest.TestCase):
    def setUp(self):
        self.POLL_FREQ = "/apps/straw/general/poll_frequency"
        self.ITEM_STORE = "/apps/straw/general/number_of_items_stored"
        self.ITEM_ORDER = "/apps/straw/general/item_order_newest"
        self.WS_W = "/apps/straw/ui/window_width" # window size
        self.WS_H = "/apps/straw/ui/window_height"
        self.MAIN_PANE = "/apps/straw/ui/main_pane_position"
        self.SUB_PANE = "/apps/straw/ui/sub_pane_position"
        self.IS_OFFLINE = "/apps/straw/general/offline"
        self.FI_VISIBLE = "/apps/straw/general/feed_info_visibility"
        self.config = Config.get_instance()
        self.client = gconf.client_get_default()

    def testDefaultValues(self):
        # test default values
        self.assertEqual (self.client.get_int (self.POLL_FREQ),
                         self.config.poll_frequency)
        self.assertEqual (self.client.get_int (self.ITEM_STORE),
                         self.config.number_of_items_stored)
        self.assertEqual (self.client.get_bool (self.ITEM_ORDER),
                         self.config.item_order)
        self.assertEqual (self.client.get_int (self.WS_W),
                         self.config.main_window_size[0])
        self.assertEqual (self.client.get_int (self.WS_H),
                         self.config.main_window_size[1])
        self.assertEqual (self.client.get_int (self.MAIN_PANE),
                         self.config.main_pane_position)
        self.assertEqual (self.client.get_int (self.SUB_PANE),
                         self.config.sub_pane_position)
        self.assertEqual (self.client.get_bool (self.IS_OFFLINE),
                         self.config.offline)
        self.assertEqual (self.client.get_bool (self.FI_VISIBLE),
                         self.config.feed_info_visibility)



    # not yet complete...

def suite():
    suite = unittest.makeSuite(ConfigTestCase, 'test')
    return suite

if __name__ == '__main__':
    unittest.main()
