# $Id: curl.m4,v 1.8 2004/02/17 14:45:08 jylefort Exp $
#
# This file is part of streamtuner.
#
# Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort.
#
# As a special exception to the streamtuner licensing terms, Jean-Yves
# Lefort gives unlimited permission to copy, distribute and modify
# this file.

dnl AM_PATH_CURL([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN(AM_PATH_CURL,
[AC_PATH_PROG(CURL_CONFIG, curl-config, no)

if test "x$CURL_CONFIG" = xno; then
	CURL_CFLAGS=""
	CURL_LIBS=""

	ifelse([$3],, :, [$3])
else
	CURL_CFLAGS=`$CURL_CONFIG --cflags`
	CURL_LIBS=`$CURL_CONFIG --libs`

	# curl_version_info() has been introduced in version 7.10
	curl_min_version=ifelse([$1],, 7.10, [$1])

	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $CURL_CFLAGS"
	LIBS="$LIBS $CURL_LIBS"

	AC_MSG_CHECKING([for libcurl - version >= $curl_min_version])

	AC_TRY_RUN([
#include <curl/curl.h>

int main() {
  int major, minor, micro = 0;
  curl_version_info_data *version_info;

  if (sscanf("$curl_min_version", "%d.%d.%d", &major, &minor, &micro) < 2)
    exit(1); /* bad version string */

  version_info = curl_version_info(CURLVERSION_NOW);
  if (! version_info)
    exit(2); /* no version info */

  if (version_info->version_num < (major << 16) + (minor << 8) + micro)
    exit(3); /* version too old */

  exit(0);
}
],, [found=no], [found=yes])

	AC_MSG_RESULT($found)

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"

	if test $found = yes; then
		ifelse([$2],, :, [$2])
	else
		CURL_CFLAGS=""
		CURL_LIBS=""

		ifelse([$3],, :, [$3])
	fi
fi

AC_SUBST(CURL_CFLAGS)
AC_SUBST(CURL_LIBS)])
