/*
 * $Id: st-browser-tab-label.h,v 1.4 2004/03/18 15:33:26 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_BROWSER_TAB_LABEL_H
#define _ST_BROWSER_TAB_LABEL_H

#include <gtk/gtk.h>
#include "st-browser-tab.h"

#define ST_TYPE_BROWSER_TAB_LABEL		(st_browser_tab_label_get_type())
#define ST_BROWSER_TAB_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_BROWSER_TAB_LABEL, STBrowserTabLabel))
#define ST_BROWSER_TAB_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_BROWSER_TAB_LABEL, STBrowserTabLabelClass))
#define ST_IS_BROWSER_TAB_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_BROWSER_TAB_LABEL))
#define ST_IS_BROWSER_TAB_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_BROWSER_TAB_LABEL))
#define ST_BROWSER_TAB_LABEL_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_BROWSER_TAB_LABEL, STBrowserTabLabelClass))

typedef struct _STBrowserTabLabelPrivate STBrowserTabLabelPrivate;

typedef struct
{
  GtkHBox			hbox;

  STBrowserTabLabelPrivate	*priv;
  STBrowserTab			*tab;
} STBrowserTabLabel;

typedef struct
{
  GtkHBoxClass			parent_class;
} STBrowserTabLabelClass;
  
GType st_browser_tab_label_get_type (void);

GtkWidget *st_browser_tab_label_new		(STBrowserTab      *tab,
						 gboolean          use_event_box);
void      st_browser_tab_label_set_blinking	(STBrowserTabLabel *tab_label,
						 gboolean          blinking);
void      st_browser_tab_label_set_icon_visible	(STBrowserTabLabel *tab_label,
						 gboolean          visible);

#endif /* _ST_BROWSER_TAB_LABEL_H */
