/*
 * $Id: st-search-dialog.c,v 1.13 2004/03/19 11:00:38 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "gettext.h"
#include "sgtk-hig.h"
#include "st-search-dialog.h"
#include "st-stock.h"

/*** type definitions ********************************************************/

struct _STSearchDialogPrivate
{
  GtkWidget	*entry;
};
  
/*** variable declarations ***************************************************/

static GObjectClass *parent_class = NULL;

/*** function declarations ***************************************************/

static void st_search_dialog_class_init (STSearchDialogClass *class);
static void st_search_dialog_init (STSearchDialog *dialog);
static void st_search_dialog_finalize (GObject *object);

/*** implementation **********************************************************/

GType
st_search_dialog_get_type (void)
{
  static GType search_dialog_type = 0;
  
  if (! search_dialog_type)
    {
      static const GTypeInfo search_dialog_info = {
	sizeof(STSearchDialogClass),
	NULL,
	NULL,
	(GClassInitFunc) st_search_dialog_class_init,
	NULL,
	NULL,
	sizeof(STSearchDialog),
	0,
	(GInstanceInitFunc) st_search_dialog_init,
      };
      
      search_dialog_type = g_type_register_static(SGTK_TYPE_ALERT_DIALOG,
						  "STSearchDialog",
						  &search_dialog_info,
						  0);
    }

  return search_dialog_type;
}

static void
st_search_dialog_class_init (STSearchDialogClass *class)
{
  GObjectClass *object_class = G_OBJECT_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  object_class->finalize = st_search_dialog_finalize;
}

static void
st_search_dialog_init (STSearchDialog *dialog)
{
  GtkWidget *find;
  GtkWidget *label;
  GtkWidget *table;

  dialog->priv = g_new0(STSearchDialogPrivate, 1);

  gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
  find = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_FIND, GTK_RESPONSE_OK);

  gtk_window_set_default(GTK_WINDOW(dialog), find);

  gtk_image_set_from_stock(GTK_IMAGE(SGTK_ALERT_DIALOG(dialog)->image),
			   ST_STOCK_SEARCH,
			   GTK_ICON_SIZE_DIALOG);

  label = gtk_label_new_with_mnemonic(_("_Search for:"));
  gtk_label_set_selectable(GTK_LABEL(label), TRUE);

  dialog->priv->entry = gtk_entry_new();
  gtk_entry_set_activates_default(GTK_ENTRY(dialog->priv->entry), TRUE);

  gtk_label_set_mnemonic_widget(GTK_LABEL(label), dialog->priv->entry);

  table = gtk_table_new(1, 2, FALSE);

  gtk_table_set_row_spacings(GTK_TABLE(table), SGTK_HIG_CONTROL_SPACING);
  gtk_table_set_col_spacings(GTK_TABLE(table), SGTK_HIG_CONTROL_LABEL_SPACING);

  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		   GTK_FILL,
		   0,
		   0,
		   0);
  gtk_table_attach(GTK_TABLE(table), dialog->priv->entry, 1, 2, 0, 1,
		   GTK_EXPAND | GTK_FILL,
		   0,
		   0,
		   0);

  gtk_box_pack_start(GTK_BOX(SGTK_ALERT_DIALOG(dialog)->hbox), table, TRUE, TRUE, 0);
  
  gtk_widget_show_all(table);
}

static void
st_search_dialog_finalize (GObject *object)
{
  STSearchDialog *dialog = ST_SEARCH_DIALOG(object);

  g_free(dialog->priv);

  G_OBJECT_CLASS(parent_class)->finalize(object);
}

GtkWidget *
st_search_dialog_new (GtkWindow *parent)
{
  STSearchDialog *dialog;

  dialog = g_object_new(ST_TYPE_SEARCH_DIALOG, NULL);

  if (parent)
    gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);

  return GTK_WIDGET(dialog);
}

const char *
st_search_dialog_get_text (STSearchDialog *dialog)
{
  g_return_val_if_fail(ST_IS_SEARCH_DIALOG(dialog), NULL);

  return gtk_entry_get_text(GTK_ENTRY(dialog->priv->entry));
}
