#include "fileinputstream.h"
#include "stringreader.h"
#include "gzipinputstream.h"
#include "kmpsearcher.h"
#include "subinputstream.h"
#include "stringterminatedsubstream.h"
using namespace jstreams;
using namespace std;

int32_t streamcount = 0;

const char* start;
const char* end;
const char* pos;
int64_t objdefstart = 0;
StreamBase<char>* stream;

double lastNumber;
string lastName;
void* lastObject;

int lastLength;
string lastFilter;

StreamStatus
read(int32_t min, int32_t max) {
    int32_t off = pos-start;
    int32_t d = stream->getPosition() - objdefstart;
    min += d;
    if (max > 0) max += d;
    stream->reset(objdefstart);
    int32_t n = stream->read(start, min, max);
//    printf("objstart %i %i\n", d, n);
    if (n < min) return stream->getStatus();
    pos = start + off;
    end = start + n;
    return Ok;
}
StreamStatus
read2(int32_t min, int32_t max) {
    printf("pos %i\n", stream->getPosition());
    int32_t n = stream->read(start, min, max);
    if (n < min) return stream->getStatus();
    pos = start;
    end = pos + n;
    return Ok;
}
StreamStatus
checkForData(int32_t m) {
    StreamStatus n = Ok;
    if (end - pos < m) {
        n = read(m, 0);
    }
    return n;
}

StreamStatus skipWhitespaceOrComment();
StreamStatus skipWhitespace();
StreamStatus parseObjectStreamObject();
StreamStatus parseComment();
StreamStatus parseBoolean();
StreamStatus parseNumber();
StreamStatus parseNumberOrIndirectObject();
StreamStatus parseLiteralString();
StreamStatus parseHexString();
StreamStatus parseName();
StreamStatus parseDictionaryOrStream();
StreamStatus parseArray();
StreamStatus parseNull();

bool
isInString(char c, const char* s, int32_t n) {
    for (int i=0; i<n; ++i) {
        if (s[i] == c) return true;
    }
    return false;
}
StreamStatus
skipFromString(const char*str, int32_t n) {
    StreamStatus s;
    do {
        if ((s = checkForData(1)) != Ok) return s;
        while (pos < end && isInString(*pos, str, n)) pos++;
    } while (pos == end);
    return Ok;
}
StreamStatus
skipNotFromString(const char*str, int32_t n) {
    StreamStatus s;
    do {
        if ((s = checkForData(1)) != Ok) return s;
        while (pos < end && !isInString(*pos, str, n)) pos++;
    } while (pos == end);
    return Ok;
}
StreamStatus
skipKeyword(const char* str, int32_t len) {
    if (end - pos < len) {
        StreamStatus s;
        if ((s = read(len, 0)) != Ok) return Error;
    }
    printf("skipKeyword %s '%.*s'\n", str, (len>end-pos)?end-pos:len, pos);
    if (strncmp(pos, str, len) != 0) return Error;
    pos += len;
    return Ok;
}
/**
 * Skip whitespace in the stream. Return amount of whitespace skipped.
 * After calling this function the position in the stream is after the
 * whitespace.
 **/
StreamStatus
skipWhitespace() {
    return skipFromString("\t\n\f\r ", 5);
}
StreamStatus
parseComment() {
    if (*pos != '%') return Ok;
    pos++; // skip '%'
    return skipNotFromString("\r\n", 2);
}
StreamStatus
skipWhitespaceOrComment() {
//    printf("skipWhitespaceOrComment\n");
    int64_t o;
    int64_t no = pos - start;
    StreamStatus s;
    do {
        o = no;
        if ((s = skipWhitespace()) != Ok) return s;
        if ((s = parseComment()) != Ok) return s;
        no = pos - start;
    } while (o != no);
    return Ok; 
}
StreamStatus
parseBoolean() {
    return (*pos == 't') ?skipKeyword("true", 4) :skipKeyword("false", 5);
}
// - number : [+-]?\d+(.\d+)?
StreamStatus
parseNumber() {
    printf("parseNumber\n");
    static const char* nc = "0123456789";
    int64_t p = pos - start;
    char ch = *pos;
    if (ch == '+' || ch == '-') pos++;
    StreamStatus n = skipFromString(nc, 10);
    if (n != Ok) return n;
    if (pos < end && *pos == '.') {
        pos++;
        n = skipFromString(nc, 10);
    }
    const char *s = start + p;
    // parse an integer
    lastNumber = strtod(s, 0);
    lastObject = &lastNumber;
    return n;
}
StreamStatus
parseNumberOrIndirectObject() {
    printf("parseNumberOrIndirectObject\n");
    StreamStatus s = parseNumber();
    if (s != Ok) return s;
    s = skipWhitespace();
    if (s != Ok) return s;
    // now we must check if this is an indirect object
    if (isdigit(*pos)) {
        const char*ss= start;
        int64_t p = pos - start;
        s = parseNumber();
        if (s != Ok) return s;
        s = skipWhitespace();
        if (s != Ok) return s;
        if (*pos == 'R') {
            pos++;
            lastObject = 0;
        } else {
            // set the position in front of the previous number
            // because it is a separate number and not part of a reference
            pos = start + p;
        }
    }
//    printf("<parseNumberOrIndirectObject\n");
    return Ok;
}
StreamStatus
parseLiteralString() {
    StreamStatus s;
    int par = 1;
    pos++;
    bool escape = false;
    do {
        if ((s = checkForData(1)) != Ok) return s;
        while (pos < end) {
            char c = *pos;
            if (escape) {
                escape = false;
            } else {
                if (c == ')') {
                    if (--par == 0) {
                        pos++;
                        return Ok;
                    }
                } else if (c == '(') {
                    par++;
                } else if (c == '\\') {
                    escape = true;
                }
            }
            pos++;
        }
    } while (1);
    return Ok;
}
StreamStatus
parseHexString() {
//    printf("parseHexString\n");
    if (skipNotFromString(">", 1) != Ok) return Error;
    return skipKeyword(">", 1);
}
StreamStatus
parseName() {
    printf("parseName %.*s\n", (10>end-pos)?end-pos:10, pos);
    pos++;
    int64_t p = pos - start;
    StreamStatus r = skipNotFromString("()<>[]{}/%\t\n\f\r ", 16);
    if (r == Error) return r;
    const char *s = start + p;
    lastName.assign(s, pos-s);
    lastObject = &lastName;
    return r;
}
StreamStatus
parseDictionaryOrStream() {
    lastLength = -1;
//    lastFilter.resize(0);

//    printf("parseDictionary\n");
    StreamStatus r;
    pos += 2;
    skipWhitespaceOrComment();
    while (*pos != '>') {
        if (parseName() != Ok) return Error;
        if (skipWhitespaceOrComment() != Ok) return Error;
        lastObject = 0;
        if (parseObjectStreamObject() != Ok) return Error;
        if (lastName == "Length" && lastObject == &lastNumber) {
            lastLength = (int32_t)lastNumber;
        }
        if (skipWhitespaceOrComment() != Ok) return Error;
    }
    if (skipKeyword(">>", 2) != Ok) return Error;
    r = skipWhitespaceOrComment();
    if (r != Ok) return r;
    if (*pos == 's') {
        printf("stream %i\n", end-pos);
        skipKeyword("stream", 6);
        if (checkForData(11) != Ok) return Error;
        if (*pos == '\r') pos++;
        if (*pos != '\n') return Error;
        pos++;

        // read stream until 'endstream'
        int64_t p = pos-start;
        if (p != stream->reset(p)) return Error;
        printf("position: %i\n", p);
        printf("left: %i\n", (end-pos));
        if (lastLength == -1) {
            StringTerminatedSubStream sub(stream, "endstream");
            do {
                sub.skip(1000);
            } while (sub.getStatus() == Ok);
            if (sub.getStatus() == Error) return Error;
            int64_t size = sub.getSize();
            printf("len: %i\n", p);
            p += sub.getSize();
            printf("size: %i\n", size);
            if (p != stream->reset(p)) return Error;
            printf("len: %i\n", p);
        } else {
            printf("len: %i\n", lastLength);
            SubInputStream sub(stream, lastLength);
            do {
                printf("pos %i\n", sub.skip(1000));
            } while (sub.getStatus() == Ok);
            if (sub.getStatus() == Error) return Error;
            p += sub.getSize();
            if (p != stream->reset(p)) return Error;
            printf("len: %i\n", sub.getSize());
        }
        if (read(1, 0) != Ok) return Error;
        pos = start + p;
        //pos = start + (stream->getPosition()-objdefstart);
//        printf("hi %i\n", off+(pos-start));
        //printf("hi %i\n", *pos);
        if (skipWhitespaceOrComment() != Ok) return Error;
//        printf("hi %i %.*s\n", pos-start, 10, pos);
        if (skipKeyword("endstream", 9) != Ok) return Error;
//        printf("endstream\n");
        streamcount++;
    }
    return Ok;
}
StreamStatus
parseArray() {
//    printf("parseArray\n");
    pos++;
    if (skipWhitespaceOrComment() != Ok) return Error;
    while (*pos != ']') {
        if (parseObjectStreamObject() != Ok) return Error;
        if (skipWhitespaceOrComment() != Ok) return Error;
    }
    pos++;
    return Ok;
}
StreamStatus
parseNull() {
    return skipKeyword("null", 4);
}
StreamStatus
parseObjectStreamObject() {
//    printf("parseObjectStreamObject %.*s\n", (5>end-pos)?end-pos:5, pos);
    StreamStatus r = read(2,0);
    if (r == Error) return r;

    char ch = *pos;
    if (ch == 't' || ch == 'f') {
        r = parseBoolean();
    } else if (ch == '+' || ch == '-' || ch == '.' || isdigit(ch)) {
        r = parseNumberOrIndirectObject();
    } else if (ch == '(') {
        r = parseLiteralString();
    } else if (ch == '/') {
        r = parseName();
    } else if (ch == '<') {
        if (end-pos > 1 && pos[1] == '<') {
            r = parseDictionaryOrStream();
        } else {
            r = parseHexString();
        }
    } else if (ch == '[') {
        r = parseArray();
    } else if (ch == 'n') {
        r = parseNull();
    } else {
        return Error;
    }
    if (r != Ok) return r;
    r = skipWhitespaceOrComment();
    return r;
}
StreamStatus
parseObjectStreamObjectDef() {
//    objdefstart = pos-start;
    // if we are at 'xref' or 'startxref' we're ready
    if (*pos == 'x' || *pos == 's') return Eof;
    if (checkForData(13) != Ok) return Error;
    printf("parseObjectStreamObjectDef %.*s\n", ((10>end-pos)?end-pos:10), pos);
    if (parseNumber() != Ok || skipWhitespaceOrComment() != Ok
        || parseNumber() != Ok || skipWhitespaceOrComment() != Ok
        || skipKeyword("obj", 3) != Ok || skipWhitespaceOrComment() != Ok
        || parseObjectStreamObject() != Ok || skipWhitespaceOrComment() != Ok
        || skipKeyword("endobj", 6) != Ok) {
        return Error;
    }

    return skipWhitespaceOrComment();
}
StreamStatus
parseObjectStream() {
    StreamStatus r;
    r = skipWhitespaceOrComment();
    if (r != Ok) return r;
    while ((r = parseObjectStreamObjectDef()) == Ok) {};
    printf("%i %i\n", r, streamcount);
    return r;
}

int
main(int argc, char** argv) {
    streamcount = 0;
    for (int i=1; i<argc; ++i) {
        FileInputStream file(argv[i]);
        const char* c;
        file.read(c, 10000000,0);
        file.reset(0);
        stream = &file;
        objdefstart = 0;
        lastObject = 0;
        StreamStatus r = read(1, 0);
        if (r == Ok) {
            r = parseObjectStream();
            if (r != Eof) {
                printf("error in %s\n", argv[i]);
            }
        }
    }
    return 0;
}
