// Copyright (C) 2005-2006 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// In addition, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef STRIGIDAEMON_HXX
#define STRIGIDAEMON_HXX

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2020000L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

// Forward declarations.
//
namespace strigi
{
  class daemonConfigurationType;
  class repositoryType;
  class repositoryTypeType;
  class fileSourceType;
  class fileSystemSourceType;
  class httpSourceType;
}


#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/xml/error-handler.hxx>
#include <xsd/cxx/xml/dom/elements.hxx>
#include <xsd/cxx/xml/dom/serialization.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/types.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef long double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char > string;
  typedef ::xsd::cxx::tree::normalized_string< char > normalized_string;
  typedef ::xsd::cxx::tree::token< char > token;
  typedef ::xsd::cxx::tree::name< char > name;
  typedef ::xsd::cxx::tree::nmtoken< char > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char > ncname;
  typedef ::xsd::cxx::tree::language< char > language;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char > qname;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char > id;
  typedef ::xsd::cxx::tree::idref< type, char > idref;
  typedef ::xsd::cxx::tree::idrefs< type, char > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char > uri;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char > date;
  typedef ::xsd::cxx::tree::date_time< char > date_time;
  typedef ::xsd::cxx::tree::duration< char > duration;
  typedef ::xsd::cxx::tree::day< char > day;
  typedef ::xsd::cxx::tree::month< char > month;
  typedef ::xsd::cxx::tree::month_day< char > month_day;
  typedef ::xsd::cxx::tree::year< char > year;
  typedef ::xsd::cxx::tree::year_month< char > year_month;
  typedef ::xsd::cxx::tree::time< char > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char > entity;
  typedef ::xsd::cxx::tree::entities< char > entities;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization error.
  //
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::errors< char > errors;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // Namespace information. Used in serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info < char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap < char > namespace_infomap;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
}

namespace strigi
{
  class daemonConfigurationType: public ::xsd::cxx::tree::type
  {
    public:

    struct _xsd_daemonConfigurationType
    {
      typedef ::xsd::cxx::tree::type base_;
    };

    // repository
    // 
    public:
    struct repository
    {
      typedef ::strigi::repositoryType type;
      typedef ::xsd::cxx::tree::traits< type > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const repository::container&
    repository () const;

    repository::container&
    repository ();

    void
    repository (const repository::container&);

    // Constructors.
    //
    public:
    daemonConfigurationType ();

    daemonConfigurationType (const ::xsd::cxx::xml::dom::element< char >&,
                             ::xsd::cxx::tree::flags,
                             ::xsd::cxx::tree::type*);

    daemonConfigurationType (const daemonConfigurationType&,
                             ::xsd::cxx::tree::flags = 0,
                             ::xsd::cxx::tree::type* = 0);

    virtual daemonConfigurationType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xsd::cxx::xml::dom::element< char >&,
           ::xsd::cxx::tree::flags);

    ::xsd::cxx::tree::sequence< repository::type > _xsd_repository_;
  };

  class repositoryType: public ::xsd::cxx::tree::type
  {
    public:

    struct _xsd_repositoryType
    {
      typedef ::xsd::cxx::tree::type base_;
    };

    // fileSystemSource
    // 
    public:
    struct fileSystemSource
    {
      typedef ::strigi::fileSystemSourceType type;
      typedef ::xsd::cxx::tree::traits< type > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const fileSystemSource::container&
    fileSystemSource () const;

    fileSystemSource::container&
    fileSystemSource ();

    void
    fileSystemSource (const fileSystemSource::container&);

    // httpSource
    // 
    public:
    struct httpSource
    {
      typedef ::strigi::httpSourceType type;
      typedef ::xsd::cxx::tree::traits< type > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const httpSource::container&
    httpSource () const;

    httpSource::container&
    httpSource ();

    void
    httpSource (const httpSource::container&);

    // repositoryLocation
    // 
    public:
    struct repositoryLocation
    {
      typedef ::xml_schema::uri type;
      typedef ::xsd::cxx::tree::traits< type > traits;
    };

    const repositoryLocation::type&
    repositoryLocation () const;

    repositoryLocation::type&
    repositoryLocation ();

    void
    repositoryLocation (const repositoryLocation::type&);

    void
    repositoryLocation (::std::auto_ptr< repositoryLocation::type >);

    // repositoryType
    // 
    public:
    struct repositoryType1
    {
      typedef ::strigi::repositoryTypeType type;
      typedef ::xsd::cxx::tree::traits< type > traits;
    };

    const repositoryType1::type&
    repositoryType1 () const;

    repositoryType1::type&
    repositoryType1 ();

    void
    repositoryType1 (const repositoryType1::type&);

    void
    repositoryType1 (::std::auto_ptr< repositoryType1::type >);

    // Constructors.
    //
    public:
    repositoryType (const repositoryLocation::type&,
                    const repositoryType1::type&);

    repositoryType (const ::xsd::cxx::xml::dom::element< char >&,
                    ::xsd::cxx::tree::flags,
                    ::xsd::cxx::tree::type*);

    repositoryType (const repositoryType&,
                    ::xsd::cxx::tree::flags = 0,
                    ::xsd::cxx::tree::type* = 0);

    virtual repositoryType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xsd::cxx::xml::dom::element< char >&,
           ::xsd::cxx::tree::flags);

    ::xsd::cxx::tree::sequence< fileSystemSource::type > _xsd_fileSystemSource_;
    ::xsd::cxx::tree::sequence< httpSource::type > _xsd_httpSource_;
    ::xsd::cxx::tree::one< repositoryLocation::type > _xsd_repositoryLocation_;
    ::xsd::cxx::tree::one< repositoryType1::type > _xsd_repositoryType1_;
  };

  class repositoryTypeType: public ::xml_schema::string
  {
    public:
    enum _xsd_repositoryTypeType
    {
      CLucene,
      HyperEstraier,
      Xapian,
      Sqlite
    };

    repositoryTypeType (_xsd_repositoryTypeType);

    repositoryTypeType (const ::xml_schema::string&);

    repositoryTypeType (const ::xsd::cxx::xml::dom::element< char >&,
                        ::xsd::cxx::tree::flags,
                        ::xsd::cxx::tree::type*);

    repositoryTypeType (const ::xsd::cxx::xml::dom::attribute< char >&,
                        ::xsd::cxx::tree::flags,
                        ::xsd::cxx::tree::type*);

    repositoryTypeType (const ::std::basic_string< char >&,
                        const ::xsd::cxx::xml::dom::element< char >*,
                        ::xsd::cxx::tree::flags,
                        ::xsd::cxx::tree::type*);

    repositoryTypeType (const repositoryTypeType&,
                        ::xsd::cxx::tree::flags = 0,
                        ::xsd::cxx::tree::type* = 0);

    virtual repositoryTypeType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;

    repositoryTypeType&
    operator= (_xsd_repositoryTypeType);

    virtual
    operator _xsd_repositoryTypeType () const
    {
      return _xsd_repositoryTypeType_convert ();
    }

    protected:
    _xsd_repositoryTypeType
    _xsd_repositoryTypeType_convert () const;

    public:
    static const char* const _xsd_repositoryTypeType_literals_[4];
    static const _xsd_repositoryTypeType _xsd_repositoryTypeType_indexes_[4];
  };

  class fileSourceType: public ::xsd::cxx::tree::type
  {
    public:

    struct _xsd_fileSourceType
    {
      typedef ::xsd::cxx::tree::type base_;
    };

    // baseURI
    // 
    public:
    struct baseURI
    {
      typedef ::xml_schema::uri type;
      typedef ::xsd::cxx::tree::traits< type > traits;
    };

    const baseURI::type&
    baseURI () const;

    baseURI::type&
    baseURI ();

    void
    baseURI (const baseURI::type&);

    void
    baseURI (::std::auto_ptr< baseURI::type >);

    // autoUpdateFrequence
    // 
    public:
    struct autoUpdateFrequence
    {
      typedef int type;
      typedef ::xsd::cxx::tree::traits< type > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const autoUpdateFrequence::container&
    autoUpdateFrequence () const;

    autoUpdateFrequence::container&
    autoUpdateFrequence ();

    void
    autoUpdateFrequence (const autoUpdateFrequence::type&);

    void
    autoUpdateFrequence (const autoUpdateFrequence::container&);

    // Constructors.
    //
    public:
    fileSourceType (const baseURI::type&);

    fileSourceType (const ::xsd::cxx::xml::dom::element< char >&,
                    ::xsd::cxx::tree::flags,
                    ::xsd::cxx::tree::type*);

    fileSourceType (const fileSourceType&,
                    ::xsd::cxx::tree::flags = 0,
                    ::xsd::cxx::tree::type* = 0);

    virtual fileSourceType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xsd::cxx::xml::dom::element< char >&,
           ::xsd::cxx::tree::flags);

    ::xsd::cxx::tree::one< baseURI::type > _xsd_baseURI_;
    ::xsd::cxx::tree::optional< autoUpdateFrequence::type > _xsd_autoUpdateFrequence_;
  };

  class fileSystemSourceType: public ::strigi::fileSourceType
  {
    public:

    struct _xsd_fileSystemSourceType
    {
      typedef ::strigi::fileSourceType base_;
    };

    // fileEventListener
    // 
    public:
    struct fileEventListener
    {
      struct _xsd_fileEventListener_
      {
        class fileEventListener: public ::xsd::cxx::tree::type
        {
          public:

          struct _xsd_fileEventListener
          {
            typedef ::xsd::cxx::tree::type base_;
          };

          // Constructors.
          //
          public:
          fileEventListener ();

          fileEventListener (const ::xsd::cxx::xml::dom::element< char >&,
                             ::xsd::cxx::tree::flags,
                             ::xsd::cxx::tree::type*);

          fileEventListener (const ::xsd::cxx::xml::dom::attribute< char >&,
                             ::xsd::cxx::tree::flags,
                             ::xsd::cxx::tree::type*);

          fileEventListener (const ::std::basic_string< char >&,
                             const ::xsd::cxx::xml::dom::element< char >*,
                             ::xsd::cxx::tree::flags,
                             ::xsd::cxx::tree::type*);

          fileEventListener (const fileEventListener&,
                             ::xsd::cxx::tree::flags = 0,
                             ::xsd::cxx::tree::type* = 0);

          virtual fileEventListener*
          _clone (::xsd::cxx::tree::flags = 0,
                  ::xsd::cxx::tree::type* = 0) const;
        };
      };

      typedef _xsd_fileEventListener_::fileEventListener type;
      typedef ::xsd::cxx::tree::traits< type > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const fileEventListener::container&
    fileEventListener () const;

    fileEventListener::container&
    fileEventListener ();

    void
    fileEventListener (const fileEventListener::type&);

    void
    fileEventListener (const fileEventListener::container&);

    void
    fileEventListener (::std::auto_ptr< fileEventListener::type >);

#if defined(__EDG_VERSION__) || (defined(__HP_aCC) && __HP_aCC >= 60000)
    public:
    using _xsd_fileSystemSourceType::base_::baseURI;
#endif

    // Constructors.
    //
    public:
    fileSystemSourceType (const baseURI::type&);

    fileSystemSourceType (const ::xsd::cxx::xml::dom::element< char >&,
                          ::xsd::cxx::tree::flags,
                          ::xsd::cxx::tree::type*);

    fileSystemSourceType (const fileSystemSourceType&,
                          ::xsd::cxx::tree::flags = 0,
                          ::xsd::cxx::tree::type* = 0);

    virtual fileSystemSourceType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xsd::cxx::xml::dom::element< char >&,
           ::xsd::cxx::tree::flags);

    ::xsd::cxx::tree::optional< fileEventListener::type > _xsd_fileEventListener_;
  };

  class httpSourceType: public ::strigi::fileSourceType
  {
    public:

    struct _xsd_httpSourceType
    {
      typedef ::strigi::fileSourceType base_;
    };

#if defined(__EDG_VERSION__) || (defined(__HP_aCC) && __HP_aCC >= 60000)
    public:
    using _xsd_httpSourceType::base_::baseURI;
#endif

    // Constructors.
    //
    public:
    httpSourceType (const baseURI::type&);

    httpSourceType (const ::xsd::cxx::xml::dom::element< char >&,
                    ::xsd::cxx::tree::flags,
                    ::xsd::cxx::tree::type*);

    httpSourceType (const httpSourceType&,
                    ::xsd::cxx::tree::flags = 0,
                    ::xsd::cxx::tree::type* = 0);

    virtual httpSourceType*
    _clone (::xsd::cxx::tree::flags = 0,
            ::xsd::cxx::tree::type* = 0) const;
  };
}

#include <iosfwd>

namespace strigi
{
  // Read from a URI or a local file.
  //

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >&,
                       ::xsd::cxx::xml::error_handler< char >&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::std::basic_string< char >&,
                       ::xercesc::DOMErrorHandler&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from std::istream.
  //

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       ::xsd::cxx::xml::error_handler< char >&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       ::xercesc::DOMErrorHandler&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       const ::std::basic_string< char >& id,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       const ::std::basic_string< char >& id,
                       ::xsd::cxx::xml::error_handler< char >&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (::std::istream&,
                       const ::std::basic_string< char >& id,
                       ::xercesc::DOMErrorHandler&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from InputSource.
  //

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource&,
                       ::xsd::cxx::xml::error_handler< char >&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMInputSource&,
                       ::xercesc::DOMErrorHandler&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from DOM.
  //

  ::std::auto_ptr< ::strigi::daemonConfigurationType >
  daemonConfiguration (const ::xercesc::DOMDocument&,
                       ::xsd::cxx::tree::flags = 0,
                       const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());
}

#include <iosfwd> // std::ostream&

#include <xsd/cxx/tree/serialization.hxx>

namespace strigi
{
  // Serialize to an existing DOM instance.
  //
  void
  daemonConfiguration (::xercesc::DOMDocument&,
                       const ::strigi::daemonConfigurationType&,
                       ::xsd::cxx::tree::flags = 0);


  // Serialize to a new DOM instance.
  //
  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  daemonConfiguration (const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       ::xsd::cxx::tree::flags = 0);


  // Serialize to XMLFormatTarget.
  //
  void
  daemonConfiguration (::xercesc::XMLFormatTarget&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);


  void
  daemonConfiguration (::xercesc::XMLFormatTarget&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       ::xsd::cxx::xml::error_handler< char >&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);

  void
  daemonConfiguration (::xercesc::XMLFormatTarget&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       ::xercesc::DOMErrorHandler&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);


  // Serialize to std::ostream.
  //
  void
  daemonConfiguration (::std::ostream&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);


  void
  daemonConfiguration (::std::ostream&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       ::xsd::cxx::xml::error_handler< char >&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);

  void
  daemonConfiguration (::std::ostream&,
                       const ::strigi::daemonConfigurationType&, 
                       const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
                       ::xercesc::DOMErrorHandler&,
                       const ::std::basic_string< char >& = "UTF-8",
                       ::xsd::cxx::tree::flags = 0);


  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const daemonConfigurationType&);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const repositoryType&);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              repositoryTypeType);

  void
  operator<< (::xsd::cxx::xml::dom::attribute< char >&,
              repositoryTypeType);

  void
  operator<< (::xsd::cxx::xml::dom::list_stream< char >&,
              repositoryTypeType);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const fileSourceType&);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const fileSystemSourceType::fileEventListener::type&);

  void
  operator<< (::xsd::cxx::xml::dom::attribute< char >&,
              const fileSystemSourceType::fileEventListener::type&);

  void
  operator<< (::xsd::cxx::xml::dom::list_stream< char >&,
              const fileSystemSourceType::fileEventListener::type&);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const fileSystemSourceType&);

  void
  operator<< (::xsd::cxx::xml::dom::element< char >&,
              const httpSourceType&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // STRIGIDAEMON_HXX
