; strip-club-win.nsi
;
;
;--------------------------------
; The name of the installer
Name "Strip Club 0.9.1.2 (Win32)"
; The file to write
OutFile "stripclub-win-0.9.1.2.exe"
;  Caption Text for Exe
Caption "Strip Club 0.9.1.2 Installer"
; The default installation directory
InstallDir "$PROGRAMFILES\Strip Club"
;  License Info
LicenseText "Welcome to the Strip Club 0.9.1.2 Installer. Please read the License Agreement below:"
LicenseData "gplshort.txt"
;Version Variable for RegKey
Var VERSION
Section ver_control
StrCpy $VERSION  "0.9.1.2"
SectionEnd
;--------------------------------
; Pages
Page license
;Page components
Page directory
Page instfiles
UninstPage uninstConfirm
UninstPage instfiles
;--------------------------------
;  Section for install types, not used yet.
;!ifndef NOINSTTYPES ; only if not defined
;  InstType "Full"
;  InstType "Base"
;!endif
;AutoCloseWindow false
;ShowInstDetails show
;--------------------------------
Section "" ; empty string makes it hidden, so would starting with -
; write reg entries	
  WriteRegStr HKLM SOFTWARE\StripClub "Install_Dir" "$INSTDIR"
  WriteRegStr HKLM SOFTWARE\StripClub "Version" "$VERSION"
; write uninstall strings - When we get an uninstaller setup...
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StripClub" "DisplayName" "Strip Club (Uninstall ONLY)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StripClub" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StripClub" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StripClub" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
SectionEnd
;--------------------------------
; The stuff to install
Section "Install" ;No components page, name is not important
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File stripclub.exe
  File readme.txt
  File Changelog
  File COPYING
  File FAQ
 
SectionEnd ; end the section
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\Strip Club"
  CreateShortCut "$SMPROGRAMS\Strip Club\Strip Club.lnk" "$INSTDIR\stripclub.exe" "" "$INSTDIR\stripclub.exe" 0
  CreateShortCut "$SMPROGRAMS\Strip Club\Read Me!.lnk" "$INSTDIR\readme.txt" "" "$INSTDIR\readme.txt" 0
  
SectionEnd
;--------------------------------
; Uninstaller
Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\StripClub"
  DeleteRegKey HKLM SOFTWARE\StripClub
  ; Remove files and uninstaller
  Delete $INSTDIR\stripclub.exe
  Delete $INSTDIR\readme.txt
  Delete $INSTDIR\Changelog
  Delete $INSTDIR\COPYING
  Delete $INSTDIR\FAQ
  Delete $INSTDIR\uninstall.exe
  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Strip Club\*.*"
  ; Remove directories used
  RMDir "$SMPROGRAMS\Strip Club"
  RMDir "$INSTDIR"
SectionEnd
