/* Object identifiers (OIDs) used by strongSwan
 * Copyright (C) 2003-2008 Andreas Steffen, Hochschule fuer Technik Rapperswil
 * 
 * This file has been automatically generated by the script oid.pl
 * Do not edit manually!
 */

#include <sys/types.h>

#ifndef OID_H_
#define OID_H_

typedef struct {
    u_char octet;
    u_int  next;
    u_int  down;
    u_int  level;
    const u_char *name;
} oid_t;

extern const oid_t oid_names[];

#define OID_UNKNOWN							-1
#define OID_NAME_DISTINGUISHER				6
#define OID_PILOT_USERID					16
#define OID_PILOT_DOMAIN_COMPONENT			17
#define OID_COMMON_NAME						20
#define OID_SURNAME							21
#define OID_SERIAL_NUMBER					22
#define OID_COUNTRY							23
#define OID_LOCALITY						24
#define OID_STATE_OR_PROVINCE				25
#define OID_ORGANIZATION					26
#define OID_ORGANIZATION_UNIT				27
#define OID_TITLE							28
#define OID_DESCRIPTION						29
#define OID_USER_CERTIFICATE				30
#define OID_NAME							31
#define OID_GIVEN_NAME						32
#define OID_INITIALS						33
#define OID_UNIQUE_IDENTIFIER				34
#define OID_ROLE							35
#define OID_SUBJECT_KEY_ID					38
#define OID_SUBJECT_ALT_NAME				41
#define OID_BASIC_CONSTRAINTS				43
#define OID_CRL_NUMBER						44
#define OID_CRL_REASON_CODE					45
#define OID_CRL_DISTRIBUTION_POINTS			46
#define OID_AUTHORITY_KEY_ID				48
#define OID_EXTENDED_KEY_USAGE				49
#define OID_TARGET_INFORMATION				50
#define OID_NO_REV_AVAIL					51
#define OID_CAMELLIA128_CBC					62
#define OID_CAMELLIA192_CBC					63
#define OID_CAMELLIA256_CBC					64
#define OID_RSA_ENCRYPTION					77
#define OID_MD2_WITH_RSA					78
#define OID_MD5_WITH_RSA					79
#define OID_SHA1_WITH_RSA					80
#define OID_SHA256_WITH_RSA					81
#define OID_SHA384_WITH_RSA					82
#define OID_SHA512_WITH_RSA					83
#define OID_PKCS7_DATA						85
#define OID_PKCS7_SIGNED_DATA				86
#define OID_PKCS7_ENVELOPED_DATA			87
#define OID_PKCS7_SIGNED_ENVELOPED_DATA		88
#define OID_PKCS7_DIGESTED_DATA				89
#define OID_PKCS7_ENCRYPTED_DATA			90
#define OID_PKCS9_EMAIL						92
#define OID_PKCS9_CONTENT_TYPE				94
#define OID_PKCS9_MESSAGE_DIGEST			95
#define OID_PKCS9_SIGNING_TIME				96
#define OID_MD2								103
#define OID_MD5								104
#define OID_3DES_EDE_CBC					106
#define OID_EC_PUBLICKEY					110
#define OID_C2PNB163V1						113
#define OID_C2PNB163V2						114
#define OID_C2PNB163V3						115
#define OID_C2PNB176W1						116
#define OID_C2PNB191V1						117
#define OID_C2PNB191V2						118
#define OID_C2PNB191V3						119
#define OID_C2PNB191V4						120
#define OID_C2PNB191V5						121
#define OID_C2PNB208W1						122
#define OID_C2PNB239V1						123
#define OID_C2PNB239V2						124
#define OID_C2PNB239V3						125
#define OID_C2PNB239V4						126
#define OID_C2PNB239V5						127
#define OID_C2PNB272W1						128
#define OID_C2PNB304W1						129
#define OID_C2PNB359V1						130
#define OID_C2PNB368W1						131
#define OID_C2PNB431R1						132
#define OID_PRIME192V1						134
#define OID_PRIME192V2						135
#define OID_PRIME192V3						136
#define OID_PRIME239V1						137
#define OID_PRIME239V2						138
#define OID_PRIME239V3						139
#define OID_PRIME256V1						140
#define OID_ECDSA_WITH_SHA1					142
#define OID_TCGID							163
#define OID_AUTHORITY_INFO_ACCESS			168
#define OID_OCSP_SIGNING					178
#define OID_XMPP_ADDR						180
#define OID_AUTHENTICATION_INFO				182
#define OID_ACCESS_IDENTITY					183
#define OID_CHARGING_IDENTITY				184
#define OID_GROUP							185
#define OID_OCSP							187
#define OID_BASIC							188
#define OID_NONCE							189
#define OID_CRL								190
#define OID_RESPONSE						191
#define OID_NO_CHECK						192
#define OID_ARCHIVE_CUTOFF					193
#define OID_SERVICE_LOCATOR					194
#define OID_CA_ISSUERS						195
#define OID_DES_CBC							199
#define OID_SHA1							200
#define OID_SHA1_WITH_RSA_OIW				201
#define OID_SECT163K1						212
#define OID_SECT163R1						213
#define OID_SECT239K1						214
#define OID_SECT113R1						215
#define OID_SECT113R2						216
#define OID_SECT112R1						217
#define OID_SECT112R2						218
#define OID_SECT160R1						219
#define OID_SECT160K1						220
#define OID_SECT256K1						221
#define OID_SECT163R2						222
#define OID_SECT283K1						223
#define OID_SECT283R1						224
#define OID_SECT131R1						225
#define OID_SECT131R2						226
#define OID_SECT193R1						227
#define OID_SECT193R2						228
#define OID_SECT233K1						229
#define OID_SECT233R1						230
#define OID_SECT128R1						231
#define OID_SECT128R2						232
#define OID_SECT160R2						233
#define OID_SECT192K1						234
#define OID_SECT224K1						235
#define OID_SECT224R1						236
#define OID_SECT384R1						237
#define OID_SECT521R1						238
#define OID_SECT409K1						239
#define OID_SECT409R1						240
#define OID_SECT571K1						241
#define OID_SECT571R1						242
#define OID_AES128_CBC						251
#define OID_AES128_GCM						252
#define OID_AES128_CCM						253
#define OID_AES192_CBC						254
#define OID_AES192_GCM						255
#define OID_AES192_CCM						256
#define OID_AES256_CBC						257
#define OID_AES256_GCM						258
#define OID_AES256_CCM						259
#define OID_SHA256							261
#define OID_SHA384							262
#define OID_SHA512							263
#define OID_SHA224							264
#define OID_NS_REVOCATION_URL				270
#define OID_NS_CA_REVOCATION_URL			271
#define OID_NS_CA_POLICY_URL				272
#define OID_NS_COMMENT						273
#define OID_EMPLOYEE_NUMBER					276
#define OID_PKI_MESSAGE_TYPE				282
#define OID_PKI_STATUS						283
#define OID_PKI_FAIL_INFO					284
#define OID_PKI_SENDER_NONCE				285
#define OID_PKI_RECIPIENT_NONCE				286
#define OID_PKI_TRANS_ID					287
#define OID_EMAIL_ADDRESS					294
#define OID_UNSTRUCTURED_NAME				295

#define OID_MAX								296

#endif /* OID_H_ */
