/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [dicts.h]               Type: Dictionary Iterator                        */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef dicts_INCL
#define dicts_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ---------------------- The Type ----------------------------------------- */

/*  
   The dictionary iterator provides sequentiell, platform-independant access to
   a specified part of the file system.
   Supported platforms are Unix and Windows.
*/

AbstractType(DII); /* Abstract dictionary iterator type */

/* --------------------------- Create & Drop -------------------------------- */

DII DII_make
    (
      c_string PathName, c_string Pattern,
      c_bool recursive, c_bool skipErr
    )
/* creates a ['recursive'] dictionary iterator for
   directory 'PathName' and file 'Pattern'
   'skipErr' --> error message on open failure, otherwise the program aborts
*/
;

void DII_drop(DII dii);                /* drops dictionary iterator 'dii'   */

/* ------------------------- Dictionary iterator access -------------------- */

c_bool   DII_empty(DII dii);     /* empty dictionary iterator ?             */
void     DII_next(DII dii);      /* next dictionary entry                   */
c_bool   DII_isFile(DII dii);    /* dictionary entry = file ?               */
c_bool   DII_isDir(DII dii);     /* dictionary entry = directory ?          */
c_bool   DII_isCDev(DII dii);    /* dictionary entry = character device ?   */
c_bool   DII_isBDev(DII dii);    /* dictionary entry = block device ?       */
c_bool   DII_isFifo(DII dii);    /* dictionary entry = FIFO ?               */

c_string DII_get_file(DII dii)
/* filename of dictionary entry; allocs memory */
;

c_string DII_get_base(DII dii)
/* basename of dictionary entry; allocs memory */
;

c_string DII_get_ext(DII dii)
/* extension of dictionary entry; allocs memory */
;

c_string DII_get_path(DII dii);  /* path of dictionary entry; allocs memory */

/* ---------------------- Convenient iterator macros ----------------------- */

#define DII_FORALL(dii,Path,Pattern)           \
for (dii = DII_make(Path,Pattern,C_False,C_False); \
DII_empty(dii)?DII_drop(dii),C_False:C_True; DII_next(dii))

#define DII_FORALL_R(dii,Path,Pattern)        \
for (dii = DII_make(Path,Pattern,C_True,C_False); \
DII_empty(dii)?DII_drop(dii),C_False:C_True; DII_next(dii))

#define DII_SFORALL(dii,Path,Pattern)         \
for (dii = DII_make(Path,Pattern,C_False,C_True); \
DII_empty(dii)?DII_drop(dii),C_False:C_True; DII_next(dii))

#define DII_SFORALL_R(dii,Path,Pattern)      \
for (dii = DII_make(Path,Pattern,C_True,C_True); \
DII_empty(dii)?DII_drop(dii),C_False:C_True; DII_next(dii))


#ifdef __cplusplus
}
#endif

#endif
