/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [glo_tab.h]                   Global Table                               */
/*                                                                          */
/* Copyright (c) 1993 by Lars D\olle, Heike Manns                           */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef glo_tab_INCL
#define glo_tab_INCL


#include "standard.h"
#include "symbols.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
   <p>Through the means of the module [glo_tab] it is possible to store and retrieve
   arbitrary pairs ( key, value ) with a bijective mapping between them.
   <p>This defines a special global process memory.
   <p>Originally this functionality was needed in order to make statically bind C-functions
   persistent. ( see also <a href="binimg.htm">[binimg]</a> )
   <p>In addition this module handles i.e. keeps track of dynamical loaded objects.<br><br>
*/

/* ----------------------------- Init & Quit -------------------------------- */

void Glo_init(void);                   /* inits [glo_tab]                   */
void Glo_quit(void);                   /* quits [glo_tab]                   */

/* ----------------------------- Table access ------------------------------- */

void Glo_def(symbol Name, Abs_T Value)
/* adds global ( 'Name' <--> 'Value' ) */
;

void   Glo_rmv(symbol Name);           /* deletes global 'Name'             */
c_bool Glo_key_known(symbol Name);     /* whether 'Name' is defined         */
c_bool Glo_val_known(Abs_T Value);     /* whether 'Value' is defined        */

Abs_T Glo__val(symbol Name)
#define Glo_val(T,N) ((T)Glo__val(N))
/* value defined for 'Name' */
;

symbol Glo_key(Abs_T Value);           /* name defined for 'Value'          */

symbol Glo_objkey_mk(symbol Lib, symbol Obj)
/* constructs key for loadable object */
;

c_bool Glo_objkey_de(symbol glokey, symbol* Lib, symbol* Obj)
/* destructs key of loadable object */
;

StdCPtr Glo_load(symbol Lib, symbol Obj, c_bool saveObj)
/* loads the object if not already defined
   'saveObj' --> saves it in the global table
*/
;



#ifdef __cplusplus
}
#endif

#endif
