/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHCANVASITEMS_H
#define _SC_LOGGRAPHCANVASITEMS_H

// sc
#include "LogGraphNode.h"
namespace svn {
  class Revision;
}

// qt
#include <qcanvas.h>
#include <qstring.h>


/**
 * base class for LogGraph canvas items.
 */
class LogGraphCanvasItem : public QCanvasRectangle
{
public:
  LogGraphCanvasItem( QCanvas* canvas );
  virtual ~LogGraphCanvasItem();

  virtual QString getPath() const = 0;
  virtual svn::Revision* getRev() const = 0;
};


/**
 * a canvas item that represents a single revision in the log graph.
 */
class LogGraphCanvasRev : public LogGraphCanvasItem
{
  typedef LogGraphCanvasItem super;

public:
  LogGraphCanvasRev( QCanvas* canvas, LogGraphNodePtr node );

  void drawShape( QPainter &p );

  LogGraphNodePtr getNode();

  //LogGraphCanvasItem
  QString getPath() const;
  svn::Revision* getRev() const;

private:
  LogGraphNodePtr _node;
};


/**
 * a canvas item that represents a revision path in the log graph.
 */
class LogGraphCanvasPath : public LogGraphCanvasItem
{
  typedef LogGraphCanvasItem super;

public:
  LogGraphCanvasPath( QCanvas* canvas, const QString& initialName );

  void drawShape( QPainter &p );

  QString getFitName( QPainter &p );
  QString getFullName();
  void addNewName( const QString& name );

  //LogGraphCanvasItem
  QString getPath() const;
  svn::Revision* getRev() const;

private:
  QString _initialName;
  QString _newestName;
};


#endif // _SC_LOGGRAPHCANVASITEMS_H
