/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "UpdateDialog.h"
#include "RevisionWidget.h"
#include "ExternProvider.h"
#include "sublib/Gui.h"
#include "sublib/ExternButton.h"
#include "util/String.h"

// qt
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qtooltip.h>
#include <qcheckbox.h>



UpdateDialog::UpdateDialog( ExternProvider* p, bool recurse, QWidget *parent )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _p(p)
{
  setCaption( _q("subcommander:update") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("update options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,1,3);
    gl->setMargin(0);
    gl->setRowStretch( 1, 1 );
    {
      {
        QLabel* l = new QLabel(this);
        _wc       = new QComboBox(this);
        _wcEx     = new ExternButton(this);

        l->setBuddy(_wcEx);
        l->setText( _q("&working copy path:") );
        l->setFixedWidth( l->sizeHint().width() );
        _wc->setEditable(true);
        _wc->setAutoCompletion(true);

        gl->addWidget(l,1,0);
        gl->addWidget(_wc,1,1); 
        gl->addWidget(_wcEx,1,2); 

        connect( _wc, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        connect( _wcEx, SIGNAL(clicked()), SLOT(selectWcPath()) );

        QToolTip::add( _wc, _q("the local working copy you want to update") );
      }
    }

    QHBoxLayout* h1 = new QHBoxLayout;
    h1->setAlignment(Qt::AlignTop);
    vbl->addLayout(h1);
    {
      _rw = new RevisionWidget(false,"SDN","H",0,this);
      h1->addWidget( _rw );
    }

    _recurse = new QCheckBox(_q("&recursive"),this);
    _recurse->setChecked(recurse);
    vbl->addWidget(_recurse);

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);
      
      hu->addSpacing(getSizeGripSpacing());

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

UpdateDialog::~UpdateDialog()
{
}

void UpdateDialog::selectWcPath()
{
  sc::String res;

  if( _p->selectPath( this, sc::String(_wc->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _wc->insertItem( QString::fromUtf8(res), 0 );
  }
}

void UpdateDialog::setWorkingCopyPath( QString& path )
{
  _wc->insertItem( path, 0 );
}

QString UpdateDialog::getWorkingCopyPath()
{
  return _wc->currentText();
}

svn::Revision* UpdateDialog::getRevision()
{
  return _rw->getRevision();
}

bool UpdateDialog::isRecursive()
{
  return _recurse->isChecked();
}

void UpdateDialog::enableWorkingCopyPath( bool enable )
{
  _wc->setEnabled(enable);
  _wcEx->setEnabled(enable);
}

void UpdateDialog::checkOk( const QString& text )
{
  QString wc  = _wc->currentText();

  if( ! wc.isEmpty()  )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }
}
