/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CheckoutCmd.h"
#include "CheckoutParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


CheckoutCmd::CheckoutCmd( CheckoutParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

CheckoutCmd::~CheckoutCmd()
{
  delete _cb;
}

void CheckoutCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->checkout( &_param->getRevnumber(), _param->getUrl(), _param->getPath(),
    *_param->getPegRevision(), *_param->getRevision(), _param->getRecurse() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
