/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_INFOCMD_H
#define _SC_INFOCMD_H

// sc
#include "ScCmd.h"
class InfoParam;
class CmdResultCallback;


/**
 * Command for getting detailed info of an working copy or repository item.
 */
class InfoCmd : public ScCmd
{
public:
  /**
   * Construct an InfoCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  InfoCmd( InfoParam* param, CmdResultCallback* cb );
  ~InfoCmd();

  void run();

private:
  // in
  InfoParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_INFOCMD_H
