/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LockCmd.h"
#include "LockParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


LockCmd::LockCmd( LockParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

LockCmd::~LockCmd()
{
  delete _cb;
}

void LockCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->lock( _param->getPathsOrUrls(), _param->getComment(), _param->getStealLocks() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
