/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CHECKOUTDIALOGCMD_H
#define _SC_CHECKOUTDIALOGCMD_H

// sc
#include "util/Id.h"
class BaseModel;
class Project;

// qt
#include <qstring.h>
class QWidget;

/**
 * Helper class to run a dialog based checkout.
 */ 
class CheckoutDialogCmd
{
public:
  CheckoutDialogCmd( QWidget* parent, ID tid, BaseModel* model );

  void run( const QString& src, const QString& dst, Project* prj );

private:
  QWidget*   _parent;
  ID         _tid;
  BaseModel* _model;
};

#endif // _SC_CHECKOUTDIALOGCMD_H
