/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CommitDialogCmd.h"
#include "../CommitDialog.h"
#include "../WcModel.h"

// qt
#include <qmessagebox.h>


CommitDialogCmd::CommitDialogCmd( QWidget* parent, ID tid, WcModel* model )
: _parent(parent), _tid(tid), _model(model)
{
}

void CommitDialogCmd::run( svn::Paths paths )
{
#if 0
  if( _model->isTagWorkingCopy() )
  {
    int answer = QMessageBox::question( _parent, _q("subcommander:commit"),
      _q("Your current working copy is a 'tag'!\nCommit anyway?"),
      QMessageBox::Yes, QMessageBox::Cancel );

    if( answer != QMessageBox::Yes )
    {
      return;
    }
  }
#endif

  CommitDialog* dlg = new CommitDialog( true, _model->getModel(), _parent, _tid );
  dlg->setPaths(paths);
 
  dlg->exec();
  
  delete dlg;
}
