/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTSETTINGSINFO_H
#define _SC_PROJECTSETTINGSINFO_H

// sc
#include "sublib/settings/SettingsInfoBase.h"
class SettingsWidget;
class Project;

// qt
#include <qstring.h>


class ProjectSettingsInfo : public SettingsInfoBase
{
public:
  ProjectSettingsInfo( const QString& title, const QString& id, Project* prj );
  ProjectSettingsInfo( const QString& title, const QString& id, int sortIndex );
  ~ProjectSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString  _title;
  QString  _id;

  int      _sortIndex;
  Project* _orgPrj;
  Project* _modPrj;
};


#endif //  _SC_PROJECTSETTINGSINFO_H
