/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ColorSettingsWidget.h"
#include "sublib/ExternButton.h"

// qt
#include <qlayout.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qcolordialog.h>

// sys
#include <assert.h>


/////////////////////////////////////////////////////////////////////


class ColorLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  ColorLvi( QListView* parent, const Color& color )
    : super(parent,color._name), _color(color)
  {
  }

  virtual ~ColorLvi()
  {
  }

  void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment )
  {
    if( column == 0 )
    {
      super::paintCell(p,cg,column,width,alignment);
    }
    else
    {
      QColorGroup g(cg);
      g.setColor( QColorGroup::Base, _color._color );
      super::paintCell(p,g,column,width,alignment);
    }
  }

  const Color& getColor()
  {
    return _color;
  }

  void setColor( const Color& c )
  {
    _color = c;
  }

private:
  Color _color;
};


/////////////////////////////////////////////////////////////////////

ColorSettingsWidget::ColorSettingsWidget( QWidget *parent )
: super(parent,0)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  vl->setSpacing(5);
  {
    _clist = new QListView(this);
    _clist->addColumn( "color type" );
    _clist->addColumn( "color" );
    _clist->setColumnWidthMode( 0, QListView::Maximum );
    //_clist->setColumnAlignment( 0, Qt::AlignHCenter );
    _clist->setResizeMode( QListView::LastColumn );
    _clist->setItemMargin( 2 );
    vl->addWidget(_clist);
    _clist->adjustColumn(0);

    connect( _clist, SIGNAL(doubleClicked( QListViewItem*, const QPoint&, int )),
      SLOT(doubleClicked( QListViewItem*, const QPoint&, int )) );

    connect( _clist, SIGNAL(clicked(QListViewItem*)), SLOT(clicked(QListViewItem*)) );

    _desc = new QLabel(this);
    vl->addWidget(_desc);
  }
}

ColorSettingsWidget::~ColorSettingsWidget()
{
}

void ColorSettingsWidget::doubleClicked( QListViewItem* lvi, const QPoint&, int )
{
  ColorLvi* clvi  = dynamic_cast<ColorLvi*>(lvi);
  Color     color = clvi->getColor();
  QColor  choosen = QColorDialog::getColor( color._color, this );

  if( choosen.isValid() && choosen != color._color )
  {
    color._color = choosen;
    clvi->setColor(color);
    clvi->repaint();
    emit modified();
  }
}

void ColorSettingsWidget::clicked( QListViewItem* lvi )
{
  ColorLvi* clvi  = dynamic_cast<ColorLvi*>(lvi);
  if( ! clvi )
  {
    return;
  }

  _desc->setText( clvi->getColor()._desc );
}


void ColorSettingsWidget::setColors( const Colors& colors )
{
  _clist->clear();

  for( Colors::const_iterator it = colors.begin(); it != colors.end(); it++ )
  {
    const Color& c = *it;
    new ColorLvi( _clist, c );
  }
}

void ColorSettingsWidget::getColors( Colors& colors )
{
  QListViewItemIterator it( _clist );
  while( it.current() )
  {
    ColorLvi* lvi = dynamic_cast<ColorLvi*>(it.current());

    colors.push_back( lvi->getColor() );

    ++it;
  }
}
