/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "stdafx.h"

// cppunit
#include <cppunit/TextTestRunner.h>
#include <cppunit/TestResult.h>
#include <cppunit/CompilerOutputter.h>
#include "debugstream.h"

// sc
#include "util/apr.h"

///////////////////////////////////////////////////////////////////////////////
// tests..

#include "sc/StatusCacheTest.h"
#include "sc/WcStatusInfoTest.h"
#include "merge/LineTokenizerTest.h"
#include "lib/TextModelTest.h"
#include "lib/TextModelTestRemove.h"
#include "lib/TabTest.h"
#include "lib/StringUtilTest.h"
#include "svn/DiffTest.h"
#include "svn/ClientStaticTest.h"
#include "util/FileTest.h"
#include "util/CommandArgsTest.h"
#include "util/UtfTest.h"

///////////////////////////////////////////////////////////////////////////////
// entry point

int main(int argc, char* argv[])
{
  apr::initialize( argc, argv );
  apr_pool_t *pool = apr::createPool();

  dostream                ostream;
  CppUnit::TextTestRunner runner;

  runner.setOutputter( new CppUnit::CompilerOutputter(&runner.result(),ostream) ); 

  // tests...

  // sc
#if 1
  runner.addTest( StatusCacheTest::suite() );
  runner.addTest( WcStatusInfoTest::suite() );
#endif

  // merge
#if 1
  runner.addTest( LineTokenizerTest::suite() );
#endif

  // lib
#if 1
  runner.addTest( TextModelTest::suite() );
  runner.addTest( TextModelTestRemove::suite() );
  runner.addTest( TabTest::suite() );
  runner.addTest( StringUtilTest::suite() );
#endif

  // svn
#if 1
  runner.addTest( DiffTest::suite() );
  runner.addTest( ClientStaticTest::suite() );
#endif

  // util
#if 1
  runner.addTest( FileTest::suite() );
  runner.addTest( CommandArgsTest::suite() );
  runner.addTest( UtfTest::suite() );
#endif

  // run test...
  runner.run();

	return EXIT_SUCCESS;
}