/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_APR_H
#define _SC_UTIL_APR_H

// sc
#include "Error.h"

// apr
#include <apr_errno.h>
struct apr_pool_t;



/** factory methods for an Error based on an apr_status_t */
#define createErrorApr(status) createError(status,apr::strError(status))


namespace apr
{

// setup
void initialize( int argc, char* argv[] );

// pools
apr_pool_t* createPool( apr_pool_t* parent = 0 );
void        destroyPool( apr_pool_t* pool );

// portable
sc::String getDefaultEncoding();
sc::String getLocaleEncoding();

// errors
sc::String strError( apr_status_t status );


/**
 * \brief scoped apr pool.
 */
class Pool
{
public:
  Pool( apr_pool_t* parent = 0, bool subpool = true )
  {
    if( subpool )
    {
      _pool = createPool(parent);
    }
    else
    {
      _pool = parent;
    }
  }

  ~Pool()
  {
    destroyPool(_pool);
  }

  operator apr_pool_t*() const
  {
    return _pool;
  }

private:
  apr_pool_t* _pool;
};


} // namespace


/** helper macro */

#define APR_ERR(status)\
{\
  if( status != APR_SUCCESS )\
  {\
    return createError(status,apr::strError(status));\
  }\
}


#endif // _SC_UTIL_APR_H

