/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARKVIEWPROXYMODEL_H
#define _SC_BOOKMARKVIEWPROXYMODEL_H

// sc
class Bookmark;

// qt
#include <QtGui/QSortFilterProxyModel>

/**
 * Proxy model for BookmarkView. It hides incomplete (no source) bookmarks.
 */
class BookmarkViewProxyModel : public QSortFilterProxyModel
{
  typedef QSortFilterProxyModel super;
  Q_OBJECT

public:
  BookmarkViewProxyModel();
  ~BookmarkViewProxyModel();

  /** Filter @a sourceRow. */
  bool filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const;

  /** delegated to source model. */
  QModelIndex index( Bookmark* bookmark );
};

#endif // _SC_BOOKMARKVIEWPROXYMODEL_H
