/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "config.h"
#include "ExternProviderImpl.h"
#include "ScModel.h"
#include "BaseModel.h"
#include "RepoModel.h"
#include "RepositoryDialog.h"
#include "sublib/MessageBox.h"

// qt
#include <QtGui/QFileDialog>

// svn
#include <svn_path.h>


ExternProviderImpl::ExternProviderImpl( ScModel* model )
: _model(model)
{
}

ExternProviderImpl::ExternProviderImpl( BaseModel* model )
: _model(model->getModel())
{
}

ExternProviderImpl::~ExternProviderImpl()
{
}

bool ExternProviderImpl::selectUrl( QWidget* parent, const sc::String& src,
  sc::String& result, long flags )
{
  if( src.isEmpty() || ! svn_path_is_url(src) )
  {
    QString qsrc = src.isEmpty() ? _q("<empty>") : QString::fromUtf8(src);
    QString msg = QString(_q("'%1' is not a valid repository url!")).arg(qsrc);
    msgWarning( _q("subcommander"), msg, _q("&Cancel") );
    return false;
  }
  
  RepoModel model( src, _model );

  RepositoryDialog* dlg = new RepositoryDialog( &model, parent );
  dlg->setDirsOnly( (flags & ExternProvider::Dir) == ExternProvider::Dir );

  int dlgres = dlg->exec();
  if( dlgres == QDialog::Accepted )
  {
    result = dlg->getSelection();
    return true;
  }
  else
  {
    return false;
  }
}

bool ExternProviderImpl::selectPath( QWidget* parent, const sc::String& src,
  sc::String& result, long flags )
{
  // select folder
  if( (flags & ExternProvider::Dir) == ExternProvider::Dir )
  {
    QString qsrc = QString::fromUtf8(src);
    QString qres = QFileDialog::getExistingDirectory( qsrc, parent /*, "dir", "subcommander:select dir"*/ );
    result = qres.utf8();

    return qres != QString::null;
  }
  else
  {
    QString qsrc = QString::fromUtf8(src);
    QString qres = QFileDialog::getSaveFileName( qsrc, "", parent /*, "file", "subcommander:select file"*/ );
    result = qres.utf8();

    return qres != QString::null;
  }
}
