/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "Notify.h"
#include "LogData.h"
#include "StatusId.h"
#include "events/LoggingEvent.h"
#include "svn/WcNotify.h"

// qt
#include <QtGui/QApplication>


Notify::Notify( unsigned long lid ) : _lid(lid)
{
}

void Notify::notify( svn::WcNotifyPtr wcNotify )
{
  // ignore these...
  switch( wcNotify->getAction() )
  {
    case svn::WcNotify_StatusCompleted:
    case svn::WcNotify_UpdateCompleted:
      return;
    default:
      break;
  }

  LogData* data = new LogData( _lid, Log::Running | getType(wcNotify),
    getAction(wcNotify), getStatus(wcNotify), getMessage(wcNotify) ); 

  post(data);
}

void Notify::post( const LogData* data )
{
  qApp->postEvent( qApp->mainWidget(), new LoggingEvent(data) );
}

sc::String Notify::getAction( svn::WcNotifyPtr wcNotify )
{
  switch( wcNotify->getAction() )
  {
  case svn::WcNotify_Add:
  case svn::WcNotify_CommitAdded:
    return _s("added");

  case svn::WcNotify_Copy:
    return _s("copied");

  case svn::WcNotify_Delete:
  case svn::WcNotify_CommitDeleted:
    return _s("deleted");

  case svn::WcNotify_Restore:
    return _s("restored");

  case svn::WcNotify_Revert:
    return _s("reverted");

  case svn::WcNotify_FailedRevert:
    return _s("revert failed");

  case svn::WcNotify_Resolved:
    return _s("resolved");

  case svn::WcNotify_Skip:
    return _s("skipped");

  case svn::WcNotify_UpdateDelete:
    return _s("deleted");

  case svn::WcNotify_UpdateAdd:
    return _s("added");

  case svn::WcNotify_UpdateUpdate:
    return _s("updated");

  // ignored
  case svn::WcNotify_StatusCompleted:
  case svn::WcNotify_UpdateCompleted:
    return _s("completed");

  case svn::WcNotify_StatusExternal:
  case svn::WcNotify_UpdateExternal:
    return _s("external");

  case svn::WcNotify_CommitModified:
    return _s("modified");

  case svn::WcNotify_CommitReplaced:
    return _s("replaced");

  case svn::WcNotify_CommitPostfixTxdelta:
    return _s("transfered");

  case svn::WcNotify_BlameRevision:
    return _s("revision");

  case svn::WcNotify_Locked:
    return _s("locked");

  case svn::WcNotify_Unlocked:
    return _s("unlocked");

  case svn::WcNotify_FailedLock:
  case svn::WcNotify_FailedUnlock:
    return _s("failed");

  default:
    return sc::String("*unknown*");
  }
}

sc::String Notify::getStatus( svn::WcNotifyPtr wcNotify )
{
  sc::String result;

  switch( wcNotify->getStatus() )
  {
  case svn::WcNotifyState_Inapplicable:
    result += sc::NullString;
    break;
  case svn::WcNotifyState_Unchanged:
    result += getStatusCode(StatusNormal).toUtf8();
    break;
  case svn::WcNotifyState_Missing:
    result += getStatusCode(StatusMissing).toUtf8();
    break;
  case svn::WcNotifyState_Obstructed:
    result += getStatusCode(StatusObstructed).toUtf8();
    break;
  case svn::WcNotifyState_Changed:
    result += getStatusCode(StatusModified).toUtf8();
    break;
  case svn::WcNotifyState_Merged:
    result += getStatusCode(StatusMerged).toUtf8();
    break;
  case svn::WcNotifyState_Conflicted:
    result += getStatusCode(StatusConflicted).toUtf8();
    break;
  default:
    break;
  }

  // \todo add property state and lock state
  return result;
}

sc::String Notify::getMessage( svn::WcNotifyPtr wcNotify )
{
  sc::String result = wcNotify->getPath();
  return result;
}

unsigned long Notify::getType( svn::WcNotifyPtr wcNotify )
{
  unsigned long result = Log::Running;
  return result;
}
