/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWTREEWIDGET_H
#define _SC_WCVIEWTREEWIDGET_H

// sc
#include "util/String.h"
class WcViewTree;
class WcViewModel;
class WcViewViewState;
class Version;
class ActionStorage;

// qt
#include <QtGui/QWidget>
class QStatusBar;
class QToolButton;
class QCheckBox;
class QLabel;

/**
 * Container widget for a working copy view with back & forward
 * navigation and view options.
 */
class WcViewTreeWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT

public:
  WcViewTreeWidget( WcViewModel*, ActionStorage*, QWidget* parent );
  ~WcViewTreeWidget();

public slots:
  void historyChange();
  void currentChange(const sc::String&);
  void updatedVersion(const Version&);

  void setWcViewType(bool);

signals:
  void rootChanged( QString path, QString url );

private:
  WcViewModel*     _model;
  WcViewTree*      _tree;
  WcViewViewState* _state;

  QStatusBar*      _status;

  QToolButton*     _back;
  QToolButton*     _forward;

  QCheckBox*       _all;
  QCheckBox*       _ignored;
  QCheckBox*       _updates;
  QCheckBox*       _viewtype;
  QLabel*          _version;
};


#endif // _SC_WCVIEWTREEWIDGET_H
