/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "MergeCmd.h"
#include "MergeParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


MergeCmd::MergeCmd( MergeParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

MergeCmd::~MergeCmd()
{
  delete _cb;
}

void MergeCmd::run()
{
  sc::Error* err = 0;

  _prgscb->started( getId(), _param, getCancel() );

  if( _param->isPeg() )
  {
    err = _client->merge( _param->getPathOrUrl1(), *_param->getRevision1(),
      *_param->getRevision2(), *_param->getPegRevision(), _param->getTargetPath(),
      _param->getRecurse(), _param->getAncestry(), _param->getForce(), _param->getDryRun() );
  }
  else
  {
    err = _client->merge( _param->getPathOrUrl1(), *_param->getRevision1(),
      _param->getPathOrUrl2(), *_param->getRevision2(), _param->getTargetPath(),
      _param->getRecurse(), _param->getAncestry(), _param->getForce(), _param->getDryRun() );
  }

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
