/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STATUSPARAM_H
#define _SC_STATUSPARAM_H

// sc
#include "ScParam.h"
#include "ScParamVisitor.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/WcStatusTypes.h"

/**
 * Parameter class for StatusCmd.
 */
class StatusParam : public ScParam
{
public:
  /**
   * construct a StatusParam object. It takes ownership of \a rev.
   */
  StatusParam( const sc::String& path, const svn::Revision* rev, bool recurse, bool all,
    bool update, bool ignore, bool refresh ) : _path(path), _rev(rev), _recurse(recurse),
    _all(all), _update(update), _ignore(ignore), _refresh(refresh)
  {
  }

  ~StatusParam()
  {
    delete _rev;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getAll() const
  {
    return _all;
  }

  bool getUpdate() const
  {
    return _update;
  }

  bool getIgnore() const
  {
    return _ignore;
  }

  bool getRefresh() const
  {
    return _refresh;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  svn::WcStatuss& getStatuss()
  {
    return _statuss;
  }

  ScParamAccept(StatusParam);

private:
  // in
  sc::String           _path;
  const svn::Revision* _rev;
  bool                 _recurse;
  bool                 _all;
  bool                 _update;
  bool                 _ignore;
  bool                 _refresh;

  // out
  svn::Revnumber       _revnum;
  svn::WcStatuss       _statuss;
};

#endif // _SC_STATUSPARAM_H
