/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTSETTINGSWIDGET_H
#define _SC_PROJECTSETTINGSWIDGET_H

// sc
#include "sublib/settings/SettingsWidget.h"
class ExternProvider;
class ExternButton;
class Project;

// qt
class QLineEdit;
class QPushButton;
class QComboBox;
class Q3ListView;
class Q3ListViewItem;


class ProjectSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  ProjectSettingsWidget( ExternProvider* p, QWidget *parent = 0, const char *name = 0 );
  ~ProjectSettingsWidget();

  void setProject( Project* prj );
  Project* getProject() const;

public slots:
  void textChanged( const QString& text );
  void selectionChanged( Q3ListViewItem* );
  void clicked( Q3ListViewItem* );

  void add();
  void del();
  void clr();
  void up();
  void down();
  void std();
  void activated(int);

  void selectSource();

private:
  void handleExtern( QLineEdit* e );

  Project*        _prj;
  ExternProvider* _p;

  QLineEdit*    _name;

  Q3ListView*   _items;
  QComboBox*    _type;

  QPushButton*  _add;
  QPushButton*  _del;
  QPushButton*  _clr;

  QPushButton*  _up;
  QPushButton*  _down;

  QPushButton*  _layout;

  QLineEdit*    _itemName;
  QLineEdit*    _itemSource;
  ExternButton* _itemEx;
};


#endif // _SC_PROJECTSETTINGSWIDGET_H
