#ifdef ENABLE_ASPELL

#ifndef _ASpell_h
#define _ASpell_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <aspell.h>
#include <glibmm.h>


/*
 * 
 */
class ASpell
{
	
public:
	ASpell();
	~ASpell();


	enum SPELL_RESPONSE
	{
		SPELL_CORRECT,
		SPELL_SUGGESTION,
		SPELL_NO_SUGGESTION,
		SPELL_ERROR
	};
	
	/*
	 *	verifie le mot, si incorrect, rempli les suggestions
	 */
	SPELL_RESPONSE check(const Glib::ustring &word, 
			std::list<Glib::ustring> &suggestions);


	/*
	 *	demande de toujours ignorer ce mot pendant cette session
	 */
	bool ignore_word(const Glib::ustring &word);
	
	/*
	 *	ajout ce mot au dico
	 */
	bool add_word(const Glib::ustring &word);


	/*
	 *	recupere tout les dico
	 */
	bool get_list_dict(std::list<Glib::ustring> &dicts);

	/*
	 *
	 */
	bool set_dict(const Glib::ustring &dict);
	
	/*
	 *
	 */
	Glib::ustring get_dict();
	
protected:
	/*
	 * init aspell en mode pipe et avec lang
	 */
	bool init(const Glib::ustring &lang);

	/*
	 *	ferme aspell ainsi que les io channel
	 */
	bool	close();

protected:
	AspellCanHaveError	*m_ret;
	AspellSpeller				*m_speller;
	AspellConfig				*m_config;
};


#endif//_ASpell_h

#endif//ENABLE_ASPELL
