/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "DialogScriptProperties.h"
#include "utility.h"

DialogScriptProperties::DialogScriptProperties(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	refGlade->get_widget("entryScriptType", entryScriptType);
	refGlade->get_widget("entryPointTime", entryPointTime);

	refGlade->get_widget("entryTitle", entryTitle);
	refGlade->get_widget("entryOriginalScript", entryOriginalScript);
	refGlade->get_widget("entryOriginalTranslation", entryOriginalTranslation);
	refGlade->get_widget("entryOriginalEditing", entryOriginalEditing);
	refGlade->get_widget("entryOriginalTiming", entryOriginalTiming);
	refGlade->get_widget("entrySyncPoint", entrySyncPoint);
	refGlade->get_widget("entryScriptUpdatedBy", entryScriptUpdatedBy);
	refGlade->get_widget("entryUpdateDetails", entryUpdateDetails);

	refGlade->get_widget("entryPlayResX", entryPlayResX);
	refGlade->get_widget("entryPlayResY", entryPlayResY);
	refGlade->get_widget("entryPlayDepth", entryPlayDepth);

	refGlade->get_widget("comboCollisions", comboCollisions);
	refGlade->get_widget("entryWarpStyle", entryWarpStyle);

	refGlade->get_widget("spinTimer", spinTimer);


	
	//init(&doc->m_scriptInfo);


#define CONNECT(widget,signal,callback) widget->signal().connect(sigc::mem_fun(*this, &DialogScriptProperties::callback));

	CONNECT(entryScriptType, signal_changed, on_entry_script_type_changed);
	CONNECT(entryPointTime, signal_changed, on_entry_point_time_changed);

	CONNECT(entryTitle, signal_changed, on_entry_title_changed);
	CONNECT(entryOriginalScript, signal_changed, on_entry_original_script_changed);
	CONNECT(entryOriginalTranslation, signal_changed, on_entry_original_translation_changed);
	CONNECT(entryOriginalEditing, signal_changed, on_entry_original_editing_changed);
	CONNECT(entryOriginalTiming, signal_changed, on_entry_original_timing_changed);
	CONNECT(entrySyncPoint, signal_changed, on_entry_sync_point_changed);
	CONNECT(entryScriptUpdatedBy, signal_changed, on_entry_script_updated_by_changed);
	CONNECT(entryUpdateDetails, signal_changed, on_entry_update_details_changed);
	
	CONNECT(entryPlayResX, signal_changed, on_entry_play_res_x_changed);
	CONNECT(entryPlayResY, signal_changed, on_entry_play_res_y_changed);
	CONNECT(entryPlayDepth, signal_changed, on_entry_play_depth_changed);

	CONNECT(comboCollisions, signal_changed, on_combo_collisions_changed);
	CONNECT(entryWarpStyle, signal_changed, on_entry_warp_style_changed);

	CONNECT(spinTimer, signal_value_changed, on_spin_timer_changed);

#undef CONNECT


}

void DialogScriptProperties::execute()
{
	Document *doc = SE::getInstance()->getDocument();
	g_return_if_fail(doc);

	init(&doc->get_script_info());

	show();
	
	run();

	hide();
}

void DialogScriptProperties::init(ScriptInfo *info)
{
	g_return_if_fail(info);

	scriptInfo = info;
	
	entryScriptType->set_text(info->ScriptType);
	//entryPointTime->set_text(info->);
	
	entryTitle->set_text(info->Title);
	entryOriginalScript->set_text(info->OriginalScript);
	entryOriginalTranslation->set_text(info->OriginalTranslation);
	entryOriginalEditing->set_text(info->OriginalEditing);
	entryOriginalTiming->set_text(info->OriginalTiming);
	entrySyncPoint->set_text(info->SynchPoint);
	entryScriptUpdatedBy->set_text(info->ScriptUpdatedBy);
	entryUpdateDetails->set_text(info->UpdateDetails);
	
	entryPlayResX->set_text(info->PlayResX);
	entryPlayResY->set_text(info->PlayResY);
	entryPlayDepth->set_text(info->PlayDepth);
	
	if(info->Collisions == "Normal")
		comboCollisions->set_active(0);
	else if(info->Collisions == "Reverse")
		comboCollisions->set_active(1);
	else
	{
		comboCollisions->set_active(0);
		info->Collisions = "Normal";
	}

	//entryWarpStyle->set_text(info->WarpStyle);

	double timer = 100.0;
	//std::string str_timer = info->Timer;
	if(from_string(info->Timer, timer))
		spinTimer->set_value(timer);
}

void DialogScriptProperties::on_entry_script_type_changed()
{
	scriptInfo->ScriptType = entryScriptType->get_text();
}

void DialogScriptProperties::on_entry_point_time_changed()
{
//	scriptInfo->PointT = entryPointTime->get_text();
}

	
void DialogScriptProperties::on_entry_title_changed()
{
	scriptInfo->Title = entryTitle->get_text();
}

void DialogScriptProperties::on_entry_original_script_changed()
{
	scriptInfo->OriginalScript = entryOriginalScript->get_text();
}

void DialogScriptProperties::on_entry_original_translation_changed()
{
	scriptInfo->OriginalTranslation = entryOriginalTranslation->get_text();
}

void DialogScriptProperties::on_entry_original_editing_changed()
{
	scriptInfo->OriginalEditing = entryOriginalEditing->get_text();
}

void DialogScriptProperties::on_entry_original_timing_changed()
{
	scriptInfo->OriginalTiming = entryOriginalTiming->get_text();
}

void DialogScriptProperties::on_entry_sync_point_changed()
{
	scriptInfo->SynchPoint = entrySyncPoint->get_text();
}

void DialogScriptProperties::on_entry_script_updated_by_changed()
{
	scriptInfo->ScriptUpdatedBy = entryScriptUpdatedBy->get_text();
}

void DialogScriptProperties::on_entry_update_details_changed()
{
	scriptInfo->UpdateDetails = entryUpdateDetails->get_text();
}


void DialogScriptProperties::on_entry_play_res_x_changed()
{
	scriptInfo->PlayResX = entryPlayResX->get_text();
}

void DialogScriptProperties::on_entry_play_res_y_changed()
{
	scriptInfo->PlayResY = entryPlayResY->get_text();
}

void DialogScriptProperties::on_entry_play_depth_changed()
{
	scriptInfo->PlayDepth = entryPlayDepth->get_text();
}

	
void DialogScriptProperties::on_combo_collisions_changed()
{
	if(comboCollisions->get_active() == 0)
		scriptInfo->Collisions = "Normal";
	else
		scriptInfo->Collisions = "Reverse";
}

void DialogScriptProperties::on_entry_warp_style_changed()
{
//	scriptInfo->WarpStyle = entryWarpStyle->get_text();
}

void DialogScriptProperties::on_spin_timer_changed()
{
	double value = spinTimer->get_value();

	scriptInfo->Timer = to_string(value);
}


