/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <iostream>
#include <gtkmm/main.h>
#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/dialog.h>
#include <gtkmm/label.h>

#include "SubtitleView.h"
#include "SubtitleEditor.h"

#include <glibmm/spawn.h>

#include <glibmm.h>

#include <gtkmm/liststore.h>
#include <gtkmm/stock.h>

#include <config.h>

#include "utility.h"
#include "Config.h"

#include <locale.h>

#include "Waveform.h"



/*
 *
 */
class SubtitleOption : public Glib::OptionGroup
{
public:
	SubtitleOption();

public:
	bool check_gstreamer;
};

/*
 *
 */
SubtitleOption::SubtitleOption()
:Glib::OptionGroup("subtitleeditor", "description ....", "help...")
{
	check_gstreamer = false;

	Glib::OptionEntry entry4;
	entry4.set_long_name("check-gstreamer");
	entry4.set_description("Check Gstreamer to the presence of certain element used by subtitleeditor");
	add_entry(entry4, check_gstreamer);
}

/*
 *
 */
void check_default_config()
{
	se_debug_message(SE_DEBUG_APP, "check_default_config");

	Config &cfg = Config::getInstance();

	// piti check... ~/.subtitleeditor
	Glib::ustring path_se = Glib::build_filename(Glib::get_home_dir(), ".subtitleeditor");
	if(Glib::file_test(path_se, Glib::FILE_TEST_IS_DIR) == false)
	{
		Glib::ustring cmd = "mkdir " + path_se;
		system(cmd.c_str());
	}

	// GENERAL
	if(!cfg.has_key("general", "maximize"))
		cfg.set_value_bool("general", "maximize", false);


	// ENCODINGS
	if(!cfg.has_key("encodings", "default"))
		cfg.set_value_string("encodings", "encodings", "ISO-8859-15;UTF-8;");

	if(!cfg.has_key("encodings", "default"))
	{
		std::string def;
		if(!Glib::get_charset(def))
			def="UTF-8";

		cfg.set_value_string("encodings", "default", def);
	}

	if(!cfg.has_key("encodings", "used-auto-detected"))
		cfg.set_value_bool("encodings", "used-auto-detected", true);

	// VIDEO-PLAYER	
	if(!cfg.has_key("video-player", "default"))
	{
		//cfg.set_comment("video-player", "video-player", "blablabla");
		
		cfg.set_value_string("video-player", "default", "mplayer");

		cfg.set_value_string("video-player", "mplayer", 
				"mplayer \"#video_file\" -sub \"#subtitle_file\" -ss #seconds -osdlevel 2");
		
		cfg.set_value_string("video-player", "vlc", 
				"vlc \"#video_file\" --sub-file=\"#subtitle_file\" --start-time=#seconds");
	
		//cfg.set_value_string("video-player", "gstreamer", 
		//		"gst-launch playbin uri=\"#video_uri\" subfile=\"#subtitle_uri\" subtitle-font-desc=\"Comic Sans MS Bold 20\"");
	}

	// TIMING-SYSTEM
	if(!cfg.has_key("timing-system", "audio-sink"))
		cfg.set_value_string("timing-system", "audio-sink", "autoaudiosink");
	
	if(!cfg.has_key("timing-system", "video-sink"))
		cfg.set_value_string("timing-system", "video-sink", "ximagesink");
}

/*
 *	teste GStreamer
 */
void check_gstreamer()
{
	guint major, minor, micro, nano;

	gst_version(&major, &minor, &micro, &nano);

	g_print("gstreamer info : %d.%d.%d\n", major, minor, micro);

#define check_element(name) \
	{ \
		GstElement *el = gst_element_factory_make(name, name); \
		if(!el) \
			std::cerr << "create \"" << name << "\" FAILED!" << std::endl; \
		else { \
			std::cerr << "create \"" << name << "\" OK!" << std::endl; \
			gst_object_unref(GST_OBJECT(el)); } \
	}

	check_element("filesrc");
	check_element("decodebin");
	check_element("audioconvert");
	check_element("level");
	check_element("fakesink");
	check_element("ximagesink");

#undef check_element
}

/*
 *
 */
int main(int argc, char *argv[])
{
	// Init Debug
	se_debug_init(argc, argv);
	se_debug_message(SE_DEBUG_APP, "Startup subtitle version %s", VERSION);
	
	// Bindtextdomain
	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	// Init Gtk+
	se_debug_message(SE_DEBUG_APP, "Init Gtk+");

	Gtk::Main kit(argc, argv/*, context*/);

	g_set_application_name("subtitleeditor");

	// Options
	se_debug_message(SE_DEBUG_APP, "Options");

	SubtitleOption options;
	Glib::OptionContext context("[FILE...]");

	context.set_main_group(options);
	
	try
	{
		context.parse(argc, argv);
	}
	catch(const Glib::Error &ex)
	{
		std::cerr << "Error loading options : " << ex.what() << std::endl;
		//return EXIT_FAILURE;
	}

	// Init GStreamer 
	se_debug_message(SE_DEBUG_APP, "Init GStreamer");
	
	gst_init(&argc,&argv);

	// check gstreamer ?
	if(options.check_gstreamer)
	{
		check_gstreamer();
		return EXIT_SUCCESS;
	}

	// check default config
	se_debug_message(SE_DEBUG_APP, "Check default config");
	
	check_default_config();

	// Create subtitleeditor instance
	se_debug_message(SE_DEBUG_APP, "Create SubtitleEditor instance");

	SubtitleEditor* editor = SubtitleEditor::getInstance();	

	if(!editor)
	{
		std::cerr << "Can't create subtitleeditor instance!" << std::endl;
		return EXIT_FAILURE;
	}

	// Open subtitle file ?	
	if(argc > 1)
	{
		if(	Glib::file_test(argv[1], Glib::FILE_TEST_EXISTS | Glib::FILE_TEST_IS_REGULAR) && 
				Glib::file_test(argv[1], Glib::FILE_TEST_IS_DIR) == false)
		{
			editor->open_subtitle(argv[1]);
		}
	}

	// launch and show
	se_debug_message(SE_DEBUG_APP, "Run SubtitleEditor");

	editor->show();
	
	kit.run(*editor);

	se_debug_message(SE_DEBUG_APP, "Delete SubtitleEditor");
	
	delete editor;

	return EXIT_SUCCESS;
}

