/*
 * Decompiled with CFR 0.152.
 */
package bioroute.networkpreprocessor;

import bioroute.NetworkPreprocessor;
import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.config.Config;
import java.util.HashMap;

public class OpenStreetMapPreprocessor
implements NetworkPreprocessor {
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    public static final String NAIVELENGTH = "naivelength";
    public static final String PROJECTEDLENGTH = "projectedlength";
    private static final double earthRadius_m = 6378137.0;

    private double length(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public void configure(Config config) {
    }

    @Override
    public void preprocess(Network network) {
        double minLon = Double.POSITIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        HashMap<Node, Double> node2longitude = new HashMap<Node, Double>();
        HashMap<Node, Double> node2latitude = new HashMap<Node, Double>();
        for (Node node : network.getNodes()) {
            double longitude = Double.parseDouble(node.getAttr(LONGITUDE));
            double latitude = Double.parseDouble(node.getAttr(LATITUDE));
            minLon = Math.min(minLon, longitude);
            minLat = Math.min(minLat, latitude);
            node2longitude.put(node, longitude);
            node2latitude.put(node, latitude);
        }
        double minEasting = Double.POSITIVE_INFINITY;
        double maxEasting = Double.NEGATIVE_INFINITY;
        double minNorthing = Double.POSITIVE_INFINITY;
        double maxNorthing = Double.NEGATIVE_INFINITY;
        HashMap<Node, Double> node2easting = new HashMap<Node, Double>();
        HashMap<Node, Double> node2northing = new HashMap<Node, Double>();
        for (Node node : network.getNodes()) {
            double easting = 6378137.0 * ((Double)node2longitude.get(node) - minLon) * Math.PI / 180.0;
            double northing = 6378137.0 * ((Double)node2latitude.get(node) - minLat) * Math.PI / 180.0;
            node2easting.put(node, easting);
            node2northing.put(node, northing);
            minEasting = Math.min(minEasting, easting);
            maxEasting = Math.max(maxEasting, easting);
            minNorthing = Math.min(minNorthing, northing);
            maxNorthing = Math.max(maxNorthing, northing);
        }
        for (Link link : network.getLinks()) {
            Node from = link.getFromNode();
            Node to = link.getToNode();
            double naiveLength = this.length((Double)node2longitude.get(from), (Double)node2latitude.get(from), (Double)node2longitude.get(to), (Double)node2latitude.get(to));
            link.setAttr(NAIVELENGTH, Double.toString(naiveLength));
            double projectedLength = this.length((Double)node2easting.get(from), (Double)node2northing.get(from), (Double)node2easting.get(to), (Double)node2northing.get(to));
            link.setAttr(PROJECTEDLENGTH, Double.toString(projectedLength));
        }
    }
}

