/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.misc;

import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.misc.XMLHelpers;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DynamicDataXMLFileIO<K>
extends DefaultHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OUTER_ELEMENT = "dynamicdata";
    public static final String SUBCLASS_ATTR = "subclass";
    public static final String STARTTIME_ATTR = "starttime";
    public static final String BINSIZE_ATTR = "binsize";
    public static final String BINCOUNT_ATTR = "bincount";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ATTR = "key";
    public static final String VALUE_ATTR = "value";
    private DynamicData<K> result = null;

    protected DynamicDataXMLFileIO() {
    }

    protected DynamicData<K> newInstance(int startTime_s, int binSize_s, int binCnt) {
        return new DynamicData(startTime_s, binSize_s, binCnt);
    }

    protected abstract String key2attrValue(K var1);

    protected abstract K attrValue2key(String var1);

    private String values2string(double[] entry) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < entry.length) {
            result.append(String.valueOf(entry[i]) + " ");
            ++i;
        }
        return result.toString();
    }

    public void write(String filename, DynamicData<K> dd) throws IOException {
        PrintWriter writer = new PrintWriter(new File(filename));
        writer.print("<");
        writer.print(OUTER_ELEMENT);
        writer.print(" ");
        XMLHelpers.writeAttr(STARTTIME_ATTR, dd.getStartTime_s(), writer);
        XMLHelpers.writeAttr(BINSIZE_ATTR, dd.getBinSize_s(), writer);
        XMLHelpers.writeAttr(BINCOUNT_ATTR, dd.getBinCnt(), writer);
        XMLHelpers.writeAttr(SUBCLASS_ATTR, this.getClass().getName(), writer);
        writer.println(">");
        for (Map.Entry entry : dd.data.entrySet()) {
            if (entry.getValue() == null) continue;
            writer.print("  <");
            writer.print(ENTRY_ELEMENT);
            writer.print(" ");
            XMLHelpers.writeAttr(KEY_ATTR, this.key2attrValue(entry.getKey()), writer);
            XMLHelpers.writeAttr(VALUE_ATTR, this.values2string(entry.getValue()), writer);
            writer.println("/>");
        }
        writer.print("</");
        writer.print(OUTER_ELEMENT);
        writer.println(">");
        writer.flush();
        writer.close();
    }

    private double[] string2values(String value) {
        String[] entryStrings;
        if (value == null) {
            return null;
        }
        double[] entryArray = new double[this.result.getBinCnt()];
        if (entryArray.length != (entryStrings = value.split("\\s")).length) {
            Logger.getLogger(this.getClass().getName()).warning("inconsistent data dimensions, Skipping this entry: " + value);
            return null;
        }
        int i = 0;
        while (i < entryArray.length) {
            entryArray[i] = Double.parseDouble(entryStrings[i]);
            ++i;
        }
        return entryArray;
    }

    public DynamicData<K> read(String file) {
        this.result = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(file, (DefaultHandler)this);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).warning("exception during file parsing: " + e.toString());
            this.result = null;
        }
        return this.result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (OUTER_ELEMENT.equals(qName)) {
            this.startOuterElement(attributes);
        } else if (ENTRY_ELEMENT.equals(qName)) {
            this.startEntryElement(attributes);
        }
    }

    private void startOuterElement(Attributes attrs) {
        String subclass = attrs.getValue(SUBCLASS_ATTR);
        if (!this.getClass().getName().equals(subclass)) {
            Logger.getLogger(this.getClass().getName()).warning("file has been written by " + subclass);
        }
        int startTime_s = Integer.parseInt(attrs.getValue(STARTTIME_ATTR));
        int binSize_s = Integer.parseInt(attrs.getValue(BINSIZE_ATTR));
        int binCnt = Integer.parseInt(attrs.getValue(BINCOUNT_ATTR));
        this.result = this.newInstance(startTime_s, binSize_s, binCnt);
    }

    private void startEntryElement(Attributes attrs) {
        K key = this.attrValue2key(attrs.getValue(KEY_ATTR));
        double[] values = this.string2values(attrs.getValue(VALUE_ATTR));
        this.result.data.put(key, values);
    }
}

