/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.AzimuthalProjection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class OrthographicAzimuthalProjection
extends AzimuthalProjection {
    public OrthographicAzimuthalProjection() {
        this.initialize();
    }

    public Point2D.Double project(double lam, double phi, Point2D.Double xy) {
        double cosphi = Math.cos(phi);
        double coslam = Math.cos(lam);
        switch (this.mode) {
            case 3: {
                xy.y = Math.sin(phi);
                break;
            }
            case 4: {
                double sinphi = Math.sin(phi);
                xy.y = this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                break;
            }
            case 1: {
                coslam = -coslam;
            }
            case 2: {
                xy.y = cosphi * coslam;
            }
        }
        xy.x = cosphi * Math.sin(lam);
        return xy;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double lp) {
        double d;
        double rh;
        double sinc = rh = MapMath.distance(x, y);
        if (d > 1.0) {
            if (sinc - 1.0 > 1.0E-10) {
                throw new ProjectionException();
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (Math.abs(rh) <= 1.0E-10) {
            lp.y = this.projectionLatitude;
        } else {
            switch (this.mode) {
                case 1: {
                    y = -y;
                    lp.y = Math.acos(sinc);
                    break;
                }
                case 2: {
                    lp.y = -Math.acos(sinc);
                    break;
                }
                case 3: {
                    lp.y = y * sinc / rh;
                    x *= sinc;
                    y = cosc * rh;
                    if (Math.abs(lp.y) >= 1.0) {
                        lp.y = lp.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                        break;
                    }
                    lp.y = Math.asin(lp.y);
                    break;
                }
                case 4: {
                    lp.y = cosc * this.sinphi0 + y * sinc * this.cosphi0 / rh;
                    y = (cosc - this.sinphi0 * lp.y) * rh;
                    x *= sinc * this.cosphi0;
                    lp.y = Math.abs(lp.y) >= 1.0 ? (lp.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(lp.y);
                }
            }
        }
        lp.x = y == 0.0 && (this.mode == 4 || this.mode == 3) ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
        return lp;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Orthographic Azimuthal";
    }
}

