/*
 * Decompiled with CFR 0.152.
 */
package cadyts.calibrators.filebased.xml;

import cadyts.calibrators.filebased.Agent;
import cadyts.calibrators.filebased.xml.AgentIterator;
import java.util.Iterator;
import java.util.logging.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class PopulationHandler<A extends Agent<?, ?>>
extends DefaultHandler
implements Iterable<A> {
    private A bufferedAgent = null;
    private boolean noData = true;

    public synchronized A getNextAgent() {
        Logger.getLogger(this.getClass().getName()).fine("waiting until there is a pending agent");
        while (this.noData) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.noData = true;
        this.notifyAll();
        Logger.getLogger(this.getClass().getName()).fine("returning pending agent");
        return this.bufferedAgent;
    }

    protected synchronized void putNextAgent(A agent) {
        Logger.getLogger(this.getClass().getName()).fine("waiting until there is no pending agent (next agent is " + agent + ")");
        while (!this.noData) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.bufferedAgent = agent;
        this.noData = false;
        this.notifyAll();
        if (agent != null) {
            Logger.getLogger(this.getClass().getName()).fine("...received new pending agent");
        } else {
            Logger.getLogger(this.getClass().getName()).fine("parser thread returns immediately because it wrote a null agent (end of file)");
        }
    }

    @Override
    public Iterator<A> iterator() {
        return new AgentIterator(this);
    }

    @Override
    public void endDocument() {
        this.putNextAgent(null);
    }
}

