/*
 * Decompiled with CFR 0.152.
 */
package cadyts.supply.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.NetworkLoaderXML;
import cadyts.supply.network.Node;
import org.xml.sax.Attributes;

public class OsmNetworkLoader
extends NetworkLoaderXML {
    public static final String NODE = "node";
    public static final String NODE_ID = "id";
    public static final String WAY = "way";
    public static final String WAY_ID = "id";
    public static final String WAY_ND = "nd";
    public static final String WAY_ND_ID = "ref";
    private Link currentLink = null;

    @Override
    public void startDocument() {
        this.net = new Network("OSM network");
        this.currentLink = null;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (NODE.equals(qName)) {
            this.startNode(attrs);
        } else if (WAY.equals(qName)) {
            this.startWay(attrs);
        } else if (WAY_ND.equals(qName)) {
            this.startWayNd(attrs);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (WAY.equals(qName)) {
            this.endWay();
        }
    }

    private void startNode(Attributes attrs) {
        Node node = new Node(attrs.getValue("id"));
        this.net.add(node);
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            if (!"id".equals(name)) {
                node.setAttr(name, attrs.getValue(i));
            }
            ++i;
        }
    }

    private void startWay(Attributes attrs) {
        this.currentLink = new Link(attrs.getValue("id"));
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            if (!"id".equals(name)) {
                this.currentLink.setAttr(name, attrs.getValue(i));
            }
            ++i;
        }
    }

    private void startWayNd(Attributes attrs) {
        Node node = this.net.getNode(attrs.getValue(WAY_ND_ID));
        if (this.currentLink.getFromNode() == null) {
            this.currentLink.setFromNode(node);
            node.addOutLink(this.currentLink);
        } else {
            this.currentLink.setToNode(node);
            node.addInLink(this.currentLink);
        }
    }

    private void endWay() {
        this.net.add(this.currentLink);
        this.currentLink = null;
    }
}

