//  $Id: tilemap.hpp 4063 2006-07-21 21:05:23Z anmaster $
//
//  SuperTux
//  Copyright (C) 2006 Matthias Braun <matze@braunis.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef __SCRIPTING_TILEMAP_H__
#define __SCRIPTING_TILEMAP_H__

#ifndef SCRIPTING_API
class TileMap;
typedef TileMap _TileMap;
#endif

namespace Scripting
{

class TileMap
{
public:
#ifndef SCRIPTING_API
  TileMap(_TileMap* tilemap);
  ~TileMap();
#endif

  /** Move tilemap until at given node, then stop */
  void goto_node(int node_no);

  /** Start moving tilemap */
  void start_moving();

  /** Stop tilemap at next node */
  void stop_moving();

#ifndef SCRIPTING_API
  _TileMap* tilemap;
#endif
};

}

#endif
