/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Swac-explore is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"
#include <gtkmmconfig.h>
#include <sigc++/compatibility.h>
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#include <gtk/gtkimagemenuitem.h>
#include <gtkmm/image.h>
#include <gtkmm/stockid.h>
#include <gtkmm/stock.h>
#include "explorer_static.hh"



ExplorerStatic::ExplorerStatic() : Gtk::Window(Gtk::WINDOW_TOPLEVEL) {  
	entry3 = Gtk::manage(new class Gtk::Entry());
	toolitem1 = Gtk::manage(new class Gtk::ToolItem());
	tool_search_item = Gtk::manage(new class Gtk::ToolItem());
	tool_search_icon = Gtk::manage(new class Gtk::Image(Gtk::StockID(Gtk::Stock::FIND), Gtk::ICON_SIZE_MENU));
	separatortoolitem1 = Gtk::manage(new class Gtk::SeparatorToolItem());
	toolbutton1 = Gtk::manage(new class Gtk::ToolButton(Gtk::StockID(Gtk::Stock::MEDIA_PLAY)));
	separatortoolitem2 = Gtk::manage(new class Gtk::SeparatorToolItem());
	toolitem5 = Gtk::manage(new class Gtk::ToolItem());
	separatortoolitem3 = Gtk::manage(new class Gtk::SeparatorToolItem());
	toolbutton5 = Gtk::manage(new class Gtk::ToolButton(Gtk::StockID(Gtk::Stock::ABOUT)));
	toolbutton2 = Gtk::manage(new class Gtk::ToolButton(Gtk::StockID(Gtk::Stock::QUIT)));
	toolbar1 = Gtk::manage(new class Gtk::Toolbar());
	combobox1 = Gtk::manage(new class Gtk::ComboBox());
	treeview2 = Gtk::manage(new class Gtk::TreeView());
	scrolledwindow2 = Gtk::manage(new class Gtk::ScrolledWindow());
	combobox2 = Gtk::manage(new class Gtk::ComboBox());
	vbox2 = Gtk::manage(new class Gtk::VBox(false, 0));
	treeview1 = Gtk::manage(new class Gtk::TreeView());
	scrolledwindow3 = Gtk::manage(new class Gtk::ScrolledWindow());
	treeview3 = Gtk::manage(new class Gtk::TreeView());
	scrolledwindow4 = Gtk::manage(new class Gtk::ScrolledWindow());
	vpaned1 = Gtk::manage(new class Gtk::VPaned());
	hpaned1 = Gtk::manage(new class Gtk::HPaned());
	statusbar1 = Gtk::manage(new class Gtk::Statusbar());
	vbox1 = Gtk::manage(new class Gtk::VBox(false, 0));

	toolbar1->append(*tool_search_item);
	toolbar1->append(*toolitem1);

	toolbar1->append(*separatortoolitem1);
	toolbar1->append(*toolbutton1);
	toolbar1->append(*separatortoolitem2);
	toolbar1->append(*toolitem5);
	toolbar1->append(*separatortoolitem3);
	toolbar1->append(*toolbutton5);
	toolbar1->append(*toolbutton2);

	entry3->set_flags(Gtk::CAN_FOCUS);
	entry3->set_has_frame(true);
	entry3->set_activates_default(false);

	toolitem1->set_visible_horizontal(true);
	toolitem1->set_visible_vertical(true);
	toolitem1->set_is_important(false);
	toolitem1->add(*entry3);

	tool_search_item->add(*tool_search_icon);

	separatortoolitem1->set_visible_horizontal(true);
	separatortoolitem1->set_visible_vertical(true);

	toolbutton1->set_visible_horizontal(true);
	toolbutton1->set_visible_vertical(true);
	toolbutton1->set_is_important(false);

	separatortoolitem2->set_visible_horizontal(true);
	separatortoolitem2->set_visible_vertical(true);

	toolitem5->set_visible_horizontal(true);
	toolitem5->set_visible_vertical(true);
	toolitem5->set_is_important(false);

	separatortoolitem3->set_visible_horizontal(true);
	separatortoolitem3->set_visible_vertical(true);

	toolbutton5->set_visible_horizontal(true);
	toolbutton5->set_visible_vertical(true);
	toolbutton5->set_is_important(false);
	toolbutton2->set_visible_horizontal(true);
	toolbutton2->set_visible_vertical(true);
	toolbutton2->set_is_important(false);

	toolbar1->set_tooltips(true);
	toolbar1->set_toolbar_style(Gtk::TOOLBAR_BOTH);
	toolbar1->set_orientation(Gtk::ORIENTATION_HORIZONTAL);
	toolbar1->set_show_arrow(true);

	combobox1->set_size_request(150,-1);

	treeview2->set_size_request(175,-1);
	treeview2->set_flags(Gtk::CAN_FOCUS);
	treeview2->set_headers_visible(true);
	treeview2->set_rules_hint(false);
	treeview2->set_reorderable(false);
	treeview2->set_enable_search(true);

	scrolledwindow2->set_flags(Gtk::CAN_FOCUS);
	scrolledwindow2->set_shadow_type(Gtk::SHADOW_IN);
	scrolledwindow2->set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC);
	scrolledwindow2->property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
	scrolledwindow2->add(*treeview2);

	vbox2->pack_start(*combobox1, Gtk::PACK_SHRINK, 0);
	vbox2->pack_start(*scrolledwindow2);
	vbox2->pack_start(*combobox2, Gtk::PACK_SHRINK, 0);

	treeview1->set_flags(Gtk::CAN_FOCUS);
	treeview1->set_headers_visible(true);
	treeview1->set_rules_hint(false);
	treeview1->set_reorderable(true);
	treeview1->set_enable_search(true);

	scrolledwindow3->set_flags(Gtk::CAN_FOCUS);
	scrolledwindow3->set_shadow_type(Gtk::SHADOW_IN);
	scrolledwindow3->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow3->property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
	scrolledwindow3->add(*treeview1);

	treeview3->set_flags(Gtk::CAN_FOCUS);
	treeview3->set_headers_visible(true);
	treeview3->set_rules_hint(false);
	treeview3->set_reorderable(false);
	treeview3->set_enable_search(true);

	scrolledwindow4->set_flags(Gtk::CAN_FOCUS);
	scrolledwindow4->set_shadow_type(Gtk::SHADOW_IN);
	scrolledwindow4->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow4->property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
	scrolledwindow4->add(*treeview3);

	vpaned1->set_flags(Gtk::CAN_FOCUS);
	vpaned1->pack1(*scrolledwindow3, Gtk::SHRINK);
	vpaned1->pack2(*scrolledwindow4, Gtk::SHRINK);

	hpaned1->set_flags(Gtk::CAN_FOCUS);
	hpaned1->pack1(*vbox2, Gtk::AttachOptions(0));
	hpaned1->pack2(*vpaned1, Gtk::EXPAND|Gtk::SHRINK);

	vbox1->pack_start(*toolbar1, Gtk::PACK_SHRINK, 0);
	vbox1->pack_start(*hpaned1);
	vbox1->pack_start(*statusbar1, Gtk::PACK_SHRINK, 0);

	set_title("SWAC Explore");
	set_default_size(800,600);
	set_modal(false);
	property_window_position().set_value(Gtk::WIN_POS_CENTER);
	set_resizable(true);
	property_destroy_with_parent().set_value(false);
	add(*vbox1);


	Gtk::TreeViewColumn *column;

	//=== Sounds List ===
	store_sounds = Gtk::ListStore::create(listview);
	treeview1->set_model(store_sounds);
	treeview1->set_reorderable(false);
	
	//--Column for icon
	Gtk::CellRendererPixbuf* my_render = new Gtk::CellRendererPixbuf;
	my_render->set_property("stock_id", Gtk::StockID(Gtk::Stock::ABOUT));

	treeview1->append_column("", *my_render);
	if ((column = treeview1->get_column(0)) != NULL) {
		column->set_sizing(Gtk::TREE_VIEW_COLUMN_FIXED);
		column->set_fixed_width(32);
	}

	//--Other columns
	SOUNDS_LIST_INIT;

	store_index = Gtk::ListStore::create(listbox);
	treeview2->set_model(store_index);
	treeview2->set_headers_visible(false);
	treeview2->append_column("", listbox.caption);

	//=== Languages ===
	store_lang = Gtk::ListStore::create(listext);
	combobox1->set_model(store_lang);
	combobox1->pack_start(listext.caption);
	combobox1->pack_start(listext.value);

	//=== Fields for index ===
	store_fields = Gtk::ListStore::create(listext);
	combobox2->set_model(store_fields);
	combobox2->pack_start(listext.caption);
	

	//=== Sound Info =======
	store_info = Gtk::TreeStore::create(listsoundinfo);
	treeview3->set_model(store_info);
	treeview3->set_headers_visible(false);

	//--Col 1
	Gtk::CellRendererText* my_render_col1 = new Gtk::CellRendererText;

	treeview3->append_column("Field", *my_render_col1);
	if ((column = treeview3->get_column(0)) != NULL) {
		column->add_attribute(my_render_col1->property_text(), listsoundinfo.caption);
		column->add_attribute(my_render_col1->property_weight(), listsoundinfo.weight);
	}

	//--Col 2
	Gtk::CellRendererText* my_render_col2 = new Gtk::CellRendererText;
	my_render_col2->set_property("wrap_mode", Pango::WRAP_WORD);
	my_render_col2->set_property("wrap_width", 450);
	my_render_col2->set_property("foreground_gdk", Gdk::Color("#606060"));
	my_render_col2->set_property("editable", true);

	treeview3->append_column("Value", *my_render_col2);
	if ((column = treeview3->get_column(1)) != NULL)
		column->add_attribute(my_render_col2->property_text(), listsoundinfo.value);


	SOUND_INFO_INIT;
	treeview3->expand_all();

	statusbar1->push("Welcome to SWAC Explorer!");


	entry3->show();
	toolitem1->show();
	tool_search_icon->show();
	tool_search_item->show();
	separatortoolitem1->show();
	toolbutton1->show();
	separatortoolitem2->show();
	toolitem5->show();
	toolbutton5->show();
	toolbutton2->show();
	toolbar1->show();
	combobox1->show();
	treeview2->show();
	scrolledwindow2->show();
	combobox2->show();
	vbox2->show();
	treeview1->show();
	scrolledwindow3->show();
	treeview3->show();
	scrolledwindow4->show();
	vpaned1->show();
	hpaned1->show();
	statusbar1->show();
	vbox1->show();
	show();
}

ExplorerStatic::~ExplorerStatic() {
}

