package Swatch::SendPage;
require 5.000;
require Exporter;
use Carp;

my $debug = 0;

@ISA = qw(Exporter);
@EXPORT = qw(send_page);

=head1 NAME

Swatch::SendPage - sendpage action for use with swatch(1)

=head1 SYNOPSIS

  use Swatch::SendPage;

  send_page(PAGE_CMD => '/path/to/paging/command',
	    PAGE_ARGS => 'pager options',
	    MESSAGE => 'message to send');

=head1 DESCRIPTION

This routine is intended to be used with the swatch(1) program as 
described below, but you could call it directly, of course.

=head1 SWATCH CONFIGURATION SYNTAX

    watchfor /some_regex/
        send_page [page_cmd=/path/to/paging/command],page_args=<pager_argument_list>,[custom_message=<message_to_send>]
    ...

=head SWATCH DEFAULTS

    page_cmd = /usr/local/bin/qpage
    custom_message = the matched log message

=head1 SWATCH EXAMPLE

    watchfor /\d\d:0\d:\d\d/
        throttle 00:59:00,use=regex
        send_page message=$sanitized_,page_args=-s pageserver.domain -p pager.id,when=0-7:7-23
        continue

=cut

sub send_page {
  my %args = (PAGE_CMD => '/usr/local/bin/qpage',
	      @_);
  my $exec_pid;
              
  if (not -x $args{'PAGE_CMD'}) {
    carp "The \"$args{'PAGE_CMD'}\" does not exist or is not executible. Ignoring this action.\n";
    return;
  }
  if (not exists $args{'PAGE_ARGS'}) {
    carp "send_page call is missing required option \"page_args\". Ignoring this action.\n";
    return;
  }

  return if exists($args{'WHEN'}) and not &main::inside_time_window($args{'WHEN'});

  $args{'PAGE_ARGS'} .= ' -d ' if $debug;
 
  if (open(PAGE_PROG, "| $args{'PAGE_CMD'} $args{'PAGE_ARGS'}")) {
    print STDERR "Writing: $args{'MESSAGE'}" if $debug;
    print PAGE_PROG $args{'MESSAGE'};
    print STDERR "Writing: \n.\n" if $debug;
    print PAGE_PROG "\n.\n";
    close PAGE_PROG;
  }
  return;
}

1;
