/*
 * Sweep, a sound wave editor.
 *
 * Copyright (C) 2000 Conrad Parker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DRIVER_H__
#define __DRIVER_H__

#include <unistd.h>

#include "sweep_app.h"

#define PBUF_SIZE 256

typedef struct _sw_handle sw_handle;
typedef struct _sw_driver sw_driver;

struct _sw_handle {
  int driver_fd;
  int driver_channels;
  int driver_rate;
  void * custom_data;
};

struct _sw_driver {
  void (*config) (void);
  sw_handle * (*open) (int cueing, int flags);
  void (*setup) (sw_handle * handle, sw_format * format);
  ssize_t (*read) (sw_handle * handle, sw_audio_t * buf, size_t count);
  ssize_t (*write) (sw_handle * handle, sw_audio_t * buf, size_t count,
		    sw_framecount_t offset);
  sw_framecount_t (*offset) (sw_handle * handle);
  void (*reset) (sw_handle * handle);
  void (*flush) (sw_handle * handle);
  void (*drain) (sw_handle * handle);
  void (*close) (sw_handle * handle);
};

void
device_config (void);

sw_handle *
device_open (int cueing, int flags);

void
device_setup (sw_handle * handle, sw_format * format);

ssize_t
device_read (sw_handle * handle, sw_audio_t * buf, size_t count);

ssize_t
device_write (sw_handle * handle, sw_audio_t * buf, size_t count,
	      sw_framecount_t offset);

sw_framecount_t
device_offset (sw_handle * handle);

void
device_reset (sw_handle * handle);

void
device_flush (sw_handle * handle);

void
device_drain (sw_handle * handle);

void
device_close (sw_handle * handle);

void
init_devices (void);

void
stop_playback (sw_sample * s) ;

#endif /* __DRIVER_H__ */
