:- use_module(library('http/thread_httpd')).
:- use_module(library('http/http_client')).

port(4242).

server :-
	port(Port),
	http_server(reply, [port(Port)]).

reply(_Request) :-
	format('Content-type: text/plain~n~n'),
	format('Hello world!~n').

client(N) :-
	client(N, []).

keep_alive(N) :-
	client(N, [connection('Keep-alive')]).

client(N, Options) :-
	port(Port),
	atom_concat('http://localhost:', Port, URL),
	forall(between(0, N, _),
	       http_get(URL, _Data, Options)).
