/* -*- Mode: Prolog -*- */
/** @copyright
  
  This file is part of PrologDoc (http://prologdoc.sourceforge.net/).

  Copyright (C) 2004 by Salvador Fandino (sfandino@@yahoo.com)

  PrologDoc is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  PrologDoc is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with PrologDoc; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  
  @/copyright */

:- module(pd_loader, [load_drivers/0,
		      load_drivers/1]).

:- use_module(library('prologdoc/pd')).
:- use_module(library('prologdoc/pd_config')).

load_drivers :-
	(   config(drivers, D)
	->  true
	;   D = [pd_default] ),
	load_drivers(D).

load_drivers([]).
load_drivers([H|T]) :-
	pd:consult(H),
	load_drivers(T).
