/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.io.File;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URILIST = "text/uri-list";
    private static final String HFS = "hfs ";
    private static final int URILISTID = Transfer.registerType("text/uri-list");
    private static final int HFSID = Transfer.registerType("hfs ");
    private static final String URILIST_PREFIX = "file:";
    private static final String URILIST_SEPARATOR = "\r";

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] files = (String[])object;
        transferData.result = -1;
        if (transferData.type == URILISTID) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int length = files.length;
            while (i < length) {
                sb.append(URILIST_PREFIX);
                sb.append(files[i]);
                sb.append(URILIST_SEPARATOR);
                ++i;
            }
            String str = sb.toString();
            char[] chars = new char[str.length()];
            str.getChars(0, chars.length, chars, 0);
            byte[] buffer = new byte[chars.length * 2];
            OS.memcpy((byte[])buffer, (char[])chars, (int)buffer.length);
            transferData.data = new byte[1][];
            transferData.data[0] = buffer;
            transferData.result = 0;
        }
        if (transferData.type == HFSID) {
            byte[][] data = new byte[files.length][];
            int i = 0;
            while (i < data.length) {
                Object var18_21;
                File file = new File(files[i]);
                boolean isDirectory = file.isDirectory();
                String fileName = files[i];
                char[] chars = new char[fileName.length()];
                fileName.getChars(0, chars.length, chars, 0);
                int cfstring = OS.CFStringCreateWithCharacters((int)0, (char[])chars, (int)chars.length);
                if (cfstring == 0) {
                    return;
                }
                try {
                    byte[] fsSpec;
                    Object var16_20;
                    int url;
                    block16: {
                        byte[] fsRef;
                        block15: {
                            url = OS.CFURLCreateWithFileSystemPath((int)0, (int)cfstring, (int)0, (boolean)isDirectory);
                            if (url == 0) {
                                var18_21 = null;
                                OS.CFRelease((int)cfstring);
                                return;
                            }
                            try {
                                fsRef = new byte[80];
                                if (OS.CFURLGetFSRef((int)url, (byte[])fsRef)) break block15;
                                var16_20 = null;
                            }
                            catch (Throwable throwable) {
                                var16_20 = null;
                                OS.CFRelease((int)url);
                                throw throwable;
                            }
                            OS.CFRelease((int)url);
                            var18_21 = null;
                            OS.CFRelease((int)cfstring);
                            return;
                        }
                        fsSpec = new byte[70];
                        if (OS.FSGetCatalogInfo((byte[])fsRef, (int)0, null, null, (byte[])fsSpec, null) == 0) break block16;
                        var16_20 = null;
                        OS.CFRelease((int)url);
                        var18_21 = null;
                        OS.CFRelease((int)cfstring);
                        return;
                    }
                    byte[] hfsflavor = new byte[10 + fsSpec.length];
                    byte[] finfo = new byte[16];
                    OS.FSpGetFInfo((byte[])fsSpec, (byte[])finfo);
                    System.arraycopy(finfo, 0, hfsflavor, 0, 10);
                    System.arraycopy(fsSpec, 0, hfsflavor, 10, fsSpec.length);
                    data[i] = hfsflavor;
                    var16_20 = null;
                    OS.CFRelease((int)url);
                    var18_21 = null;
                }
                catch (Throwable throwable) {
                    var18_21 = null;
                    OS.CFRelease((int)cfstring);
                    throw throwable;
                }
                OS.CFRelease((int)cfstring);
                ++i;
            }
            transferData.data = data;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData) == false) return null;
        if (transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        if (transferData.type == FileTransfer.URILISTID) {
            data = transferData.data[0];
            if (data.length == 0) {
                return null;
            }
            chars = new char[(data.length + 1) / 2];
            OS.memcpy((char[])chars, (byte[])data, (int)data.length);
            str = new String(chars);
            start = str.indexOf("file:");
            if (start == -1) {
                return null;
            }
            start += "file:".length();
            fileNames = new String[]{};
            while (true) {
                if (start >= str.length()) {
                    return fileNames;
                }
                end = str.indexOf("\r", start);
                if (end == -1) {
                    end = str.length() - 1;
                }
                fileName = str.substring(start, end);
                newFileNames = new String[fileNames.length + 1];
                System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
                newFileNames[fileNames.length] = fileName;
                fileNames = newFileNames;
                start = str.indexOf("file:", end);
                if (start == -1) {
                    return fileNames;
                }
                start += "file:".length();
            }
        }
        if (transferData.type != FileTransfer.HFSID) return null;
        count = transferData.data.length;
        fileNames = new String[count];
        i = 0;
        while (true) {
            block24: {
                block23: {
                    if (i >= count) {
                        return fileNames;
                    }
                    data = transferData.data[i];
                    fsspec = new byte[data.length - 10];
                    System.arraycopy(data, 10, fsspec, 0, fsspec.length);
                    fsRef = new byte[80];
                    if (OS.FSpMakeFSRef((byte[])fsspec, (byte[])fsRef) != 0) {
                        return null;
                    }
                    url = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                    if (url == 0) {
                        return null;
                    }
                    try {
                        path = OS.CFURLCopyFileSystemPath((int)url, (int)0);
                        if (path == 0) {
                            var18_23 = null;
                            var16_22 = null;
                            break block23;
                        }
                        try {
                            length = OS.CFStringGetLength((int)path);
                            if (length == 0) {
                                var15_24 = null;
                                var13_21 = null;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var14_25) {
                            var13_21 = null;
                            OS.CFRelease((int)path);
                            throw var14_25;
                        }
                        OS.CFRelease((int)path);
                        break block24;
lbl-1000:
                        // 1 sources

                        {
                            buffer = new char[length];
                            range = new CFRange();
                            range.length = length;
                            OS.CFStringGetCharacters((int)path, (CFRange)range, (char[])buffer);
                            fileNames[i] = new String(buffer);
                        }
                        {
                            var13_21 = null;
                            OS.CFRelease((int)path);
                            ** GOTO lbl-1000
                        }
                    }
                    catch (Throwable var17_26) {
                        var16_22 = null;
                        OS.CFRelease((int)url);
                        throw var17_26;
                    }
                }
                OS.CFRelease((int)url);
                return var18_23;
            }
            var16_22 = null;
            OS.CFRelease((int)url);
            return var15_24;
lbl-1000:
            // 1 sources

            {
                var16_22 = null;
            }
            OS.CFRelease((int)url);
            ++i;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{URILISTID, HFSID};
    }

    protected String[] getTypeNames() {
        return new String[]{URILIST, HFS};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

