/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int TAB_COUNT = 32;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, gdkGC);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC carbon_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int context = drawable.internal_new_GC(data);
        gc.init(drawable, data, context);
        return gc;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.control != 0) {
            int[] offscreen = new int[1];
            OS.HIViewCreateOffscreenImage((int)this.data.control, (int)0, null, (int[])offscreen);
            this.copyArea(image, x, y, offscreen[0]);
            if (offscreen[0] != 0) {
                OS.CGImageRelease((int)offscreen[0]);
            }
        } else if (this.data.image != null) {
            this.copyArea(image, x, y, this.data.image.handle);
        } else if (this.data.window != 0) {
            int imageHandle = image.handle;
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth((int)imageHandle);
            rect.height = OS.CGImageGetHeight((int)imageHandle);
            int[] displays = new int[16];
            int[] count = new int[1];
            if (OS.CGGetDisplaysWithRect((CGRect)rect, (int)displays.length, (int[])displays, (int[])count) != 0) {
                return;
            }
            int i = 0;
            while (i < count[0]) {
                int display = displays[i];
                int address = OS.CGDisplayBaseAddress((int)display);
                if (address != 0) {
                    int width = OS.CGDisplayPixelsWide((int)display);
                    int height = OS.CGDisplayPixelsHigh((int)display);
                    int bpr = OS.CGDisplayBytesPerRow((int)display);
                    int bpp = OS.CGDisplayBitsPerPixel((int)display);
                    int bps = OS.CGDisplayBitsPerSample((int)display);
                    int provider = OS.CGDataProviderCreateWithData((int)0, (int)address, (int)(bpr * height), (int)0);
                    int srcImage = OS.CGImageCreate((int)width, (int)height, (int)bps, (int)bpp, (int)bpr, (int)this.data.device.colorspace, (int)6, (int)provider, null, (boolean)false, (int)0);
                    OS.CGDataProviderRelease((int)provider);
                    this.copyArea(image, x, y, srcImage);
                    if (srcImage != 0) {
                        OS.CGImageRelease((int)srcImage);
                    }
                }
                ++i;
            }
        }
    }

    void copyArea(Image image, int x, int y, int srcImage) {
        int alphaInfo;
        int bpr;
        int height;
        if (srcImage == 0) {
            return;
        }
        int imageHandle = image.handle;
        int bpc = OS.CGImageGetBitsPerComponent((int)imageHandle);
        int width = OS.CGImageGetWidth((int)imageHandle);
        int context = OS.CGBitmapContextCreate((int)image.data, (int)width, (int)(height = OS.CGImageGetHeight((int)imageHandle)), (int)bpc, (int)(bpr = OS.CGImageGetBytesPerRow((int)imageHandle)), (int)this.data.device.colorspace, (int)(alphaInfo = OS.CGImageGetAlphaInfo((int)imageHandle)));
        if (context != 0) {
            CGRect rect = new CGRect();
            rect.x = -x;
            rect.y = y;
            rect.width = OS.CGImageGetWidth((int)srcImage);
            rect.height = OS.CGImageGetHeight((int)srcImage);
            OS.CGContextTranslateCTM((int)context, (float)0.0f, (float)(-(rect.height - (float)height)));
            OS.CGContextDrawImage((int)context, (CGRect)rect, (int)srcImage);
            OS.CGContextRelease((int)context);
        }
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (this.data.image != null) {
            OS.CGContextSaveGState((int)this.handle);
            OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
            OS.CGContextTranslateCTM((int)this.handle, (float)0.0f, (float)(-(height + 2 * destY)));
            CGRect rect = new CGRect();
            rect.x = destX;
            rect.y = destY;
            rect.width = width;
            rect.height = height;
            OS.CGContextDrawImage((int)this.handle, (CGRect)rect, (int)this.data.image.handle);
            OS.CGContextRestoreGState((int)this.handle);
            return;
        }
        if (this.data.control != 0) {
            int port = this.data.port;
            int window = OS.GetControlOwner((int)this.data.control);
            if (port == 0) {
                port = OS.GetWindowPort((int)window);
            }
            Rect rect = new Rect();
            OS.GetControlBounds((int)this.data.control, (Rect)rect);
            Rect srcRect = new Rect();
            int left = rect.left + srcX;
            int top = rect.top + srcY;
            OS.SetRect((Rect)srcRect, (short)((short)left), (short)((short)top), (short)((short)(left + width)), (short)((short)(top + height)));
            int srcRgn = OS.NewRgn();
            OS.RectRgn((int)srcRgn, (Rect)srcRect);
            OS.SectRect((Rect)rect, (Rect)srcRect, (Rect)srcRect);
            Rect destRect = new Rect();
            OS.SetRect((Rect)destRect, (short)srcRect.left, (short)srcRect.top, (short)srcRect.right, (short)srcRect.bottom);
            OS.OffsetRect((Rect)destRect, (short)((short)deltaX), (short)((short)deltaY));
            int destRgn = OS.NewRgn();
            OS.RectRgn((int)destRgn, (Rect)destRect);
            if (!OS.EmptyRect((Rect)srcRect) && (this.data.visibleRgn == 0 || OS.RectInRgn((Rect)srcRect, (int)this.data.visibleRgn))) {
                int clipRgn = this.data.visibleRgn;
                if (this.data.clipRgn != 0) {
                    clipRgn = OS.NewRgn();
                    OS.SectRgn((int)this.data.clipRgn, (int)this.data.visibleRgn, (int)clipRgn);
                }
                if (!OS.EmptyRgn((int)clipRgn)) {
                    boolean disjoint;
                    boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                    if (!(disjoint || deltaX != 0 && deltaY != 0)) {
                        int[] currentPort = new int[1];
                        OS.GetPort((int[])currentPort);
                        OS.SetPort((int)port);
                        int oldClip = OS.NewRgn();
                        OS.GetClip((int)oldClip);
                        OS.SetClip((int)clipRgn);
                        OS.UnionRect((Rect)srcRect, (Rect)destRect, (Rect)rect);
                        OS.ScrollRect((Rect)rect, (short)((short)deltaX), (short)((short)deltaY), (int)0);
                        OS.SetClip((int)oldClip);
                        OS.DisposeRgn((int)oldClip);
                        OS.SetPort((int)currentPort[0]);
                    } else {
                        int portBitMap = OS.GetPortBitMapForCopyBits((int)port);
                        OS.CopyBits((int)portBitMap, (int)portBitMap, (Rect)srcRect, (Rect)destRect, (short)0, (int)clipRgn);
                        OS.QDFlushPortBuffer((int)port, (int)destRgn);
                    }
                }
                if (clipRgn != this.data.visibleRgn) {
                    OS.DisposeRgn((int)clipRgn);
                }
            }
            int invalRgn = OS.NewRgn();
            OS.DiffRgn((int)srcRgn, (int)this.data.visibleRgn, (int)invalRgn);
            OS.OffsetRgn((int)invalRgn, (short)((short)deltaX), (short)((short)deltaY));
            OS.DiffRgn((int)srcRgn, (int)destRgn, (int)srcRgn);
            OS.UnionRgn((int)srcRgn, (int)invalRgn, (int)invalRgn);
            OS.SectRgn((int)this.data.visibleRgn, (int)invalRgn, (int)invalRgn);
            OS.InvalWindowRgn((int)window, (int)invalRgn);
            OS.DisposeRgn((int)invalRgn);
            OS.DisposeRgn((int)destRgn);
            OS.DisposeRgn((int)srcRgn);
        }
    }

    void createLayout() {
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout((int[])buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        this.data.layout = buffer[0];
        int ptr1 = OS.NewPtr((int)4);
        buffer[0] = this.handle;
        OS.memcpy((int)ptr1, (int[])buffer, (int)4);
        int ptr2 = OS.NewPtr((int)4);
        buffer[0] = 0x1000000;
        OS.memcpy((int)ptr2, (int[])buffer, (int)4);
        boolean lineDir = false;
        if ((this.data.style & 0x4000000) != 0) {
            lineDir = true;
        }
        int ptr3 = OS.NewPtr((int)1);
        OS.memcpy((int)ptr3, (byte[])new byte[]{(byte)(lineDir ? 1 : 0)}, (int)1);
        int[] tags = new int[]{Short.MAX_VALUE, 7, 3};
        int[] sizes = new int[]{4, 4, 1};
        int[] values = new int[]{ptr1, ptr2, ptr3};
        OS.ATSUSetLayoutControls((int)this.data.layout, (int)tags.length, (int[])tags, (int[])sizes, (int[])values);
        OS.DisposePtr((int)ptr1);
        OS.DisposePtr((int)ptr2);
        OS.DisposePtr((int)ptr3);
    }

    void createTabs() {
        ATSUTab tabs = new ATSUTab();
        int tabWidth = this.getCharWidth(' ') * 8;
        int ptr = OS.NewPtr((int)192);
        int i = 0;
        int offset = ptr;
        while (i < 32) {
            tabs.tabPosition += OS.Long2Fix((int)tabWidth);
            OS.memcpy((int)offset, (ATSUTab)tabs, (int)6);
            ++i;
            offset += 6;
        }
        this.data.tabs = ptr;
    }

    public void dispose() {
        int tabs;
        int stringPtr;
        int atsuiStyle;
        int layout;
        Image image;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            OS.DisposeRgn((int)clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((layout = this.data.layout) != 0) {
            OS.ATSUDisposeTextLayout((int)layout);
        }
        if ((atsuiStyle = this.data.atsuiStyle) != 0) {
            OS.ATSUDisposeStyle((int)atsuiStyle);
        }
        if ((stringPtr = this.data.stringPtr) != 0) {
            OS.DisposePtr((int)stringPtr);
        }
        if ((tabs = this.data.tabs) != 0) {
            OS.DisposePtr((int)tabs);
        }
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.data.tabs = 0;
        this.data.layout = 0;
        this.data.stringPtr = 0;
        this.data.atsuiStyle = 0;
        this.data.clipRgn = 0;
        this.drawable = null;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
        this.handle = 0;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM((int)this.handle, (float)((float)x + offset + (float)width / 2.0f), (float)((float)y + offset + (float)height / 2.0f));
        OS.CGContextScaleCTM((int)this.handle, (float)((float)width / 2.0f), (float)((float)height / 2.0f));
        OS.CGContextAddArc((int)this.handle, (float)0.0f, (float)0.0f, (float)1.0f, (float)((float)(-startAngle) * (float)Compatibility.PI / 180.0f), (float)((float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f), (boolean)true);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        this.flush();
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int imageHandle = srcImage.handle;
        int imgWidth = OS.CGImageGetWidth((int)imageHandle);
        int imgHeight = OS.CGImageGetHeight((int)imageHandle);
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        OS.CGContextSaveGState((int)this.handle);
        OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)this.handle, (float)0.0f, (float)(-(destHeight + 2 * destY)));
        CGRect rect = new CGRect();
        rect.x = destX;
        rect.y = destY;
        rect.width = destWidth;
        rect.height = destHeight;
        if (simple) {
            OS.CGContextDrawImage((int)this.handle, (CGRect)rect, (int)imageHandle);
        } else {
            int bpc = OS.CGImageGetBitsPerComponent((int)imageHandle);
            int bpp = OS.CGImageGetBitsPerPixel((int)imageHandle);
            int bpr = OS.CGImageGetBytesPerRow((int)imageHandle);
            int colorspace = OS.CGImageGetColorSpace((int)imageHandle);
            int alphaInfo = OS.CGImageGetAlphaInfo((int)imageHandle);
            int data = srcImage.data + srcY * bpr + srcX * 4;
            int provider = OS.CGDataProviderCreateWithData((int)0, (int)data, (int)(srcHeight * bpr), (int)0);
            if (provider != 0) {
                int subImage = OS.CGImageCreate((int)srcWidth, (int)srcHeight, (int)bpc, (int)bpp, (int)bpr, (int)colorspace, (int)alphaInfo, (int)provider, null, (boolean)false, (int)0);
                OS.CGDataProviderRelease((int)provider);
                if (subImage != 0) {
                    OS.CGContextDrawImage((int)this.handle, (CGRect)rect, (int)subImage);
                    OS.CGImageRelease((int)subImage);
                }
            }
        }
        OS.CGContextRestoreGState((int)this.handle);
        this.flush();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (x1 == x2 && y1 == y2 && this.data.lineWidth <= 1) {
            this.drawPoint(x1, y1);
            return;
        }
        OS.CGContextBeginPath((int)this.handle);
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextMoveToPoint((int)this.handle, (float)((float)x1 + offset), (float)((float)y1 + offset));
        OS.CGContextAddLineToPoint((int)this.handle, (float)((float)x2 + offset), (float)((float)y2 + offset));
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM((int)this.handle, (float)((float)x + offset + (float)width / 2.0f), (float)((float)y + offset + (float)height / 2.0f));
        OS.CGContextScaleCTM((int)this.handle, (float)((float)width / 2.0f), (float)((float)height / 2.0f));
        OS.CGContextMoveToPoint((int)this.handle, (float)1.0f, (float)0.0f);
        OS.CGContextAddArc((int)this.handle, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)((float)(2.0 * Compatibility.PI)), (boolean)true);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM((int)this.handle, (float)offset, (float)offset);
        OS.CGContextAddPath((int)this.handle, (int)path.handle);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = 1.0f;
        rect.height = 1.0f;
        OS.CGContextSetFillColor((int)this.handle, (float[])this.data.foreground);
        OS.CGContextFillRect((int)this.handle, (CGRect)rect);
        OS.CGContextSetFillColor((int)this.handle, (float[])this.data.background);
        this.flush();
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = pointArray[i];
            ++i;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextAddLines((int)this.handle, (float[])points, (int)(points.length / 2));
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = (float)pointArray[i] + 0.5f;
            ++i;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextAddLines((int)this.handle, (float[])points, (int)(points.length / 2));
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        rect.x = (float)x + offset;
        rect.y = (float)y + offset;
        rect.width = width;
        rect.height = height;
        OS.CGContextStrokeRect((int)this.handle, (CGRect)rect);
        this.flush();
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.drawRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        float offset = this.data.lineWidth % 2 == 1 ? 0.5f : 0.0f;
        OS.CGContextTranslateCTM((int)this.handle, (float)((float)nx + offset), (float)((float)ny + offset));
        OS.CGContextScaleCTM((int)this.handle, (float)naw2, (float)nah2);
        OS.CGContextMoveToPoint((int)this.handle, (float)(fw - 1.0f), (float)0.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)0.0f, (float)fh, (float)1.0f, (float)fh, (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)fw, (float)fh, (float)fw, (float)(fh - 1.0f), (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)fw, (float)0.0f, (float)(fw - 1.0f), (float)0.0f, (float)1.0f);
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextStrokePath((int)this.handle);
        this.flush();
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if ((length = string.length()) == 0) {
            return;
        }
        length = this.setString(string, flags);
        OS.CGContextSaveGState((int)this.handle);
        OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
        if ((flags & 2) != 0) {
            int layout = this.data.layout;
            int[] breakCount = new int[1];
            OS.ATSUGetSoftLineBreaks((int)layout, (int)0, (int)length, (int)0, null, (int[])breakCount);
            int[] breaks = new int[breakCount[0] + 1];
            OS.ATSUGetSoftLineBreaks((int)layout, (int)0, (int)length, (int)breakCount[0], (int[])breaks, (int[])breakCount);
            breaks[breakCount[0]] = length;
            int i = 0;
            int start = 0;
            while (i < breaks.length) {
                int lineBreak = breaks[i];
                this.drawText(x, y, start, lineBreak - start, flags);
                y += this.data.fontAscent + this.data.fontDescent;
                start = lineBreak;
                ++i;
            }
        } else {
            this.drawText(x, y, 0, length, flags);
        }
        OS.CGContextRestoreGState((int)this.handle);
        this.flush();
    }

    void drawText(int x, int y, int start, int length, int flags) {
        int layout = this.data.layout;
        if ((flags & 1) == 0) {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            OS.ATSUGetGlyphBounds((int)layout, (int)0, (int)0, (int)start, (int)length, (short)1, (int)1, (ATSTrapezoid)trapezoid, null);
            int width = OS.Fix2Long((int)trapezoid.upperRight_x) - OS.Fix2Long((int)trapezoid.upperLeft_x);
            int height = OS.Fix2Long((int)trapezoid.lowerRight_y) - OS.Fix2Long((int)trapezoid.upperRight_y);
            CGRect rect = new CGRect();
            rect.x = x;
            rect.y = -(y + height);
            rect.width = width;
            rect.height = height;
            OS.CGContextSetFillColor((int)this.handle, (float[])this.data.background);
            OS.CGContextFillRect((int)this.handle, (CGRect)rect);
        }
        OS.CGContextSetFillColor((int)this.handle, (float[])this.data.foreground);
        OS.ATSUDrawText((int)layout, (int)start, (int)length, (int)OS.Long2Fix((int)x), (int)OS.Long2Fix((int)(-(y + this.data.fontAscent))));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        OS.CGContextTranslateCTM((int)this.handle, (float)((float)x + (float)width / 2.0f), (float)((float)y + (float)height / 2.0f));
        OS.CGContextScaleCTM((int)this.handle, (float)((float)width / 2.0f), (float)((float)height / 2.0f));
        OS.CGContextMoveToPoint((int)this.handle, (float)0.0f, (float)0.0f);
        OS.CGContextAddArc((int)this.handle, (float)0.0f, (float)0.0f, (float)1.0f, (float)((float)(-startAngle) * (float)Compatibility.PI / 180.0f), (float)((float)(-(startAngle + arcAngle)) * (float)Compatibility.PI / 180.0f), (boolean)true);
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextFillPath((int)this.handle);
        this.flush();
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, 8, 8, 8);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        OS.CGContextTranslateCTM((int)this.handle, (float)((float)x + (float)width / 2.0f), (float)((float)y + (float)height / 2.0f));
        OS.CGContextScaleCTM((int)this.handle, (float)((float)width / 2.0f), (float)((float)height / 2.0f));
        OS.CGContextMoveToPoint((int)this.handle, (float)1.0f, (float)0.0f);
        OS.CGContextAddArc((int)this.handle, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)((float)(Compatibility.PI * 2.0)), (boolean)false);
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextFillPath((int)this.handle);
        this.flush();
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextAddPath((int)this.handle, (int)path.handle);
        OS.CGContextEOFillPath((int)this.handle);
        this.flush();
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] points = new float[pointArray.length];
        int i = 0;
        while (i < points.length) {
            points[i] = pointArray[i];
            ++i;
        }
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextAddLines((int)this.handle, (float[])points, (int)(points.length / 2));
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextEOFillPath((int)this.handle);
        this.flush();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.CGContextFillRect((int)this.handle, (CGRect)rect);
        this.flush();
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw > nw) {
            naw = nw;
        }
        if (nah > nh) {
            nah = nh;
        }
        float naw2 = (float)naw / 2.0f;
        float nah2 = (float)nah / 2.0f;
        float fw = (float)nw / naw2;
        float fh = (float)nh / nah2;
        OS.CGContextBeginPath((int)this.handle);
        OS.CGContextSaveGState((int)this.handle);
        OS.CGContextTranslateCTM((int)this.handle, (float)nx, (float)ny);
        OS.CGContextScaleCTM((int)this.handle, (float)naw2, (float)nah2);
        OS.CGContextMoveToPoint((int)this.handle, (float)(fw - 1.0f), (float)0.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)0.0f, (float)fh, (float)1.0f, (float)fh, (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)fw, (float)fh, (float)fw, (float)(fh - 1.0f), (float)1.0f);
        OS.CGContextAddArcToPoint((int)this.handle, (float)fw, (float)0.0f, (float)(fw - 1.0f), (float)0.0f, (float)1.0f);
        OS.CGContextClosePath((int)this.handle);
        OS.CGContextRestoreGState((int)this.handle);
        OS.CGContextFillPath((int)this.handle);
        this.flush();
    }

    void flush() {
        if (this.data.control != 0 && this.data.paintEvent == 0) {
            if (this.data.thread != Thread.currentThread()) {
                OS.CGContextFlush((int)this.handle);
            } else {
                OS.CGContextSynchronize((int)this.handle);
            }
        }
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.carbon_new(this.data.device, this.data.background);
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Region region = new Region();
        this.getClipping(region);
        Rectangle rect = region.getBounds();
        region.dispose();
        return rect;
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Rect bounds = null;
        int clipping = region.handle;
        if (this.data.clipRgn == 0) {
            int width = 0;
            int height = 0;
            if (this.data.control != 0) {
                if (bounds == null) {
                    bounds = new Rect();
                }
                OS.GetControlBounds((int)this.data.control, (Rect)bounds);
                width = bounds.right - bounds.left;
                height = bounds.bottom - bounds.top;
            } else if (this.data.image != null) {
                int image = this.data.image.handle;
                width = OS.CGImageGetWidth((int)image);
                height = OS.CGImageGetHeight((int)image);
            }
            OS.SetRectRgn((int)clipping, (short)0, (short)0, (short)((short)width), (short)((short)height));
        } else {
            OS.CopyRgn((int)this.data.clipRgn, (int)clipping);
            if (!this.isIdentity(this.data.transform)) {
                return;
            }
        }
        if (this.data.paintEvent != 0 && this.data.visibleRgn != 0) {
            if (bounds == null) {
                bounds = new Rect();
            }
            OS.GetControlBounds((int)this.data.control, (Rect)bounds);
            OS.OffsetRgn((int)this.data.visibleRgn, (short)(-bounds.left), (short)(-bounds.top));
            OS.SectRgn((int)this.data.visibleRgn, (int)clipping, (int)clipping);
            OS.OffsetRgn((int)this.data.visibleRgn, (short)bounds.left, (short)bounds.top);
        }
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Font font = this.data.font;
        FontInfo info = new FontInfo();
        OS.FetchFontInfo((short)font.id, (short)font.size, (short)font.style, (FontInfo)info);
        short ascent = info.ascent;
        short descent = info.descent;
        short leading = info.leading;
        String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int averageCharWidth = this.stringExtent((String)s).x / s.length();
        return FontMetrics.carbon_new(ascent, descent, averageCharWidth, leading, ascent + leading + descent);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.carbon_new(this.data.device, this.data.foreground);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        float[] lengths;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((lengths = this.data.dashes) == null) {
            return null;
        }
        int[] dashes = new int[lengths.length];
        int i = 0;
        while (i < dashes.length) {
            dashes[i] = (int)lengths[i];
            ++i;
        }
        return dashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public void getTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] cmt = this.data.transform;
        transform.setElements(cmt[0], cmt[1], cmt[2], cmt[3], cmt[4], cmt[5]);
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int context) {
        Image image;
        float[] background;
        int colorspace = data.device.colorspace;
        OS.CGContextSetStrokeColorSpace((int)context, (int)colorspace);
        OS.CGContextSetFillColorSpace((int)context, (int)colorspace);
        float[] foreground = data.foreground;
        if (foreground != null) {
            OS.CGContextSetStrokeColor((int)context, (float[])foreground);
        }
        if ((background = data.background) != null) {
            OS.CGContextSetFillColor((int)context, (float[])background);
        }
        if ((image = data.image) != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = context;
        if (data.font != null) {
            this.setGCFont();
        }
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(float[] transform) {
        return transform[0] == 1.0f && transform[1] == 0.0f && transform[2] == 0.0f && transform[3] == 1.0f && transform[4] == 0.0f && transform[5] == 0.0f;
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = alpha & 0xFF;
        OS.CGContextSetAlpha((int)this.handle, (float)((float)this.data.alpha / 255.0f));
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        OS.CGContextSetFillColor((int)this.handle, (float[])color.handle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setClipping(int clipRgn) {
        if (clipRgn == 0) {
            if (this.data.clipRgn == 0) return;
            OS.DisposeRgn((int)this.data.clipRgn);
            this.data.clipRgn = 0;
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.NewRgn();
            }
            OS.CopyRgn((int)clipRgn, (int)this.data.clipRgn);
        }
        this.data.updateClip = true;
        this.setCGClipping();
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        int clipRgn = OS.NewRgn();
        OS.SetRectRgn((int)clipRgn, (short)((short)x), (short)((short)y), (short)((short)(x + width)), (short)((short)(y + height)));
        this.setClipping(clipRgn);
        OS.DisposeRgn((int)clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            OS.CGContextAddPath((int)this.handle, (int)path.handle);
            OS.CGContextEOClip((int)this.handle);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    void setCGClipping() {
        this.data.updateClip = false;
        if (this.data.control == 0) {
            OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
            if (this.data.clipRgn != 0) {
                OS.ClipCGContextToRegion((int)this.handle, (Rect)new Rect(), (int)this.data.clipRgn);
            } else {
                int rgn = OS.NewRgn();
                OS.SetRectRgn((int)rgn, (short)Short.MIN_VALUE, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
                OS.ClipCGContextToRegion((int)this.handle, (Rect)new Rect(), (int)rgn);
                OS.DisposeRgn((int)rgn);
            }
            OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
            return;
        }
        int port = this.data.port;
        if (port == 0) {
            int window = OS.GetControlOwner((int)this.data.control);
            port = OS.GetWindowPort((int)window);
        }
        Rect portRect = this.data.portRect;
        Rect rect = this.data.controlRect;
        OS.CGContextTranslateCTM((int)this.handle, (float)(-rect.left), (float)(portRect.bottom - portRect.top - rect.top));
        OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
        OS.GetPortBounds((int)port, (Rect)portRect);
        OS.GetControlBounds((int)this.data.control, (Rect)rect);
        if (this.data.clipRgn != 0) {
            int rgn = OS.NewRgn();
            OS.CopyRgn((int)this.data.clipRgn, (int)rgn);
            OS.OffsetRgn((int)rgn, (short)rect.left, (short)rect.top);
            OS.SectRgn((int)this.data.visibleRgn, (int)rgn, (int)rgn);
            OS.ClipCGContextToRegion((int)this.handle, (Rect)portRect, (int)rgn);
            OS.DisposeRgn((int)rgn);
        } else {
            OS.ClipCGContextToRegion((int)this.handle, (Rect)portRect, (int)this.data.visibleRgn);
        }
        OS.CGContextScaleCTM((int)this.handle, (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)this.handle, (float)rect.left, (float)(-(portRect.bottom - portRect.top) + rect.top));
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.systemFont;
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font;
        this.setGCFont();
    }

    void setGCFont() {
        int tabs = this.data.tabs;
        if (tabs != 0) {
            OS.DisposePtr((int)tabs);
        }
        this.data.tabs = 0;
        Font font = this.data.font;
        FontInfo info = new FontInfo();
        OS.FetchFontInfo((short)font.id, (short)font.size, (short)font.style, (FontInfo)info);
        this.data.fontAscent = info.ascent;
        this.data.fontDescent = info.descent;
        if (font.atsuiStyle == 0) {
            if (this.data.atsuiStyle != 0) {
                OS.ATSUDisposeStyle((int)this.data.atsuiStyle);
            }
            this.data.atsuiStyle = font.createStyle();
        }
        this.data.string = null;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        OS.CGContextSetStrokeColor((int)this.handle, (float[])color.handle);
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int cap_style = 0;
        switch (cap) {
            case 2: {
                cap_style = 1;
                break;
            }
            case 1: {
                cap_style = 0;
                break;
            }
            case 3: {
                cap_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        OS.CGContextSetLineCap((int)this.handle, (int)cap_style);
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] lengths = null;
        if (dashes != null && dashes.length != 0) {
            lengths = new float[dashes.length];
            int i = 0;
            while (i < lengths.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                lengths[i] = dash;
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            this.data.lineStyle = 1;
        }
        OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])lengths, (int)(lengths != null ? lengths.length : 0));
        this.data.dashes = lengths;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int join_style = 0;
        switch (join) {
            case 1: {
                join_style = 0;
                break;
            }
            case 2: {
                join_style = 1;
                break;
            }
            case 3: {
                join_style = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        OS.CGContextSetLineJoin((int)this.handle, (int)join_style);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (lineStyle) {
            case 1: {
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, null, (int)0);
                break;
            }
            case 2: {
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])new float[]{18.0f, 6.0f}, (int)2);
                break;
            }
            case 3: {
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])new float[]{3.0f, 3.0f}, (int)2);
                break;
            }
            case 4: {
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])new float[]{9.0f, 6.0f, 3.0f, 6.0f}, (int)4);
                break;
            }
            case 5: {
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, (int)6);
                break;
            }
            case 6: {
                float[] lengths = this.data.dashes;
                if (lengths != null) {
                    OS.CGContextSetLineDash((int)this.handle, (float)0.0f, (float[])lengths, (int)lengths.length);
                    break;
                }
                OS.CGContextSetLineDash((int)this.handle, (float)0.0f, null, (int)0);
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
    }

    public void setLineWidth(int width) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.lineWidth = width;
        OS.CGContextSetLineWidth((int)this.handle, (float)width);
    }

    int setString(String string, int flags) {
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return this.data.stringLength;
        }
        int layout = this.data.layout;
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int breakCount = 0;
        int[] breaks = null;
        if ((flags & 0xA) != 0) {
            int i = 0;
            int j = 0;
            block4: while (i < chars.length) {
                int n = j++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '&': {
                        if ((flags & 8) == 0 || i == chars.length) continue block4;
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        --j;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) == 0) break;
                        if (c2 == '\r' && i != chars.length && chars[i] == '\n') {
                            ++i;
                        }
                        --j;
                        if (breaks == null) {
                            breaks = new int[4];
                        } else if (breakCount == breaks.length) {
                            int[] newBreaks = new int[breaks.length + 4];
                            System.arraycopy(breaks, 0, newBreaks, 0, breaks.length);
                            breaks = newBreaks;
                        }
                        breaks[breakCount++] = j;
                    }
                }
            }
            length = j;
        }
        if ((flags & 4) != 0) {
            if (this.data.tabs == 0) {
                this.createTabs();
            }
            OS.ATSUSetTabArray((int)layout, (int)this.data.tabs, (int)32);
        } else {
            OS.ATSUSetTabArray((int)layout, (int)0, (int)0);
        }
        int ptr = OS.NewPtr((int)(length * 2));
        OS.memcpy((int)ptr, (char[])chars, (int)(length * 2));
        OS.ATSUSetTextPointerLocation((int)layout, (int)ptr, (int)0, (int)length, (int)length);
        if ((flags & 2) != 0 && breaks != null) {
            int i = 0;
            while (i < breakCount) {
                OS.ATSUSetSoftLineBreak((int)layout, (int)breaks[i]);
                ++i;
            }
        }
        Font font = this.data.font;
        int atsuiStyle = font.atsuiStyle != 0 ? font.atsuiStyle : this.data.atsuiStyle;
        OS.ATSUSetRunStyle((int)layout, (int)atsuiStyle, (int)0, (int)length);
        OS.ATSUSetTransientFontMatching((int)layout, (boolean)true);
        if (this.data.stringPtr != 0) {
            OS.DisposePtr((int)this.data.stringPtr);
        }
        this.data.stringPtr = ptr;
        this.data.string = string;
        this.data.stringLength = length;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
        return length;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
    }

    int regionToRects(int message, int rgn, int r, int newRgn) {
        if (message == 2) {
            Rect rect = new Rect();
            OS.memcpy((Rect)rect, (int)r, (int)8);
            CGPoint point = new CGPoint();
            int polyRgn = OS.NewRgn();
            OS.OpenRgn();
            point.x = rect.left;
            point.y = rect.top;
            OS.CGPointApplyAffineTransform((CGPoint)point, (float[])this.data.inverseTransform, (CGPoint)point);
            OS.MoveTo((short)((short)Math.round(point.x)), (short)((short)Math.round(point.y)));
            point.x = rect.right;
            point.y = rect.top;
            OS.CGPointApplyAffineTransform((CGPoint)point, (float[])this.data.inverseTransform, (CGPoint)point);
            OS.LineTo((short)((short)Math.round(point.x)), (short)((short)Math.round(point.y)));
            point.x = rect.right;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform((CGPoint)point, (float[])this.data.inverseTransform, (CGPoint)point);
            OS.LineTo((short)((short)Math.round(point.x)), (short)((short)Math.round(point.y)));
            point.x = rect.left;
            point.y = rect.bottom;
            OS.CGPointApplyAffineTransform((CGPoint)point, (float[])this.data.inverseTransform, (CGPoint)point);
            OS.LineTo((short)((short)Math.round(point.x)), (short)((short)Math.round(point.y)));
            OS.CloseRgn((int)polyRgn);
            OS.UnionRgn((int)newRgn, (int)polyRgn, (int)newRgn);
            OS.DisposeRgn((int)polyRgn);
        }
        return 0;
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        OS.CGContextConcatCTM((int)this.handle, (float[])this.data.inverseTransform);
        OS.CGContextConcatCTM((int)this.handle, (float[])transform.handle);
        System.arraycopy(transform.handle, 0, this.data.transform, 0, this.data.transform.length);
        System.arraycopy(transform.handle, 0, this.data.inverseTransform, 0, this.data.inverseTransform.length);
        OS.CGAffineTransformInvert((float[])this.data.inverseTransform, (float[])this.data.inverseTransform);
        int clipRgn = this.data.clipRgn;
        if (clipRgn != 0) {
            int newRgn = OS.NewRgn();
            new Region();
            Callback callback = new Callback(this, "regionToRects", 4);
            int proc = callback.getAddress();
            if (proc != 0) {
                OS.QDRegionToRects((int)clipRgn, (int)5, (int)proc, (int)newRgn);
                callback.dispose();
            }
            OS.DisposeRgn((int)clipRgn);
            this.data.clipRgn = newRgn;
        }
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        int height;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int length = this.setString(string, flags);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int width = 0;
        if (length == 0) {
            height = this.data.fontAscent + this.data.fontDescent;
        } else {
            ATSTrapezoid trapezoid = new ATSTrapezoid();
            if ((flags & 2) != 0) {
                height = 0;
                int layout = this.data.layout;
                int[] breakCount = new int[1];
                OS.ATSUGetSoftLineBreaks((int)layout, (int)0, (int)length, (int)0, null, (int[])breakCount);
                int[] breaks = new int[breakCount[0] + 1];
                OS.ATSUGetSoftLineBreaks((int)layout, (int)0, (int)length, (int)breakCount[0], (int[])breaks, (int[])breakCount);
                breaks[breakCount[0]] = length;
                int i = 0;
                int start = 0;
                while (i < breaks.length) {
                    int lineBreak = breaks[i];
                    OS.ATSUGetGlyphBounds((int)layout, (int)0, (int)0, (int)start, (int)(lineBreak - start), (short)1, (int)1, (ATSTrapezoid)trapezoid, null);
                    width = Math.max(width, OS.Fix2Long((int)trapezoid.upperRight_x) - OS.Fix2Long((int)trapezoid.upperLeft_x));
                    height += OS.Fix2Long((int)trapezoid.lowerRight_y) - OS.Fix2Long((int)trapezoid.upperRight_y);
                    start = lineBreak;
                    ++i;
                }
            } else {
                OS.ATSUGetGlyphBounds((int)this.data.layout, (int)0, (int)0, (int)0, (int)length, (short)1, (int)1, (ATSTrapezoid)trapezoid, null);
                width = OS.Fix2Long((int)trapezoid.upperRight_x) - OS.Fix2Long((int)trapezoid.upperLeft_x);
                height = OS.Fix2Long((int)trapezoid.lowerRight_y) - OS.Fix2Long((int)trapezoid.upperRight_y);
            }
        }
        this.data.stringWidth = width;
        this.data.stringHeight = height;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

