/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSLayoutRecord;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public class Path {
    public int handle;
    Device device;
    float originX;
    float originY;
    float[] point = new float[2];
    boolean first;

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.CGPathCreateMutable();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] cmt = new float[6];
        OS.CGAffineTransformMake((float)(width / 2.0f), (float)0.0f, (float)0.0f, (float)(height / 2.0f), (float)(x + width / 2.0f), (float)(y + height / 2.0f), (float[])cmt);
        OS.CGPathAddArc((int)this.handle, (float[])cmt, (float)0.0f, (float)0.0f, (float)1.0f, (float)(-startAngle * (float)Compatibility.PI / 180.0f), (float)(-(startAngle + arcAngle) * (float)Compatibility.PI / 180.0f), (boolean)true);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        OS.CGPathAddPath((int)this.handle, null, (int)path.handle);
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        CGRect rect = new CGRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.CGPathAddRect((int)this.handle, null, (CGRect)rect);
    }

    int newPathProc(int data) {
        this.first = true;
        return 0;
    }

    int closePathProc(int data) {
        this.first = true;
        return 0;
    }

    int lineProc(int pt1, int pt2, int data) {
        if (this.first) {
            this.first = false;
            OS.memcpy((float[])this.point, (int)pt1, (int)8);
            OS.CGPathMoveToPoint((int)this.handle, null, (float)(this.originX + this.point[0]), (float)(this.originY + this.point[1]));
        }
        OS.memcpy((float[])this.point, (int)pt2, (int)8);
        OS.CGPathAddLineToPoint((int)this.handle, null, (float)(this.originX + this.point[0]), (float)(this.originY + this.point[1]));
        return 0;
    }

    int curveProc(int pt1, int controlPt, int pt2, int data) {
        if (this.first) {
            this.first = false;
            OS.memcpy((float[])this.point, (int)pt1, (int)8);
            OS.CGPathMoveToPoint((int)this.handle, null, (float)(this.originX + this.point[0]), (float)(this.originY + this.point[1]));
        }
        OS.memcpy((float[])this.point, (int)pt2, (int)8);
        float x2 = this.point[0];
        float y2 = this.point[1];
        OS.memcpy((float[])this.point, (int)controlPt, (int)8);
        OS.CGPathAddQuadCurveToPoint((int)this.handle, null, (float)(this.originX + this.point[0]), (float)(this.originY + this.point[1]), (float)(this.originX + x2), (float)(this.originY + y2));
        return 0;
    }

    public void addString(String string, float x, float y, Font font) {
        int style;
        Callback closePathCallback;
        int closePathProc;
        Callback curveCallback;
        int curveProc;
        Callback lineCallback;
        int lineProc;
        int length;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((length = string.length()) == 0) {
            return;
        }
        Callback newPathCallback = new Callback(this, "newPathProc", 1);
        int newPathProc = newPathCallback.getAddress();
        if (newPathProc == 0) {
            SWT.error(3);
        }
        if ((lineProc = (lineCallback = new Callback(this, "lineProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((curveProc = (curveCallback = new Callback(this, "curveProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((closePathProc = (closePathCallback = new Callback(this, "closePathProc", 1)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((style = font.atsuiStyle) == 0) {
            style = font.createStyle();
        }
        if (style == 0) {
            SWT.error(2);
        }
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout((int[])buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        int layout = buffer[0];
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int textPtr = OS.NewPtr((int)(length * 2));
        if (textPtr == 0) {
            SWT.error(2);
        }
        OS.memcpy((int)textPtr, (char[])chars, (int)(length * 2));
        OS.ATSUSetTextPointerLocation((int)layout, (int)textPtr, (int)0, (int)length, (int)length);
        OS.ATSUSetRunStyle((int)layout, (int)style, (int)0, (int)length);
        OS.ATSUSetTransientFontMatching((int)layout, (boolean)true);
        int[] ascent = new int[1];
        int[] descent = new int[1];
        OS.ATSUGetUnjustifiedBounds((int)layout, (int)0, (int)length, null, null, (int[])ascent, (int[])descent);
        y = (float)((double)y + OS.Fix2X((int)ascent[0]));
        int[] layoutRecords = new int[1];
        int[] numRecords = new int[1];
        int[] deltaYs = new int[1];
        int[] numDeltaYs = new int[1];
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout((int)layout, (int)0, (int)100, (int[])layoutRecords, (int[])numRecords);
        OS.ATSUDirectGetLayoutDataArrayPtrFromTextLayout((int)layout, (int)0, (int)1, (int[])deltaYs, (int[])numDeltaYs);
        int[] deltaY = new int[1];
        int[] status = new int[1];
        ATSLayoutRecord record = new ATSLayoutRecord();
        int i = 0;
        while (i < numRecords[0]) {
            OS.memcpy((ATSLayoutRecord)record, (int)(layoutRecords[0] + i * 14), (int)14);
            this.originX = x + (float)OS.Fix2X((int)record.realPos);
            if (deltaYs[0] == 0) {
                this.originY = y;
            } else {
                OS.memcpy((int[])deltaY, (int)(deltaYs[0] + i * 4), (int)4);
                this.originY = y - (float)OS.Fix2X((int)deltaY[0]);
            }
            this.first = true;
            if (record.glyphID != 65535) {
                OS.ATSUGlyphGetQuadraticPaths((int)style, (short)record.glyphID, (int)newPathProc, (int)lineProc, (int)curveProc, (int)closePathProc, (int)0, (int[])status);
            }
            ++i;
        }
        OS.CGPathCloseSubpath((int)this.handle);
        if (deltaYs[0] != 0) {
            OS.ATSUDirectReleaseLayoutDataArrayPtr((int)0, (int)1, (int)deltaYs[0]);
        }
        OS.ATSUDirectReleaseLayoutDataArrayPtr((int)0, (int)100, (int)layoutRecords[0]);
        if (style != font.atsuiStyle) {
            OS.ATSUDisposeStyle((int)style);
        }
        if (layout != 0) {
            OS.ATSUDisposeTextLayout((int)layout);
        }
        if (textPtr != 0) {
            OS.DisposePtr((int)textPtr);
        }
        newPathCallback.dispose();
        lineCallback.dispose();
        curveCallback.dispose();
        closePathCallback.dispose();
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathCloseSubpath((int)this.handle);
    }

    public void curveTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddCurveToPoint((int)this.handle, null, (float)cx1, (float)cy1, (float)cx2, (float)cy2, (float)x, (float)y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        OS.CGPathRelease((int)this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        CGPoint pt = new CGPoint();
        OS.CGPathGetCurrentPoint((int)this.handle, (CGPoint)pt);
        point[0] = pt.x;
        point[1] = pt.y;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddLineToPoint((int)this.handle, null, (float)x, (float)y);
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathMoveToPoint((int)this.handle, null, (float)x, (float)y);
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGPathAddQuadCurveToPoint((int)this.handle, null, (float)cx, (float)cy, (float)x, (float)y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

