/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;

public class Transform {
    public float[] handle;
    Device device;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new float[6];
        OS.CGAffineTransformMake((float)m11, (float)m12, (float)m21, (float)m22, (float)dx, (float)dy, (float[])this.handle);
        if (this.handle == null) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        System.arraycopy(this.handle, 0, elements, 0, this.handle.length);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.handle[0] * this.handle[3] - this.handle[1] * this.handle[2] == 0.0f) {
            SWT.error(10);
        }
        OS.CGAffineTransformInvert((float[])this.handle, (float[])this.handle);
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle[0] == 1.0f && this.handle[1] == 0.0f && this.handle[2] == 0.0f && this.handle[3] == 1.0f && this.handle[4] == 0.0f && this.handle[5] == 0.0f;
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        OS.CGAffineTransformConcat((float[])matrix.handle, (float[])this.handle, (float[])this.handle);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformRotate((float[])this.handle, (float)(angle * (float)Compatibility.PI / 180.0f), (float[])this.handle);
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformScale((float[])this.handle, (float)scaleX, (float)scaleY, (float[])this.handle);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformMake((float)m11, (float)m12, (float)m21, (float)m22, (float)dx, (float)dy, (float[])this.handle);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        CGPoint point = new CGPoint();
        int length = pointArray.length / 2;
        int i = 0;
        int j = 0;
        while (i < length) {
            point.x = pointArray[j];
            point.y = pointArray[j + 1];
            OS.CGPointApplyAffineTransform((CGPoint)point, (float[])this.handle, (CGPoint)point);
            pointArray[j] = point.x;
            pointArray[j + 1] = point.y;
            ++i;
            j += 2;
        }
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.CGAffineTransformTranslate((float[])this.handle, (float)offsetX, (float)offsetY, (float[])this.handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }
}

