/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    static final int WAKE_CLASS = 0;
    static final int WAKE_KIND = 0;
    Event[] eventQueue;
    Callback actionCallback;
    Callback appleEventCallback;
    Callback commandCallback;
    Callback controlCallback;
    Callback drawItemCallback;
    Callback itemDataCallback;
    Callback itemNotificationCallback;
    Callback itemCompareCallback;
    Callback hitTestCallback;
    Callback keyboardCallback;
    Callback menuCallback;
    Callback mouseHoverCallback;
    Callback helpCallback;
    Callback mouseCallback;
    Callback trackingCallback;
    Callback windowCallback;
    Callback colorCallback;
    Callback textInputCallback;
    int actionProc;
    int appleEventProc;
    int commandProc;
    int controlProc;
    int drawItemProc;
    int itemDataProc;
    int itemNotificationProc;
    int itemCompareProc;
    int helpProc;
    int hitTestProc;
    int keyboardProc;
    int menuProc;
    int mouseHoverProc;
    int mouseProc;
    int trackingProc;
    int windowProc;
    int colorProc;
    int textInputProc;
    EventTable eventTable;
    EventTable filterTable;
    int queue;
    int lastModifiers;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    int freeSlot;
    int[] indexTable;
    int[] property;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT0 = 1937208368;
    int focusEvent;
    Control focusControl;
    Combo focusCombo;
    boolean ignoreFocus;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    static final int ID_TEMPORARY = 1000;
    static final int ID_START = 1001;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    boolean allowTimers = true;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    Control grabControl;
    Control mouseUpControl;
    boolean grabbing;
    int helpString;
    Control helpControl;
    int lastHelpX;
    int lastHelpY;
    Control currentControl;
    int mouseHoverID;
    Point dragMouseStart = null;
    boolean dragging = false;
    Rect buttonInset;
    Rect tabFolderNorthInset;
    Rect tabFolderSouthInset;
    Rect comboInset;
    Rect spinnerInset;
    boolean smallFonts;
    boolean noFocusRing;
    int kchrPtr;
    int[] kchrState = new int[1];
    int errorImage;
    int infoImage;
    int warningImage;
    int errorImageData;
    int infoImageData;
    int warningImageData;
    Cursor[] cursors = new Cursor[22];
    static int[][] KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {71, 16777299}, {114, 0x1000051}};
    static String APP_NAME = "SWT";
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Object data;
    String[] keys;
    Object[] values;

    static {
        Displays = new Display[4];
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    int actionProc(int theControl, int partCode) {
        Widget widget = this.getWidget(theControl);
        if (widget != null) {
            return widget.actionProc(theControl, partCode);
        }
        return 0;
    }

    int appleEventProc(int nextHandler, int theEvent, int userData) {
        int[] aeEventID = new int[1];
        if (OS.GetEventParameter((int)theEvent, (int)1702261865, (int)1954115685, null, (int)4, null, (int[])aeEventID) == 0 && aeEventID[0] == 1903520116) {
            Event event = new Event();
            this.sendEvent(21, event);
            if (event.doit) {
                this.dispose();
                System.exit(0);
            }
            return -128;
        }
        return -9874;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                menu.id = (short)(1001 + i);
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 12];
        menu.id = (short)(1001 + this.menus.length);
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        this.property[0] = this.freeSlot + 1;
        OS.SetControlProperty((int)handle, (int)1937208368, (int)1937208368, (int)4, (int[])this.property);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.SysBeep((short)100);
    }

    int caretProc(int id, int clientData) {
        if (this.currentCaret == null || this.currentCaret.isDisposed()) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            OS.SetEventLoopTimerNextFireTime((int)id, (double)((double)blinkRate / 1000.0));
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    int[] createImage(int type) {
        int[] ref = new int[1];
        int result = OS.GetIconRef((short)Short.MIN_VALUE, (int)1835098995, (int)type, (int[])ref);
        if (result != 0) {
            return null;
        }
        int[] family = new int[1];
        result = OS.IconRefToIconFamily((int)ref[0], (int)-1, (int[])family);
        OS.ReleaseIconRef((int)ref[0]);
        if (result != 0) {
            return null;
        }
        int dataHandle = OS.NewHandle((int)0);
        result = OS.GetIconFamilyData((int)family[0], (int)1768698674, (int)dataHandle);
        if (result != 0) {
            OS.DisposeHandle((int)dataHandle);
            OS.DisposeHandle((int)family[0]);
            return null;
        }
        int maskHandle = OS.NewHandle((int)0);
        result = OS.GetIconFamilyData((int)family[0], (int)1815637355, (int)maskHandle);
        if (result != 0) {
            OS.DisposeHandle((int)maskHandle);
            OS.DisposeHandle((int)dataHandle);
            OS.DisposeHandle((int)family[0]);
            return null;
        }
        int width = 32;
        int height = 32;
        int bpr = width * 4;
        int dataSize = OS.GetHandleSize((int)dataHandle);
        int data = OS.NewPtrClear((int)dataSize);
        if (data == 0) {
            OS.DisposeHandle((int)maskHandle);
            OS.DisposeHandle((int)dataHandle);
            OS.DisposeHandle((int)family[0]);
            return null;
        }
        OS.HLock((int)dataHandle);
        OS.HLock((int)maskHandle);
        int[] iconPtr = new int[1];
        int[] maskPtr = new int[1];
        OS.memcpy((int[])iconPtr, (int)dataHandle, (int)4);
        OS.memcpy((int[])maskPtr, (int)maskHandle, (int)4);
        OS.memcpy((int)data, (int)iconPtr[0], (int)dataSize);
        int pixelCount = dataSize / 4;
        int i = 0;
        while (i < pixelCount) {
            OS.memcpy((int)(data + i * 4), (int)(maskPtr[0] + i), (int)1);
            ++i;
        }
        OS.HUnlock((int)maskHandle);
        OS.HUnlock((int)dataHandle);
        OS.DisposeHandle((int)maskHandle);
        OS.DisposeHandle((int)dataHandle);
        OS.DisposeHandle((int)family[0]);
        int provider = OS.CGDataProviderCreateWithData((int)0, (int)data, (int)dataSize, (int)0);
        if (provider == 0) {
            OS.DisposePtr((int)data);
            return null;
        }
        int colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (colorspace == 0) {
            OS.CGDataProviderRelease((int)provider);
            OS.DisposePtr((int)data);
            return null;
        }
        int cgImage = OS.CGImageCreate((int)width, (int)height, (int)8, (int)32, (int)bpr, (int)colorspace, (int)4, (int)provider, null, (boolean)false, (int)0);
        OS.CGColorSpaceRelease((int)colorspace);
        OS.CGDataProviderRelease((int)provider);
        return new int[]{cgImage, data};
    }

    int createOverlayWindow() {
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memcpy((int[])ptr, (int)gdevice, (int)4);
        GDevice device = new GDevice();
        OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
        Rect rect = new Rect();
        OS.SetRect((Rect)rect, (short)device.left, (short)device.top, (short)device.right, (short)device.bottom);
        int[] outWindow = new int[1];
        OS.CreateNewWindow((int)14, (int)0, (Rect)rect, (int[])outWindow);
        if (outWindow[0] == 0) {
            SWT.error(2);
        }
        return outWindow[0];
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        Widget widget = this.getWidget(inControl);
        if (widget != null) {
            return widget.colorProc(inControl, inMessage, inDrawDepth, inDrawInColor);
        }
        return -9874;
    }

    int commandProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind((int)theEvent);
        HICommand command = new HICommand();
        OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1751346532, null, (int)14, null, (HICommand)command);
        switch (eventKind) {
            case 1: {
                if (command.commandID == 1903520116) {
                    this.close();
                    return 0;
                }
                if ((command.attributes & 1) == 0) break;
                if (userData != 0) {
                    Widget widget = this.getWidget(userData);
                    if (widget == null) break;
                    return widget.commandProc(nextHandler, theEvent, userData);
                }
                int menuRef = command.menu_menuRef;
                short menuID = OS.GetMenuID((int)menuRef);
                Menu menu = this.getMenu(menuID);
                if (menu != null) {
                    MenuItem item = null;
                    item = menu.closed && menu.modified ? menu.lastTarget : menu.getItem(command.menu_menuItemIndex - 1);
                    if (item != null) {
                        return item.kEventProcessCommand(nextHandler, theEvent, userData);
                    }
                }
                OS.HiliteMenu((short)0);
            }
        }
        return -9874;
    }

    Rect computeInset(int control) {
        int tempRgn = OS.NewRgn();
        Rect rect = new Rect();
        OS.GetControlRegion((int)control, (short)-1, (int)tempRgn);
        OS.GetControlBounds((int)control, (Rect)rect);
        Rect rgnRect = new Rect();
        OS.GetRegionBounds((int)tempRgn, (Rect)rgnRect);
        OS.DisposeRgn((int)tempRgn);
        rect.left = (short)(rect.left - rgnRect.left);
        rect.top = (short)(rect.top - rgnRect.top);
        rect.right = (short)(rgnRect.right - rect.right);
        rect.bottom = (short)(rgnRect.bottom - rect.bottom);
        return rect;
    }

    int controlProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget != null) {
            return widget.controlProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    static String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    void clearMenuFlags() {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null) {
                menu.closed = false;
                menu.modified = false;
                menu.lastTarget = null;
            }
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        int[] psn = new int[2];
        if (OS.GetCurrentProcess((int[])psn) == 0) {
            if (APP_NAME != null) {
                byte[] buffer = new byte[APP_NAME.length() + 1];
                int i = 0;
                while (i < buffer.length - 1) {
                    buffer[i] = (byte)APP_NAME.charAt(i);
                    ++i;
                }
                OS.CPSSetProcessName((int[])psn, (byte[])buffer);
            }
            OS.CPSEnableForegroundOperation((int[])psn, (int)3, (int)60, (int)44, (int)4355);
            OS.SetFrontProcess((int[])psn);
        }
        OS.ClearMenuBar();
        this.queue = OS.GetCurrentEventQueue();
        OS.TXNInitTextension((int)0, (int)0, (int)0);
    }

    static synchronized void deregister(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (display == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void dragDetect(Control control) {
        if (!this.dragging && control.hooks(29) && this.dragMouseStart != null && OS.WaitMouseMoved((Point)this.dragMouseStart)) {
            this.dragging = true;
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)control.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = this.dragMouseStart.h - rect.left;
            int y = this.dragMouseStart.v - rect.top;
            OS.GetControlBounds((int)control.handle, (Rect)rect);
            Event event = new Event();
            event.x = x -= rect.left;
            event.y = y -= rect.top;
            control.sendEvent(29, event);
            this.dragMouseStart = null;
        }
    }

    int drawItemProc(int browser, int item, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.drawItemProc(browser, item, property, itemState, theRect, gdDepth, colorDevice);
        }
        return 0;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (OS.IsWindowActive((int)shell.shellHandle)) {
                    return shell;
                }
            }
            ++i;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int gdevice = OS.GetDeviceList();
        if (gdevice == 0 || OS.GetNextDevice((int)gdevice) == 0) {
            return super.getBounds();
        }
        Monitor[] monitors = this.getMonitors();
        Rectangle rect = monitors[0].getBounds();
        int i = 1;
        while (i < monitors.length) {
            rect = rect.union(monitors[i].getBounds());
            ++i;
        }
        return rect;
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return OS.GetCaretTime() * 1000 / 60;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int gdevice = OS.GetDeviceList();
        if (gdevice == 0 || OS.GetNextDevice((int)gdevice) == 0) {
            return super.getClientArea();
        }
        Monitor[] monitors = this.getMonitors();
        Rectangle rect = monitors[0].getBounds();
        int i = 1;
        while (i < monitors.length) {
            rect = rect.union(monitors[i].getBounds());
            ++i;
        }
        return rect;
    }

    public Control getCursorControl() {
        Widget widget;
        Point where = new Point();
        OS.GetGlobalMouse((Point)where);
        int[] theWindow = new int[1];
        if (OS.FindWindow((Point)where, (int[])theWindow) != 3) {
            return null;
        }
        if (theWindow[0] == 0) {
            return null;
        }
        Rect rect = new Rect();
        OS.GetWindowBounds((int)theWindow[0], (short)33, (Rect)rect);
        CGPoint inPoint = new CGPoint();
        inPoint.x = where.h - rect.left;
        inPoint.y = where.v - rect.top;
        int[] theRoot = new int[1];
        OS.GetRootControl((int)theWindow[0], (int[])theRoot);
        int[] theControl = new int[1];
        OS.HIViewGetSubviewHit((int)theRoot[0], (CGPoint)inPoint, (boolean)true, (int[])theControl);
        while (theControl[0] != 0 && !OS.IsControlEnabled((int)theControl[0])) {
            OS.GetSuperControl((int)theControl[0], (int[])theControl);
        }
        if (theControl[0] != 0) {
            do {
                Control control;
                if ((widget = this.getWidget(theControl[0])) != null && widget instanceof Control && (control = (Control)widget).isEnabled()) {
                    return control.isEnabledModal() ? control : null;
                }
                OS.GetSuperControl((int)theControl[0], (int[])theControl);
            } while (theControl[0] != 0);
        }
        if ((widget = this.getWidget(theRoot[0])) != null && widget instanceof Control) {
            return (Control)widget;
        }
        return null;
    }

    public org.eclipse.swt.graphics.Point getCursorLocation() {
        this.checkDevice();
        Point pt = new Point();
        OS.GetGlobalMouse((Point)pt);
        return new org.eclipse.swt.graphics.Point(pt.h, pt.v);
    }

    public org.eclipse.swt.graphics.Point[] getCursorSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16)};
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        int theWindow = OS.GetUserFocusWindow();
        if (theWindow == 0) {
            return null;
        }
        return this.getFocusControl(theWindow);
    }

    Control getFocusControl(int window) {
        int[] theControl = new int[1];
        OS.GetKeyboardFocus((int)window, (int[])theControl);
        if (theControl[0] == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(theControl[0])) != null && widget instanceof Control) {
                Control control = (Control)widget;
                return control.isEnabled() ? control : null;
            }
            OS.GetSuperControl((int)theControl[0], (int[])theControl);
        } while (theControl[0] != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public org.eclipse.swt.graphics.Point[] getIconSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16), new org.eclipse.swt.graphics.Point(32, 32), new org.eclipse.swt.graphics.Point(64, 64), new org.eclipse.swt.graphics.Point(128, 128)};
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis();
    }

    Menu[] getMenus(Decorations shell) {
        if (this.menus == null) {
            return new Menu[0];
        }
        int count = 0;
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && menu.parent == shell) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Menu[] result = new Menu[count];
        int i2 = 0;
        while (i2 < this.menus.length) {
            Menu menu = this.menus[i2];
            if (menu != null && menu.parent == shell) {
                result[index++] = menu;
            }
            ++i2;
        }
        return result;
    }

    Menu getMenu(int id) {
        if (this.menus == null) {
            return null;
        }
        int index = id - 1001;
        if (index >= 0 && index < this.menus.length) {
            return this.menus[index];
        }
        return null;
    }

    Menu getMenuBar() {
        return this.menuBar;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        Monitor[] newMonitors;
        this.checkDevice();
        int count = 0;
        Monitor[] monitors = new Monitor[1];
        Rect rect = new Rect();
        GDevice device = new GDevice();
        int gdevice = OS.GetDeviceList();
        while (gdevice != 0) {
            if (count >= monitors.length) {
                newMonitors = new Monitor[monitors.length + 4];
                System.arraycopy(monitors, 0, newMonitors, 0, monitors.length);
                monitors = newMonitors;
            }
            Monitor monitor = new Monitor();
            monitor.handle = gdevice;
            int[] ptr = new int[1];
            OS.memcpy((int[])ptr, (int)gdevice, (int)4);
            OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
            monitor.x = device.left;
            monitor.y = device.top;
            monitor.width = device.right - device.left;
            monitor.height = device.bottom - device.top;
            OS.GetAvailableWindowPositioningBounds((int)gdevice, (Rect)rect);
            monitor.clientX = rect.left;
            monitor.clientY = rect.top;
            monitor.clientWidth = rect.right - rect.left;
            monitor.clientHeight = rect.bottom - rect.top;
            monitors[count++] = monitor;
            gdevice = OS.GetNextDevice((int)gdevice);
        }
        if (count < monitors.length) {
            newMonitors = new Monitor[count];
            System.arraycopy(monitors, 0, newMonitors, 0, count);
            monitors = newMonitors;
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        Monitor monitor = new Monitor();
        monitor.handle = gdevice;
        int[] ptr = new int[1];
        OS.memcpy((int[])ptr, (int)gdevice, (int)4);
        GDevice device = new GDevice();
        OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
        monitor.x = device.left;
        monitor.y = device.top;
        monitor.width = device.right - device.left;
        monitor.height = device.bottom - device.top;
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds((int)gdevice, (Rect)rect);
        monitor.clientX = rect.left;
        monitor.clientY = rect.top;
        monitor.clientWidth = rect.right - rect.left;
        monitor.clientHeight = rect.bottom - rect.top;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    if (index == result.length) {
                        Shell[] newResult = new Shell[index + 16];
                        System.arraycopy(result, 0, newResult, 0, index);
                        result = newResult;
                    }
                    result[index++] = (Shell)widget;
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        RGBColor rgb = new RGBColor();
        switch (id) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return Color.carbon_new(this, new float[]{1.0f, 1.0f, 0.88235295f, 1.0f});
            }
            case 30: {
                OS.GetThemeTextColor((short)23, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 31: {
                OS.GetThemeBrushAsColor((short)-5, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 32: {
                OS.GetThemeBrushAsColor((short)-3, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 33: {
                OS.GetThemeTextColor((short)24, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 34: {
                OS.GetThemeBrushAsColor((short)-4, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 35: {
                OS.GetThemeBrushAsColor((short)-4, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 17: {
                return Color.carbon_new(this, new float[]{0.2f, 0.2f, 0.2f, 1.0f});
            }
            case 18: {
                return Color.carbon_new(this, new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            }
            case 19: {
                return Color.carbon_new(this, new float[]{0.6f, 0.6f, 0.6f, 1.0f});
            }
            case 20: {
                return Color.carbon_new(this, new float[]{0.8f, 0.8f, 0.8f, 1.0f});
            }
            case 22: {
                OS.GetThemeBrushAsColor((short)29, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 21: {
                OS.GetThemeTextColor((short)12, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 23: {
                return super.getSystemColor(2);
            }
            case 24: {
                OS.GetThemeTextColor((short)22, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 25: {
                OS.GetThemeBrushAsColor((short)10, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 27: {
                OS.GetThemeTextColor((short)22, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            case 26: {
                OS.GetThemeBrushAsColor((short)-3, (short)((short)this.getDepth()), (boolean)true, (RGBColor)rgb);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        float red = (float)(rgb.red >> 8 & 0xFF) / 255.0f;
        float green = (float)(rgb.green >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb.blue >> 8 & 0xFF) / 255.0f;
        return Color.carbon_new(this, new float[]{red, green, blue, 1.0f});
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        int cgImage = 0;
        int imageData = 0;
        switch (id) {
            case 1: {
                int[] image;
                if (this.errorImage == 0 && (image = this.createImage(1937010544)) != null) {
                    this.errorImage = image[0];
                    this.errorImageData = image[1];
                }
                cgImage = this.errorImage;
                imageData = this.errorImageData;
                break;
            }
            case 2: 
            case 4: 
            case 16: {
                int[] image;
                if (this.infoImage == 0 && (image = this.createImage(1852798053)) != null) {
                    this.infoImage = image[0];
                    this.infoImageData = image[1];
                }
                cgImage = this.infoImage;
                imageData = this.infoImageData;
                break;
            }
            case 8: {
                int[] image;
                if (this.warningImage == 0 && (image = this.createImage(1667331444)) != null) {
                    this.warningImage = image[0];
                    this.warningImageData = image[1];
                }
                cgImage = this.warningImage;
                imageData = this.warningImageData;
            }
        }
        if (cgImage == 0) {
            return null;
        }
        return Image.carbon_new(this, 1, cgImage, imageData);
    }

    public Tray getSystemTray() {
        this.checkDevice();
        return null;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        this.property[0] = 0;
        OS.GetControlProperty((int)handle, (int)1937208368, (int)1937208368, (int)4, null, (int[])this.property);
        int index = this.property[0] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        Widget widget = this.getWidget(inControl);
        if (widget != null) {
            return widget.helpProc(inControl, inGlobalMouse, inRequest, outContentProvided, ioHelpContent);
        }
        return -9874;
    }

    int hitTestProc(int browser, int item, int property, int theRect, int mouseRect) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.hitTestProc(browser, item, property, theRect, mouseRect);
        }
        return 0;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeInsets();
        this.initializeWidgetTable();
        this.initializeFonts();
    }

    void initializeCallbacks() {
        this.actionCallback = new Callback(this, "actionProc", 2);
        this.actionProc = this.actionCallback.getAddress();
        if (this.actionProc == 0) {
            this.error(3);
        }
        this.appleEventCallback = new Callback(this, "appleEventProc", 3);
        this.appleEventProc = this.appleEventCallback.getAddress();
        if (this.appleEventProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.commandCallback = new Callback(this, "commandProc", 3);
        this.commandProc = this.commandCallback.getAddress();
        if (this.commandProc == 0) {
            this.error(3);
        }
        this.controlCallback = new Callback(this, "controlProc", 3);
        this.controlProc = this.controlCallback.getAddress();
        if (this.controlProc == 0) {
            this.error(3);
        }
        this.drawItemCallback = new Callback(this, "drawItemProc", 7);
        this.drawItemProc = this.drawItemCallback.getAddress();
        if (this.drawItemProc == 0) {
            this.error(3);
        }
        this.itemCompareCallback = new Callback(this, "itemCompareProc", 4);
        this.itemCompareProc = this.itemCompareCallback.getAddress();
        if (this.itemCompareProc == 0) {
            this.error(3);
        }
        this.itemDataCallback = new Callback(this, "itemDataProc", 5);
        this.itemDataProc = this.itemDataCallback.getAddress();
        if (this.itemDataProc == 0) {
            this.error(3);
        }
        this.itemNotificationCallback = new Callback(this, "itemNotificationProc", 3);
        this.itemNotificationProc = this.itemNotificationCallback.getAddress();
        if (this.itemNotificationProc == 0) {
            this.error(3);
        }
        this.helpCallback = new Callback(this, "helpProc", 5);
        this.helpProc = this.helpCallback.getAddress();
        if (this.helpProc == 0) {
            this.error(3);
        }
        this.hitTestCallback = new Callback(this, "hitTestProc", 5);
        this.hitTestProc = this.hitTestCallback.getAddress();
        if (this.hitTestProc == 0) {
            this.error(3);
        }
        this.keyboardCallback = new Callback(this, "keyboardProc", 3);
        this.keyboardProc = this.keyboardCallback.getAddress();
        if (this.keyboardProc == 0) {
            this.error(3);
        }
        this.menuCallback = new Callback(this, "menuProc", 3);
        this.menuProc = this.menuCallback.getAddress();
        if (this.menuProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.mouseCallback = new Callback(this, "mouseProc", 3);
        this.mouseProc = this.mouseCallback.getAddress();
        if (this.mouseProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.trackingCallback = new Callback(this, "trackingProc", 6);
        this.trackingProc = this.trackingCallback.getAddress();
        if (this.trackingProc == 0) {
            this.error(3);
        }
        this.windowCallback = new Callback(this, "windowProc", 3);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.colorCallback = new Callback(this, "colorProc", 4);
        this.colorProc = this.colorCallback.getAddress();
        if (this.colorProc == 0) {
            this.error(3);
        }
        this.textInputCallback = new Callback(this, "textInputProc", 3);
        this.textInputProc = this.textInputCallback.getAddress();
        if (this.textInputProc == 0) {
            this.error(3);
        }
        int[] mask1 = new int[]{1668113523, 1};
        int appTarget = OS.GetApplicationEventTarget();
        OS.InstallEventHandler((int)appTarget, (int)this.commandProc, (int)(mask1.length / 2), (int[])mask1, (int)0, null);
        int[] mask2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler((int)appTarget, (int)this.mouseProc, (int)(mask2.length / 2), (int[])mask2, (int)0, null);
        int[] mask3 = new int[]{1701867619, 1};
        OS.InstallEventHandler((int)appTarget, (int)this.appleEventProc, (int)(mask3.length / 2), (int[])mask3, (int)0, null);
        int[] mask4 = new int[]{1801812322, 1, 1801812322, 4, 1801812322, 2, 1801812322, 3};
        int focusTarget = OS.GetUserFocusEventTarget();
        OS.InstallEventHandler((int)focusTarget, (int)this.keyboardProc, (int)(mask4.length / 2), (int[])mask4, (int)0, null);
        int[] mask5 = new int[]{1952807028, 2};
        OS.InstallEventHandler((int)focusTarget, (int)this.textInputProc, (int)(mask5.length / 2), (int[])mask5, (int)0, null);
    }

    void initializeFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        this.noFocusRing = System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") != null;
    }

    void initializeInsets() {
        int[] outControl = new int[1];
        Rect rect = new Rect();
        rect.bottom = (short)200;
        rect.right = (short)200;
        OS.CreatePushButtonControl((int)0, (Rect)rect, (int)0, (int[])outControl);
        this.buttonInset = this.computeInset(outControl[0]);
        OS.DisposeControl((int)outControl[0]);
        OS.CreateTabsControl((int)0, (Rect)rect, (short)0, (short)0, (short)0, (int)0, (int[])outControl);
        this.tabFolderNorthInset = this.computeInset(outControl[0]);
        OS.DisposeControl((int)outControl[0]);
        OS.CreateTabsControl((int)0, (Rect)rect, (short)0, (short)1, (short)0, (int)0, (int[])outControl);
        this.tabFolderSouthInset = this.computeInset(outControl[0]);
        OS.DisposeControl((int)outControl[0]);
        OS.CreateEditUnicodeTextControl((int)0, (Rect)rect, (int)0, (boolean)false, null, (int[])outControl);
        this.spinnerInset = this.computeInset(outControl[0]);
        OS.DisposeControl((int)outControl[0]);
        CGRect cgRect = new CGRect();
        cgRect.height = 200.0f;
        cgRect.width = 200.0f;
        int inAttributes = 9;
        OS.HIComboBoxCreate((CGRect)cgRect, (int)0, null, (int)0, (int)inAttributes, (int[])outControl);
        this.comboInset = this.computeInset(outControl[0]);
        this.comboInset.bottom = this.comboInset.top;
        OS.DisposeControl((int)outControl[0]);
    }

    void initializeWidgetTable() {
        this.property = new int[1];
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    public int internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        int window = this.createOverlayWindow();
        OS.ShowWindow((int)window);
        int port = OS.GetWindowPort((int)window);
        int[] buffer = new int[1];
        OS.CreateCGContextForPort((int)port, (int[])buffer);
        int context = buffer[0];
        if (context == 0) {
            SWT.error(2);
        }
        Rect portRect = new Rect();
        OS.GetPortBounds((int)port, (Rect)portRect);
        OS.CGContextScaleCTM((int)context, (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)context, (float)0.0f, (float)(portRect.top - portRect.bottom));
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.window = window;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (data != null) {
            int window = data.window;
            OS.DisposeWindow((int)window);
            data.window = 0;
        }
        OS.CGContextSynchronize((int)context);
        OS.CGContextRelease((int)context);
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemCompareProc(browser, itemOne, itemTwo, sortProperty);
        }
        return 0;
    }

    int itemDataProc(int browser, int item, int property, int itemData, int setValue) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemDataProc(browser, item, property, itemData, setValue);
        }
        return 0;
    }

    int itemNotificationProc(int browser, int item, int message) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemNotificationProc(browser, item, message);
        }
        return 0;
    }

    int keyboardProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget == null) {
            int theWindow = OS.GetUserFocusWindow();
            if (theWindow == 0) {
                return -9874;
            }
            int[] theControl = new int[1];
            OS.GetKeyboardFocus((int)theWindow, (int[])theControl);
            widget = this.getWidget(theControl[0]);
        }
        if (widget != null) {
            return widget.keyboardProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        int type = event.type;
        switch (type) {
            case 1: 
            case 2: {
                short regionCode;
                int vKey = Display.untranslateKey(event.keyCode);
                if (vKey != 0) {
                    return OS.CGPostKeyboardEvent((int)0, (int)vKey, (type == 1 ? 1 : 0) != 0) == 0;
                }
                vKey = -1;
                int kchrPtr = OS.GetScriptManagerVariable((short)38);
                int key = -1;
                int[] state = new int[1];
                int[] encoding = new int[1];
                short keyScript = (short)OS.GetScriptManagerVariable((short)22);
                if (OS.UpgradeScriptInfoToTextEncoding((short)keyScript, (short)-128, (short)(regionCode = (short)OS.GetScriptManagerVariable((short)40)), null, (int[])encoding) == -50 && OS.UpgradeScriptInfoToTextEncoding((short)keyScript, (short)-128, (short)-128, null, (int[])encoding) == -50) {
                    encoding[0] = 0;
                }
                int[] encodingInfo = new int[1];
                OS.CreateUnicodeToTextInfoByEncoding((int)encoding[0], (int[])encodingInfo);
                if (encodingInfo[0] != 0) {
                    char[] input = new char[]{event.character};
                    byte[] buffer = new byte[2];
                    OS.ConvertFromUnicodeToPString((int)encodingInfo[0], (int)2, (char[])input, (byte[])buffer);
                    OS.DisposeUnicodeToTextInfo((int[])encodingInfo);
                    key = buffer[1] & 0x7F;
                }
                if (key == -1) {
                    return false;
                }
                int i = 0;
                while (i <= 127) {
                    int result1 = OS.KeyTranslate((int)kchrPtr, (short)((short)(i | 0x200)), (int[])state);
                    int result2 = OS.KeyTranslate((int)kchrPtr, (short)((short)i), (int[])state);
                    if ((result1 & 0x7F) == key || (result2 & 0x7F) == key) {
                        vKey = i;
                        break;
                    }
                    ++i;
                }
                if (vKey == -1) {
                    return false;
                }
                return OS.CGPostKeyboardEvent((int)key, (int)vKey, (type == 1 ? 1 : 0) != 0) == 0;
            }
            case 3: 
            case 4: 
            case 5: {
                CGPoint mouseCursorPosition = new CGPoint();
                int chord = OS.GetCurrentEventButtonState();
                if (type == 5) {
                    mouseCursorPosition.x = event.x;
                    mouseCursorPosition.y = event.y;
                    return OS.CGPostMouseEvent((CGPoint)mouseCursorPosition, (boolean)true, (int)3, ((chord & 1) != 0 ? 1 : 0) != 0, ((chord & 2) != 0 ? 1 : 0) != 0, ((chord & 4) != 0 ? 1 : 0) != 0) == 0;
                }
                int button = event.button;
                if (button < 1 || button > 3) {
                    return false;
                }
                boolean button1 = false;
                boolean button2 = false;
                boolean button3 = false;
                switch (button) {
                    case 1: {
                        button1 = type == 3;
                        button2 = (chord & 4) != 0;
                        button3 = (chord & 2) != 0;
                        break;
                    }
                    case 2: {
                        button1 = (chord & 1) != 0;
                        button2 = type == 3;
                        button3 = (chord & 2) != 0;
                        break;
                    }
                    case 3: {
                        button1 = (chord & 1) != 0;
                        button2 = (chord & 4) != 0;
                        button3 = type == 3;
                    }
                }
                Point pt = new Point();
                OS.GetGlobalMouse((Point)pt);
                mouseCursorPosition.x = pt.h;
                mouseCursorPosition.y = pt.v;
                return OS.CGPostMouseEvent((CGPoint)mouseCursorPosition, (boolean)true, (int)3, (boolean)button1, (boolean)button3, (boolean)button2) == 0;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public org.eclipse.swt.graphics.Point map(Control from, Control to, org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point map(Control from, Control to, int x, int y) {
        int window;
        Rect rect;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(x, y);
        if (from != null) {
            rect = new Rect();
            OS.GetControlBounds((int)from.handle, (Rect)rect);
            point.x += rect.left;
            point.y += rect.top;
            window = OS.GetControlOwner((int)from.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            point.x += rect.left;
            point.y += rect.top;
        }
        if (to != null) {
            rect = new Rect();
            OS.GetControlBounds((int)to.handle, (Rect)rect);
            point.x -= rect.left;
            point.y -= rect.top;
            window = OS.GetControlOwner((int)to.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            point.x -= rect.left;
            point.y -= rect.top;
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        int window;
        Rect rect;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (from != null) {
            rect = new Rect();
            OS.GetControlBounds((int)from.handle, (Rect)rect);
            rectangle.x += rect.left;
            rectangle.y += rect.top;
            window = OS.GetControlOwner((int)from.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            rectangle.x += rect.left;
            rectangle.y += rect.top;
        }
        if (to != null) {
            rect = new Rect();
            OS.GetControlBounds((int)to.handle, (Rect)rect);
            rectangle.x -= rect.left;
            rectangle.y -= rect.top;
            window = OS.GetControlOwner((int)to.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            rectangle.x -= rect.left;
            rectangle.y -= rect.top;
        }
        return rectangle;
    }

    int menuProc(int nextHandler, int theEvent, int userData) {
        if (userData != 0) {
            Widget widget = this.getWidget(userData);
            if (widget != null) {
                return widget.menuProc(nextHandler, theEvent, userData);
            }
        } else {
            int[] theMenu = new int[1];
            OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1835363957, null, (int)4, null, (int[])theMenu);
            short menuID = OS.GetMenuID((int)theMenu[0]);
            Menu menu = this.getMenu(menuID);
            if (menu != null) {
                return menu.menuProc(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int mouseProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind((int)theEvent);
        if (this.mouseUpControl != null && eventKind == 2) {
            if (!this.mouseUpControl.isDisposed()) {
                this.mouseUpControl.mouseProc(nextHandler, theEvent, userData);
                this.mouseUpControl = null;
                return 0;
            }
            this.mouseUpControl = null;
        }
        int sizeof = 4;
        Point where = new Point();
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)where);
        int[] theWindow = new int[1];
        short part = OS.FindWindow((Point)where, (int[])theWindow);
        switch (part) {
            case 1: {
                if (eventKind != 1) break;
                this.clearMenuFlags();
                if (this.menuBar == null || this.menuBar.isEnabled()) {
                    OS.MenuSelect((Point)where);
                }
                this.clearMenuFlags();
                return 0;
            }
            case 3: {
                Rect windowRect = new Rect();
                OS.GetWindowBounds((int)theWindow[0], (short)33, (Rect)windowRect);
                CGPoint inPoint = new CGPoint();
                inPoint.x = where.h - windowRect.left;
                inPoint.y = where.v - windowRect.top;
                int[] theRoot = new int[1];
                OS.GetRootControl((int)theWindow[0], (int[])theRoot);
                int[] theControl = new int[1];
                OS.HIViewGetSubviewHit((int)theRoot[0], (CGPoint)inPoint, (boolean)true, (int[])theControl);
                while (theControl[0] != 0 && !OS.IsControlEnabled((int)theControl[0])) {
                    OS.GetSuperControl((int)theControl[0], (int[])theControl);
                }
                Widget widget = null;
                boolean consume = false;
                if (theControl[0] == 0) {
                    theControl[0] = theRoot[0];
                }
                do {
                    if ((widget = this.getWidget(theControl[0])) != null) {
                        if (widget.isEnabled()) break;
                        consume = true;
                    }
                    OS.GetSuperControl((int)theControl[0], (int[])theControl);
                } while (theControl[0] != 0);
                if (theControl[0] == 0) {
                    widget = this.getWidget(theRoot[0]);
                }
                if (widget == null) break;
                int result = userData != 0 ? widget.mouseProc(nextHandler, theEvent, userData) : -9874;
                return consume ? 0 : result;
            }
        }
        switch (eventKind) {
            case 5: 
            case 6: {
                OS.InitCursor();
            }
        }
        return -9874;
    }

    int mouseHoverProc(int id, int handle) {
        if (this.currentControl == null) {
            return 0;
        }
        if (!this.currentControl.isDisposed()) {
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            org.eclipse.swt.graphics.Point pt = this.currentControl.toControl(this.getCursorLocation());
            this.currentControl.sendMouseEvent(32, (short)0, chord, (short)pt.x, (short)pt.y, modifiers, true);
        }
        return 0;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean events = this.runTimers();
        events |= this.runEnterExit();
        events |= this.runPopups();
        events |= this.runGrabs();
        int[] outEvent = new int[1];
        int status = OS.ReceiveNextEvent((int)0, null, (double)0.0, (boolean)true, (int[])outEvent);
        if (status == 0) {
            events = true;
            int eventClass = OS.GetEventClass((int)outEvent[0]);
            int eventKind = OS.GetEventKind((int)outEvent[0]);
            OS.SendEventToEventTarget((int)outEvent[0], (int)OS.GetEventDispatcherTarget());
            OS.ReleaseEvent((int)outEvent[0]);
            if (this.focusCombo != null && !this.focusCombo.isDisposed()) {
                this.focusCombo.checkSelection();
            }
            if (eventClass == 0 && eventKind == 0) {
                this.runAsyncMessages(false);
            }
        }
        if (events) {
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages(false);
    }

    static synchronized void register(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = display;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = display;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.actionCallback.dispose();
        this.appleEventCallback.dispose();
        this.caretCallback.dispose();
        this.commandCallback.dispose();
        this.controlCallback.dispose();
        this.drawItemCallback.dispose();
        this.itemCompareCallback.dispose();
        this.itemDataCallback.dispose();
        this.itemNotificationCallback.dispose();
        this.helpCallback.dispose();
        this.hitTestCallback.dispose();
        this.keyboardCallback.dispose();
        this.menuCallback.dispose();
        this.mouseHoverCallback.dispose();
        this.mouseCallback.dispose();
        this.trackingCallback.dispose();
        this.windowCallback.dispose();
        this.colorCallback.dispose();
        this.textInputCallback.dispose();
        this.commandCallback = null;
        this.caretCallback = null;
        this.appleEventCallback = null;
        this.actionCallback = null;
        this.itemNotificationCallback = null;
        this.itemDataCallback = null;
        this.drawItemCallback = null;
        this.controlCallback = null;
        this.itemCompareCallback = null;
        this.menuCallback = null;
        this.keyboardCallback = null;
        this.hitTestCallback = null;
        this.helpCallback = null;
        this.colorCallback = null;
        this.windowCallback = null;
        this.trackingCallback = null;
        this.mouseCallback = null;
        this.mouseHoverCallback = null;
        this.textInputCallback = null;
        this.commandProc = 0;
        this.caretProc = 0;
        this.appleEventProc = 0;
        this.actionProc = 0;
        this.itemCompareProc = 0;
        this.itemNotificationProc = 0;
        this.itemDataProc = 0;
        this.drawItemProc = 0;
        this.controlProc = 0;
        this.menuProc = 0;
        this.keyboardProc = 0;
        this.hitTestProc = 0;
        this.helpProc = 0;
        this.colorProc = 0;
        this.windowProc = 0;
        this.trackingProc = 0;
        this.mouseProc = 0;
        this.mouseHoverProc = 0;
        this.textInputProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.timerProc = 0;
        this.focusCombo = null;
        this.focusControl = null;
        this.mouseUpControl = null;
        this.currentControl = null;
        this.helpControl = null;
        this.grabControl = null;
        if (this.helpString != 0) {
            OS.CFRelease((int)this.helpString);
        }
        this.helpString = 0;
        this.popups = null;
        this.menus = null;
        this.menuBar = null;
        if (this.errorImage != 0) {
            OS.CGImageRelease((int)this.errorImage);
        }
        if (this.infoImage != 0) {
            OS.CGImageRelease((int)this.infoImage);
        }
        if (this.warningImage != 0) {
            OS.CGImageRelease((int)this.warningImage);
        }
        if (this.errorImageData != 0) {
            OS.DisposePtr((int)this.errorImageData);
        }
        if (this.infoImageData != 0) {
            OS.DisposePtr((int)this.infoImageData);
        }
        if (this.warningImageData != 0) {
            OS.DisposePtr((int)this.warningImageData);
        }
        this.warningImage = 0;
        this.infoImage = 0;
        this.errorImage = 0;
        this.warningImageData = 0;
        this.infoImageData = 0;
        this.errorImageData = 0;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        this.menus[menu.id - 1001] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        Widget widget = null;
        this.property[0] = 0;
        OS.GetControlProperty((int)handle, (int)1937208368, (int)1937208368, (int)4, null, (int[])this.property);
        int index = this.property[0] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.RemoveControlProperty((int)handle, (int)1937208368, (int)1937208368);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runEnterExit() {
        Rect rect;
        boolean eventSent = false;
        Widget control = null;
        int[] theControl = new int[1];
        Point where = new Point();
        OS.GetGlobalMouse((Point)where);
        int[] theWindow = new int[1];
        if (OS.FindWindow((Point)where, (int[])theWindow) == 3 && theWindow[0] != 0) {
            Widget widget;
            rect = new Rect();
            OS.GetWindowBounds((int)theWindow[0], (short)33, (Rect)rect);
            CGPoint inPoint = new CGPoint();
            inPoint.x = where.h - rect.left;
            inPoint.y = where.v - rect.top;
            int[] theRoot = new int[1];
            OS.GetRootControl((int)theWindow[0], (int[])theRoot);
            OS.HIViewGetSubviewHit((int)theRoot[0], (CGPoint)inPoint, (boolean)true, (int[])theControl);
            while (theControl[0] != 0 && !OS.IsControlEnabled((int)theControl[0])) {
                OS.GetSuperControl((int)theControl[0], (int[])theControl);
            }
            if (theControl[0] != 0) {
                do {
                    if ((widget = this.getWidget(theControl[0])) != null) {
                        Control cursorControl;
                        if (widget.isTrimHandle(theControl[0])) break;
                        if (widget instanceof Control && (cursorControl = (Control)widget).isEnabled()) {
                            if (!cursorControl.isEnabledModal()) break;
                            control = cursorControl;
                            break;
                        }
                    }
                    OS.GetSuperControl((int)theControl[0], (int[])theControl);
                } while (theControl[0] != 0);
            }
            if (control == null) {
                theControl[0] = theRoot[0];
                widget = this.getWidget(theControl[0]);
                if (widget != null && widget instanceof Control) {
                    control = (Control)widget;
                    theControl[0] = ((Control)control).handle;
                }
            }
        }
        if (control != this.currentControl) {
            org.eclipse.swt.graphics.Point pt;
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                eventSent = true;
                int chord = OS.GetCurrentEventButtonState();
                int modifiers = OS.GetCurrentEventKeyModifiers();
                pt = this.currentControl.toControl(where.h, where.v);
                this.currentControl.sendMouseEvent(7, (short)0, chord, (short)pt.x, (short)pt.y, modifiers, true);
                if (this.mouseHoverID != 0) {
                    OS.RemoveEventLoopTimer((int)this.mouseHoverID);
                }
                this.mouseHoverID = 0;
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            if ((this.currentControl = control) != null) {
                eventSent = true;
                int chord = OS.GetCurrentEventButtonState();
                int modifiers = OS.GetCurrentEventKeyModifiers();
                pt = this.currentControl.toControl(where.h, where.v);
                this.currentControl.sendMouseEvent(6, (short)0, chord, (short)pt.x, (short)pt.y, modifiers, true);
                if (this.mouseHoverID != 0) {
                    OS.RemoveEventLoopTimer((int)this.mouseHoverID);
                }
                int[] id = new int[1];
                int[] outDelay = new int[1];
                OS.HMGetTagDelay((int[])outDelay);
                int eventLoop = OS.GetCurrentEventLoop();
                OS.InstallEventLoopTimer((int)eventLoop, (double)((double)outDelay[0] / 1000.0), (double)0.0, (int)this.mouseHoverProc, (int)0, (int[])id);
                this.mouseHoverID = id[0];
            }
        } else if (control != null && this.mouseHoverID != 0) {
            int[] outDelay = new int[1];
            OS.HMGetTagDelay((int[])outDelay);
            OS.SetEventLoopTimerNextFireTime((int)this.mouseHoverID, (double)((double)outDelay[0] / 1000.0));
        }
        if (!OS.StillDown() && theWindow[0] != 0 && theControl[0] != 0) {
            rect = new Rect();
            OS.GetWindowBounds((int)theWindow[0], (short)33, (Rect)rect);
            where.h = (short)(where.h - rect.left);
            where.v = (short)(where.v - rect.top);
            int modifiers = OS.GetCurrentEventKeyModifiers();
            boolean[] cursorWasSet = new boolean[1];
            OS.HandleControlSetCursor((int)theControl[0], (Point)where, (int)((short)modifiers), (boolean[])cursorWasSet);
            if (!cursorWasSet[0]) {
                OS.SetThemeCursor((int)0);
            }
        }
        return eventSent;
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runEventLoopTimers() {
        this.allowTimers = false;
        boolean result = OS.ReceiveNextEvent((int)0, null, (double)0.0, (boolean)false, null) == 0;
        this.allowTimers = true;
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runGrabs() {
        if (this.grabControl == null) return false;
        if (this.grabbing) {
            return false;
        }
        if (!OS.StillDown()) {
            this.grabControl = null;
            return false;
        }
        Rect rect = new Rect();
        int[] outModifiers = new int[1];
        short[] outResult = new short[1];
        Point outPt = new Point();
        this.grabbing = true;
        this.mouseUpControl = null;
        try {
            while (this.grabControl != null && !this.grabControl.isDisposed() && outResult[0] != 2) {
                this.grabControl.getShell().update(true);
                this.lastModifiers = OS.GetCurrentEventKeyModifiers();
                int oldState = OS.GetCurrentEventButtonState();
                int handle = this.grabControl.handle;
                int window = OS.GetControlOwner((int)handle);
                int port = OS.GetWindowPort((int)window);
                OS.TrackMouseLocationWithOptions((int)port, (int)1, (double)0.05, (Point)outPt, (int[])outModifiers, (short[])outResult);
                int type = 0;
                int button = 0;
                switch (outResult[0]) {
                    case 8: {
                        this.runAsyncMessages(false);
                        break;
                    }
                    case 1: {
                        type = 3;
                        int newState = OS.GetCurrentEventButtonState();
                        if ((oldState & 1) == 0 && (newState & 1) != 0) {
                            button = 1;
                        }
                        if ((oldState & 2) == 0 && (newState & 2) != 0) {
                            button = 2;
                        }
                        if ((oldState & 4) != 0 || (newState & 4) == 0) break;
                        button = 3;
                        break;
                    }
                    case 2: {
                        type = 4;
                        int newState = OS.GetCurrentEventButtonState();
                        if ((oldState & 1) != 0 && (newState & 1) == 0) {
                            button = 1;
                        }
                        if ((oldState & 2) != 0 && (newState & 2) == 0) {
                            button = 2;
                        }
                        if ((oldState & 4) == 0 || (newState & 4) != 0) break;
                        button = 3;
                        break;
                    }
                    case 5: {
                        type = 5;
                        this.dragDetect(this.grabControl);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 9: {
                        type = 5;
                        break;
                    }
                }
                boolean events = type != 0;
                events |= this.runEnterExit();
                if (type != 0) {
                    OS.GetControlBounds((int)handle, (Rect)rect);
                    int x = outPt.h - rect.left;
                    int y = outPt.v - rect.top;
                    int chord = OS.GetCurrentEventButtonState();
                    if (this.grabControl != null && !this.grabControl.isDisposed()) {
                        if (type == 4) {
                            this.mouseUpControl = this.grabControl;
                        } else {
                            this.grabControl.sendMouseEvent(type, (short)button, chord, (short)x, (short)y, outModifiers[0], true);
                        }
                    }
                }
                if (!events) continue;
                this.runDeferredEvents();
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.grabbing = false;
            this.grabControl = null;
            throw throwable;
        }
        {
            Object var15_17 = null;
            this.grabbing = false;
            this.grabControl = null;
            return true;
        }
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        this.grabControl = null;
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.clearMenuFlags();
            this.runDeferredEvents();
            menu._setVisible(true);
            this.clearMenuFlags();
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.timerList.length) {
            if (this.timerIds[i] == -1) {
                Runnable runnable = this.timerList[i];
                this.timerList[i] = null;
                this.timerIds[i] = 0;
                if (runnable != null) {
                    result = true;
                    runnable.run();
                }
            }
            ++i;
        }
        return result;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.RemoveEventLoopTimer((int)this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int blinkRate = this.currentCaret.blinkRate;
            int[] timerId = new int[1];
            double time = (double)blinkRate / 1000.0;
            int eventLoop = OS.GetCurrentEventLoop();
            OS.InstallEventLoopTimer((int)eventLoop, (double)time, (double)time, (int)this.caretProc, (int)0, (int[])timerId);
            this.caretID = timerId[0];
        }
    }

    void setCursor(int cursor) {
        switch (cursor) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                OS.SetThemeCursor((int)cursor);
                break;
            }
            default: {
                OS.SetCursor((int)cursor);
            }
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        CGPoint pt = new CGPoint();
        pt.x = x;
        pt.y = y;
        OS.CGWarpMouseCursorPosition((CGPoint)pt);
    }

    public void setCursorLocation(org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    void setMenuBar(Menu menu) {
        if (menu == this.menuBar) {
            return;
        }
        int theMenu = 0;
        if (menu == null) {
            int[] outMenuRef = new int[1];
            OS.CreateNewMenu((short)1000, (int)0, (int[])outMenuRef);
            theMenu = outMenuRef[0];
        } else {
            theMenu = menu.handle;
        }
        OS.SetRootMenu((int)theMenu);
        if (menu == null) {
            OS.ClearMenuBar();
            OS.DeleteMenu((short)OS.GetMenuID((int)theMenu));
            OS.DisposeMenu((int)theMenu);
        }
        this.menuBar = menu;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.allowTimers = false;
        boolean result = OS.ReceiveNextEvent((int)0, null, (double)-1.0, (boolean)false, null) == 0;
        this.allowTimers = true;
        return result;
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    int textInputProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget == null) {
            int theWindow = OS.GetUserFocusWindow();
            if (theWindow == 0) {
                return -9874;
            }
            int[] theControl = new int[1];
            OS.GetKeyboardFocus((int)theWindow, (int[])theControl);
            widget = this.getWidget(theControl[0]);
        }
        if (widget != null) {
            return widget.textInputProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            int timerId = this.timerIds[index];
            if (milliseconds < 0) {
                OS.RemoveEventLoopTimer((int)timerId);
                this.timerList[index] = null;
                this.timerIds[index] = 0;
            } else {
                OS.SetEventLoopTimerNextFireTime((int)timerId, (double)((double)milliseconds / 1000.0));
            }
            return;
        }
        if (milliseconds < 0) {
            return;
        }
        index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == null) break;
            ++index;
        }
        if (index == this.timerList.length) {
            Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
            this.timerList = newTimerList;
            int[] newTimerIds = new int[this.timerIds.length + 4];
            System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
            this.timerIds = newTimerIds;
        }
        int[] timerId = new int[1];
        int eventLoop = OS.GetCurrentEventLoop();
        OS.InstallEventLoopTimer((int)eventLoop, (double)((double)milliseconds / 1000.0), (double)0.0, (int)this.timerProc, (int)index, (int[])timerId);
        if (timerId[0] != 0) {
            this.timerIds[index] = timerId[0];
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int id, int index) {
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            if (this.allowTimers) {
                Runnable runnable = this.timerList[index];
                this.timerList[index] = null;
                this.timerIds[index] = 0;
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                this.timerIds[index] = -1;
                this.wakeThread();
            }
        }
        return 0;
    }

    int trackingProc(int browser, int itemID, int property, int theRect, int startPt, int modifiers) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.trackingProc(browser, itemID, property, theRect, startPt, modifiers);
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++i;
        }
    }

    void updateQuitMenu() {
        boolean enabled = true;
        Shell[] shells = this.getShells();
        int mask = 229376;
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if ((shell.style & mask) != 0 && shell.isVisible()) {
                enabled = false;
                break;
            }
            ++i;
        }
        if (enabled) {
            OS.EnableMenuCommand((int)0, (int)1903520116);
        } else {
            OS.DisableMenuCommand((int)0, (int)1903520116);
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        int[] wakeEvent = new int[1];
        OS.CreateEvent((int)0, (int)0, (int)0, (double)0.0, (int)1, (int[])wakeEvent);
        OS.PostEventToQueue((int)this.queue, (int)wakeEvent[0], (short)1);
        if (wakeEvent[0] != 0) {
            OS.ReleaseEvent((int)wakeEvent[0]);
        }
    }

    int windowProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget == null) {
            int[] theWindow = new int[1];
            OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)2003398244, null, (int)4, null, (int[])theWindow);
            int[] theRoot = new int[1];
            OS.GetRootControl((int)theWindow[0], (int[])theRoot);
            widget = this.getWidget(theRoot[0]);
        }
        if (widget != null) {
            return widget.windowProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }
}

