/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int textHandle;
    int buttonHandle;
    int textVisibleRgn;
    int buttonVisibleRgn;
    int increment = 1;
    int pageIncrement = 10;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    int actionProc(int theControl, int partCode) {
        int value = this.getSelectionText();
        switch (partCode) {
            case 20: {
                value += this.increment;
                break;
            }
            case 21: {
                value -= this.increment;
            }
        }
        int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
        int min = OS.GetControl32BitMinimum((int)this.buttonHandle);
        if (value > max) {
            value = min;
        }
        if (value < min) {
            value = max;
        }
        this.setSelection(value, true);
        return 0;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int[] currentPort = new int[1];
        short themeFont = (short)this.defaultThemeFont();
        if (this.font != null) {
            themeFont = 200;
            OS.GetPort((int[])currentPort);
            OS.SetPortWindowPort((int)OS.GetControlOwner((int)this.textHandle));
            OS.TextFont((short)this.font.id);
            OS.TextFace((short)this.font.style);
            OS.TextSize((short)this.font.size);
        }
        FontInfo info = new FontInfo();
        OS.GetFontInfo((FontInfo)info);
        height = info.ascent + info.descent;
        int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
        String string = String.valueOf(max);
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        Point ioBounds = new Point();
        if (ptr != 0) {
            OS.GetThemeTextDimensions((int)ptr, (short)themeFont, (int)1, (boolean)false, (Point)ioBounds, null);
            width = Math.max(width, ioBounds.h);
            height = Math.max(height, ioBounds.v);
            OS.CFRelease((int)ptr);
        }
        if (this.font != null) {
            OS.SetPort((int)currentPort[0]);
        }
        int[] metric = new int[1];
        OS.GetThemeMetric((int)27, (int[])metric);
        height = Math.max(height, metric[0]);
        OS.GetThemeMetric((int)4, (int[])metric);
        width += metric[0] * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rect inset = this.inset();
        width += inset.left + inset.right;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)28, (int[])outMetric);
        return new Rectangle(x, y, width += outMetric[0], height += inset.top + inset.bottom);
    }

    public void copy() {
        this.checkWidget();
        short[] selection = new short[2];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1936026725, (int)4, (short[])selection, null) != 0) {
            return;
        }
        if (selection[0] == selection[1]) {
            return;
        }
        int[] ptr = new int[1];
        int[] actualSize = new int[1];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize) != 0) {
            return;
        }
        CFRange range = new CFRange();
        range.location = selection[0];
        range.length = selection[1] - selection[0];
        char[] buffer = new char[range.length];
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        this.copy(buffer);
    }

    void copy(char[] buffer) {
        if (buffer.length == 0) {
            return;
        }
        OS.ClearCurrentScrap();
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        OS.PutScrapFlavor((int)scrap[0], (int)1970567284, (int)0, (int)(buffer.length * 2), (char[])buffer);
    }

    void createHandle() {
        int window = OS.GetControlOwner((int)this.parent.handle);
        int actionProc = this.display.actionProc;
        int features = 262;
        int[] outControl = new int[1];
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        OS.CreateLittleArrowsControl((int)window, null, (int)0, (int)0, (int)100, (int)1, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.buttonHandle = outControl[0];
        OS.SetControlAction((int)this.buttonHandle, (int)actionProc);
        OS.CreateEditUnicodeTextControl((int)window, null, (int)0, (boolean)false, null, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.textHandle = outControl[0];
        OS.SetControlData((int)this.textHandle, (int)0, (int)1936157795, (int)1, (byte[])new byte[]{1});
        if ((this.style & 8) != 0) {
            OS.SetControlData((int)this.textHandle, (int)0, (int)1819239275, (int)1, (byte[])new byte[]{1});
        }
        this.setSelection(0, false);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        short[] selection = new short[2];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1936026725, (int)4, (short[])selection, null) != 0) {
            return;
        }
        if (selection[0] == selection[1]) {
            return;
        }
        char[] buffer = this.setText("", selection[0], selection[1], true);
        if (buffer != null) {
            this.copy(buffer);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.textHandle);
        this.display.removeWidget(this.buttonHandle);
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    int focusHandle() {
        return this.textHandle;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum((int)this.buttonHandle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum((int)this.buttonHandle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue((int)this.buttonHandle);
    }

    int getSelectionText() {
        int[] ptr = new int[1];
        int[] actualSize = new int[1];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize) == 0) {
            CFRange range = new CFRange();
            range.location = 0;
            range.length = OS.CFStringGetLength((int)ptr[0]);
            char[] buffer = new char[range.length];
            OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
            OS.CFRelease((int)ptr[0]);
            String string = new String(buffer);
            try {
                int value = Integer.parseInt(string);
                int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
                int min = OS.GetControl32BitMinimum((int)this.buttonHandle);
                if (min <= value && value <= max) {
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return OS.GetControl32BitValue((int)this.buttonHandle);
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (control == this.textHandle) {
            if (!clipChildren) {
                return super.getVisibleRegion(control, clipChildren);
            }
            if (this.textVisibleRgn == 0) {
                this.textVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.textVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn((int)this.textVisibleRgn, (int)result);
            return result;
        }
        if (control == this.buttonHandle) {
            if (!clipChildren) {
                return super.getVisibleRegion(control, clipChildren);
            }
            if (this.buttonVisibleRgn == 0) {
                this.buttonVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(control, this.buttonVisibleRgn, clipChildren);
            }
            int result = OS.NewRgn();
            OS.CopyRgn((int)this.buttonVisibleRgn, (int)result);
            return result;
        }
        return super.getVisibleRegion(control, clipChildren);
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask = new int[]{1668183148, 4, 1668183148, 7};
        int controlTarget = OS.GetControlEventTarget((int)this.textHandle);
        OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
        controlTarget = OS.GetControlEventTarget((int)this.buttonHandle);
        OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
    }

    Rect inset() {
        return this.display.spinnerInset;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        short[] part = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
        if (part[0] == 0) {
            int value = this.getSelectionText();
            this.setSelection(value, true);
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int value;
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        int delta = 0;
        switch (keyCode[0]) {
            case 36: {
                value = this.getSelectionText();
                this.setSelection(value, true);
                this.postEvent(14);
                break;
            }
            case 116: {
                delta = this.pageIncrement;
                break;
            }
            case 121: {
                delta = -this.pageIncrement;
                break;
            }
            case 125: {
                delta = -this.increment;
                break;
            }
            case 126: {
                delta = this.increment;
            }
        }
        if (delta != 0) {
            value = this.getSelectionText() + delta;
            int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
            int min = OS.GetControl32BitMinimum((int)this.buttonHandle);
            if (value > max) {
                value = min;
            }
            if (value < min) {
                value = max;
            }
            this.setSelection(value, true);
            return 0;
        }
        return result;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize((int)scrap[0], (int)1970567284, (int[])size) != 0 || size[0] == 0) {
            return;
        }
        char[] buffer = new char[size[0]];
        if (OS.GetScrapFlavorData((int)scrap[0], (int)1970567284, (int[])size, (char[])buffer) != 0) {
            return;
        }
        short[] selection = new short[2];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1936026725, (int)4, (short[])selection, null) != 0) {
            return;
        }
        this.setText(new String(buffer), selection[0], selection[1], true);
    }

    public void redraw() {
        this.checkWidget();
        super.redraw();
        this.redrawWidget(this.textHandle, false);
        this.redrawWidget(this.buttonHandle, false);
    }

    void register() {
        super.register();
        this.display.addWidget(this.textHandle, this);
        this.display.addWidget(this.buttonHandle, this);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.textVisibleRgn != 0) {
            OS.DisposeRgn((int)this.textVisibleRgn);
            this.textVisibleRgn = 0;
        }
        if (this.buttonVisibleRgn != 0) {
            OS.DisposeRgn((int)this.buttonVisibleRgn);
            this.buttonVisibleRgn = 0;
        }
        super.resetVisibleRegion(control);
    }

    void resizeClientArea() {
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)28, (int[])outMetric);
        int buttonWidth = outMetric[0];
        OS.GetThemeMetric((int)27, (int[])outMetric);
        int buttonHeight = outMetric[0];
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        Rect inset = this.inset();
        int width = Math.max(0, rect.right - rect.left - inset.left - inset.right - buttonWidth);
        int height = Math.max(0, rect.bottom - rect.top - inset.top - inset.bottom);
        buttonHeight = Math.min(buttonHeight, rect.bottom - rect.top);
        this.setBounds(this.textHandle, inset.left, inset.top, width, height, true, true, false);
        this.setBounds(this.buttonHandle, inset.left + inset.right + width, (rect.bottom - rect.top - buttonHeight) / 2, buttonWidth, buttonHeight, true, true, false);
    }

    boolean sendKeyEvent(int type, Event event) {
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String oldText = "";
        String newText = "";
        int[] actualSize = new int[1];
        int[] ptr = new int[1];
        int charCount = 0;
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize) == 0) {
            charCount = OS.CFStringGetLength((int)ptr[0]);
            OS.CFRelease((int)ptr[0]);
        }
        short[] selection = new short[2];
        OS.GetControlData((int)this.textHandle, (short)0, (int)1936026725, (int)4, (short[])selection, null);
        int start = selection[0];
        int end = selection[1];
        switch (event.character) {
            case '\b': {
                if (start != end) break;
                if (start == 0) {
                    return true;
                }
                start = Math.max(0, start - 1);
                break;
            }
            case '\u007f': {
                if (start != end) break;
                if (start == charCount) {
                    return true;
                }
                end = Math.min(end + 1, charCount);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                oldText = new String(new char[]{event.character});
            }
        }
        if ((newText = this.verifyText(oldText, start, end, event)) == null) {
            return false;
        }
        if (newText != oldText) {
            this.setText(newText, start, end, false);
            selection = new short[]{(short)(start += newText.length()), (short)start};
            OS.SetControlData((int)this.textHandle, (int)0, (int)1936026725, (int)4, (short[])selection);
        }
        this.postEvent(24);
        return newText == oldText;
    }

    void setBackground(float[] color) {
        super.setBackground(color);
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.textHandle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (color != null) {
            fontStyle.backColor_red = (short)(color[0] * 65535.0f);
            fontStyle.backColor_green = (short)(color[1] * 65535.0f);
            fontStyle.backColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 0x10);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFEF);
        }
        OS.SetControlFontStyle((int)this.textHandle, (ControlFontStyleRec)fontStyle);
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.textHandle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (font != null) {
            fontStyle.flags = (short)(fontStyle.flags | 7);
            fontStyle.font = font.id;
            fontStyle.style = font.style;
            fontStyle.size = font.size;
        } else {
            fontStyle.flags = (short)(fontStyle.flags | 0x80);
            fontStyle.font = (short)this.defaultThemeFont();
        }
        OS.SetControlFontStyle((int)this.textHandle, (ControlFontStyleRec)fontStyle);
    }

    void setForeground(float[] color) {
        super.setForeground(color);
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.textHandle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (color != null) {
            fontStyle.foreColor_red = (short)(color[0] * 65535.0f);
            fontStyle.foreColor_green = (short)(color[1] * 65535.0f);
            fontStyle.foreColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 8);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFF7);
        }
        OS.SetControlFontStyle((int)this.textHandle, (ControlFontStyleRec)fontStyle);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int min = OS.GetControl32BitMinimum((int)this.buttonHandle);
        if (value <= min) {
            return;
        }
        int pos = OS.GetControl32BitValue((int)this.buttonHandle);
        OS.SetControl32BitMaximum((int)this.buttonHandle, (int)value);
        if (pos > value) {
            this.setSelection(value, false);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
        if (value >= max) {
            return;
        }
        int pos = OS.GetControl32BitValue((int)this.buttonHandle);
        OS.SetControl32BitMinimum((int)this.buttonHandle, (int)value);
        if (pos < value) {
            this.setSelection(value, false);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        int min = OS.GetControl32BitMinimum((int)this.buttonHandle);
        int max = OS.GetControl32BitMaximum((int)this.buttonHandle);
        value = Math.min(Math.max(min, value), max);
        this.setSelection(value, false);
    }

    void setSelection(int value, boolean notify) {
        OS.SetControl32BitValue((int)this.buttonHandle, (int)value);
        String string = String.valueOf(value);
        if (this.hooks(25) || this.filters(25)) {
            int[] actualSize = new int[1];
            int[] ptr = new int[1];
            int length = 0;
            if (OS.GetControlData((int)this.textHandle, (short)0, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize) == 0) {
                length = OS.CFStringGetLength((int)ptr[0]);
                OS.CFRelease((int)ptr[0]);
            }
            if ((string = this.verifyText(string, 0, length, null)) == null) {
                return;
            }
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlData((int)this.textHandle, (int)0, (int)1667658612, (int)4, (int[])new int[]{ptr});
        OS.CFRelease((int)ptr);
        this.sendEvent(24);
        if (notify) {
            this.postEvent(13);
        }
    }

    char[] setText(String string, int start, int end, boolean notify) {
        if (notify && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, start, end, null)) == null) {
            return null;
        }
        int[] ptr = new int[1];
        int[] actualSize = new int[1];
        if (OS.GetControlData((int)this.textHandle, (short)0, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize) != 0) {
            return null;
        }
        int length = OS.CFStringGetLength((int)ptr[0]);
        char[] text = new char[length - (end - start) + string.length()];
        CFRange range = new CFRange();
        range.location = 0;
        range.length = start;
        char[] buffer = new char[range.length];
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        System.arraycopy(buffer, 0, text, 0, range.length);
        string.getChars(0, string.length(), text, start);
        range.location = end;
        range.length = length - end;
        buffer = new char[range.length];
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        System.arraycopy(buffer, 0, text, start + string.length(), range.length);
        range.location = start;
        range.length = end - start;
        buffer = new char[range.length];
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        ptr[0] = OS.CFStringCreateWithCharacters((int)0, (char[])text, (int)text.length);
        if (ptr[0] == 0) {
            this.error(13);
        }
        OS.SetControlData((int)this.textHandle, (int)0, (int)1667658612, (int)4, (int[])ptr);
        OS.CFRelease((int)ptr[0]);
        if (notify) {
            this.sendEvent(24);
        }
        return buffer;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.textHandle != 0) {
            OS.HIViewAddSubview((int)this.handle, (int)this.textHandle);
        }
        if (this.buttonHandle != 0) {
            OS.HIViewAddSubview((int)this.handle, (int)this.buttonHandle);
        }
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        int index = 0;
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) break;
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

