/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    GC paintGC;
    int itemCount;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int headerHeight;
    int lastIndexOf;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean fixScrollWidth;
    Rectangle imageBounds;
    int showIndex;
    int lastHittest;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int EXTRA_WIDTH = 24;
    static final int CHECK_COLUMN_WIDTH = 25;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    TableItem _getItem(int index) {
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, -1, false);
        return this.items[index];
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        GC currentGC = this.paintGC;
        if (currentGC == null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            this.paintGC = GC.carbon_new(this, data);
        }
        this.fixScrollWidth = false;
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.redraw();
            }
        }
        if (currentGC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return result;
    }

    boolean checkData(TableItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item)) {
                item.redraw(0);
            }
        }
        return true;
    }

    void checkItems(boolean setScrollWidth) {
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount((int)this.handle, (int)0, (boolean)true, (int)-1, (int[])count) != 0) {
            this.error(36);
        }
        if (this.itemCount != count[0]) {
            DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
            callbacks.v1_itemNotificationCallback = 0;
            OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
            int delta = this.itemCount - count[0];
            if (delta < 1024) {
                int[] ids = new int[delta];
                int i = 0;
                while (i < ids.length) {
                    ids[i] = count[0] + i + 1;
                    ++i;
                }
                if (OS.AddDataBrowserItems((int)this.handle, (int)0, (int)ids.length, (int[])ids, (int)0) != 0) {
                    this.error(14);
                }
                OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0, (int)0);
            } else if (OS.AddDataBrowserItems((int)this.handle, (int)0, (int)this.itemCount, null, (int)0) != 0) {
                this.error(14);
            }
            callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
            OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        }
        if (setScrollWidth) {
            this.setScrollWidth(this.items, true);
        }
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            if (this.currentItem != item) {
                item.clear();
                item.cached = false;
            }
            if (this.currentItem == null && this.drawCount == 0) {
                int[] id = new int[]{index + 1};
                OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)id.length, (int[])id, (int)0, (int)0);
            }
            this.setScrollWidth(item);
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                this.clear(i);
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            this.clear(indices[i]);
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
                item.cached = false;
            }
            ++i;
        }
        if (this.currentItem == null && this.drawCount == 0) {
            OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0, (int)0);
        }
        this.setScrollWidth(this.items, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            GC gc = new GC(this);
            int columnCount = Math.max(this.columnCount, 1);
            int j = 0;
            while (j < columnCount) {
                int columnWidth = this.columnCount != 0 ? this.columns[j].getWidth() : 0;
                int i = 0;
                while (i < this.itemCount) {
                    TableItem item = this.items[i];
                    if (item != null) {
                        columnWidth = Math.max(columnWidth, item.calculateWidth(j, gc));
                    }
                    ++i;
                }
                width += columnWidth + 24;
                ++j;
            }
            gc.dispose();
            if ((this.style & 0x20) != 0) {
                width += 25;
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)7, (int[])outMetric);
        border += outMetric[0];
        OS.GetThemeMetric((int)5, (int[])outMetric);
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset((int)this.handle, (Rect)rect);
        return new Rectangle(x -= rect.left + (border += outMetric[0]), y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    void createHandle() {
        this.column_id = 1025;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        OS.CreateDataBrowserControl((int)window, null, (int)1819505782, (int[])outControl);
        OS.SetAutomaticControlDragTrackingEnabledForWindow((int)window, (boolean)true);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData((int)this.handle, (int)0, (int)1651663986, (int)1, (byte[])new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags);
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short[])height);
        this.headerHeight = height[0];
        OS.SetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars((int)this.handle, ((this.style & 0x100) != 0 ? 1 : 0) != 0, ((this.style & 0x200) != 0 ? 1 : 0) != 0);
        int position = 0;
        if ((this.style & 0x20) != 0) {
            DataBrowserListViewColumnDesc checkColumn = new DataBrowserListViewColumnDesc();
            checkColumn.headerBtnDesc_version = 0;
            checkColumn.propertyDesc_propertyID = 1024;
            checkColumn.propertyDesc_propertyType = 1667785336;
            checkColumn.propertyDesc_propertyFlags = 1;
            checkColumn.headerBtnDesc_minimumWidth = (short)25;
            checkColumn.headerBtnDesc_maximumWidth = (short)25;
            checkColumn.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn((int)this.handle, (DataBrowserListViewColumnDesc)checkColumn, (int)position++);
        }
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = this.column_id;
        column.propertyDesc_propertyType = 0x3F3F3F3F;
        column.propertyDesc_propertyFlags = 65536;
        column.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn((int)this.handle, (DataBrowserListViewColumnDesc)column, (int)position);
        OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short)0);
        int size = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)size;
        OS.SetControlBounds((int)this.handle, (Rect)rect);
        int bpl = size * 4;
        int[] gWorld = new int[1];
        int data = OS.NewPtr((int)(bpl * size));
        OS.NewGWorldFromPtr((int[])gWorld, (int)32, (Rect)rect, (int)0, (int)0, (int)0, (int)data, (int)bpl);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld((int[])curPort, (int[])curGWorld);
        OS.SetGWorld((int)gWorld[0], (int)curGWorld[0]);
        OS.DrawControlInCurrentPort((int)this.handle);
        OS.SetGWorld((int)curPort[0], (int)curGWorld[0]);
        OS.DisposeGWorld((int)gWorld[0]);
        OS.DisposePtr((int)data);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds((int)this.handle, (Rect)rect);
    }

    void createItem(TableColumn column, int index) {
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        column.id = this.column_id + this.idCount++;
        int position = index + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            DataBrowserListViewColumnDesc desc = new DataBrowserListViewColumnDesc();
            desc.headerBtnDesc_version = 0;
            desc.propertyDesc_propertyID = column.id;
            desc.propertyDesc_propertyType = 0x3F3F3F3F;
            desc.propertyDesc_propertyFlags = 65536;
            desc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            desc.headerBtnDesc_initialOrder = 1;
            desc.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            desc.headerBtnDesc_btnFontStyle_flags = (short)(desc.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn((int)this.handle, (DataBrowserListViewColumnDesc)desc, (int)position);
            OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)column.id, (short)0);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    Font[] cellFont;
                    Color[] cellForeground;
                    Color[] cellBackground;
                    Image[] images;
                    String[] strings = item.strings;
                    if (strings != null) {
                        String[] temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                        temp[index] = "";
                        item.strings = temp;
                    }
                    if (index == 0) {
                        item.text = "";
                    }
                    if ((images = item.images) != null) {
                        Image[] temp = new Image[this.columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
                        item.images = temp;
                    }
                    if (index == 0) {
                        item.image = null;
                    }
                    if ((cellBackground = item.cellBackground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellBackground = temp;
                    }
                    if ((cellForeground = item.cellForeground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellForeground = temp;
                    }
                    if ((cellFont = item.cellFont) != null) {
                        Font[] temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellFont = temp;
                    }
                }
                ++i;
            }
        }
        int[] lastPosition = new int[1];
        int i = 0;
        while (i < this.columnCount) {
            TableColumn c = this.columns[i];
            OS.GetDataBrowserTableViewColumnPosition((int)this.handle, (int)c.id, (int[])lastPosition);
            c.lastPosition = lastPosition[0];
            ++i;
        }
    }

    void createItem(TableItem item, int index) {
        int[] id;
        boolean add;
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        boolean bl = add = this.drawCount == 0 || index != this.itemCount;
        if (add && OS.AddDataBrowserItems((int)this.handle, (int)0, (int)1, (int[])(id = new int[]{this.itemCount + 1}), (int)0) != 0) {
            this.error(14);
        }
        if (this.itemCount == this.items.length) {
            int length = this.drawCount == 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        if (add) {
            OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0, (int)0);
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.showIndex = -1;
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.deselect(ids, ids.length);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            int length = end - start + 1;
            if (length <= 0) {
                return;
            }
            int[] ids = new int[length];
            int i = 0;
            while (i < length) {
                ids[i] = end - i + 1;
                ++i;
            }
            this.deselect(ids, length);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int length = indices.length;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = indices[length - i - 1] + 1;
            ++i;
        }
        this.deselect(ids, length);
    }

    void deselect(int[] ids, int count) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags((int)this.handle, (int[])selectionFlags);
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)(selectionFlags[0] & 0xFFFFFFBF));
        }
        OS.SetDataBrowserSelectedItems((int)this.handle, (int)count, (int[])ids, (int)3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselect(null, 0);
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        if (this.columnCount == 1) {
            int str;
            this.column_id = column.id;
            this.idCount = 0;
            DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
            desc.version = 0;
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short[])width);
            desc.minimumWidth = desc.maximumWidth = width[0];
            desc.titleString = str = OS.CFStringCreateWithCharacters((int)0, null, (int)0);
            OS.SetDataBrowserListViewHeaderDesc((int)this.handle, (int)this.column_id, (DataBrowserListViewHeaderDesc)desc);
            OS.CFRelease((int)str);
        } else if (OS.RemoveDataBrowserTableViewColumn((int)this.handle, (int)column.id) != 0) {
            this.error(15);
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
    }

    void destroyItem(TableItem item) {
        this.checkItems(true);
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        int[] id = new int[]{this.itemCount};
        if (OS.RemoveDataBrowserItems((int)this.handle, (int)0, (int)id.length, (int[])id, (int)0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0, (int)0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    int drawItemProc(int browser, int id, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        int index = id - 1;
        if (index < 0 || index >= this.itemCount) {
            return 0;
        }
        int columnIndex = 0;
        if (this.columnCount > 0) {
            columnIndex = 0;
            while (columnIndex < this.columnCount) {
                if (this.columns[columnIndex].id == property) break;
                ++columnIndex;
            }
            if (columnIndex == this.columnCount) {
                return 0;
            }
        }
        this.lastIndexOf = index;
        TableItem item = this._getItem(index);
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            if (!this.checkData(item, false)) {
                return 0;
            }
            if (this.setScrollWidth(item)) {
                Rect rect = new Rect();
                if (OS.GetDataBrowserItemPartBounds((int)this.handle, (int)id, (int)property, (int)0, (Rect)rect) == 0) {
                    this.redrawWidget(this.handle, rect.left, rect.top, rect.right, rect.bottom, false);
                }
                return 0;
            }
        }
        Rect rect = new Rect();
        OS.memcpy((Rect)rect, (int)theRect, (int)8);
        int x = rect.left;
        int y = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        boolean selected = (itemState & 1) != 0;
        Rect controlRect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)controlRect);
        x -= controlRect.left;
        y -= controlRect.top;
        GC gc = this.paintGC;
        if (gc == null) {
            GCData data = new GCData();
            int[] port = new int[1];
            OS.GetPort((int[])port);
            data.port = port[0];
            gc = GC.carbon_new(this, data);
        }
        int clip = OS.NewRgn();
        OS.GetClip((int)clip);
        OS.OffsetRgn((int)clip, (short)(-controlRect.left), (short)(-controlRect.top));
        gc.setClipping(Region.carbon_new(this.display, clip));
        Rect itemRect = new Rect();
        OS.GetDataBrowserItemPartBounds((int)this.handle, (int)id, (int)property, (int)0, (Rect)itemRect);
        OS.OffsetRect((Rect)itemRect, (short)(-controlRect.left), (short)(-controlRect.top));
        if (selected && (this.style & 0x10000) != 0) {
            gc.setBackground(this.display.getSystemColor(26));
            gc.fillRectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top);
        } else {
            gc.setBackground(item.getBackground(columnIndex));
            gc.fillRectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top);
        }
        int rectRgn = OS.NewRgn();
        OS.RectRgn((int)rectRgn, (Rect)rect);
        OS.OffsetRgn((int)rectRgn, (short)(-controlRect.left), (short)(-controlRect.top));
        OS.SectRgn((int)rectRgn, (int)clip, (int)clip);
        OS.DisposeRgn((int)rectRgn);
        gc.setClipping(Region.carbon_new(this.display, clip));
        OS.DisposeRgn((int)clip);
        Image image = item.getImage(columnIndex);
        String text = item.getText(columnIndex);
        gc.setFont(item.getFont(columnIndex));
        org.eclipse.swt.graphics.Point extent = gc.stringExtent(text);
        int itemWidth = extent.x;
        Rectangle imageBounds = null;
        if (image != null) {
            imageBounds = image.getBounds();
            itemWidth += this.imageBounds.width + 2;
        }
        if (this.columnCount != 0) {
            TableColumn column = this.columns[columnIndex];
            if ((column.style & 0x1000000) != 0) {
                x += (width - itemWidth) / 2;
            }
            if ((column.style & 0x20000) != 0) {
                x += width - itemWidth;
            }
        }
        if (image != null) {
            gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, y + (height - this.imageBounds.height) / 2, this.imageBounds.width, this.imageBounds.height);
            x += this.imageBounds.width + 2;
        }
        if (selected) {
            gc.setForeground(this.display.getSystemColor(27));
            if (columnIndex == 0 && (this.style & 0x10000) == 0) {
                gc.setBackground(this.display.getSystemColor(26));
                gc.fillRectangle(x - 1, y, extent.x + 2, height);
            }
        } else {
            Color foreground = item.getForeground(columnIndex);
            gc.setForeground(foreground);
        }
        gc.drawString(text, x, y + (height - extent.y) / 2, true);
        if (gc != this.paintGC) {
            gc.dispose();
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)7, (int[])outMetric);
        border += outMetric[0];
        OS.GetThemeMetric((int)5, (int[])outMetric);
        border += outMetric[0];
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        OS.GetDataBrowserScrollBarInset((int)this.handle, (Rect)inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left, inset.top, width, height);
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int[] position = new int[1];
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            OS.GetDataBrowserTableViewColumnPosition((int)this.handle, (int)column.id, (int[])position);
            if ((this.style & 0x20) != 0) {
                position[0] = position[0] - 1;
            }
            order[position[0]] = i++;
        }
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short[])height);
        return height[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short[])height);
        return height[0] != 0;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        this.checkItems(true);
        if (point == null) {
            this.error(4);
        }
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        Point pt = new Point();
        OS.SetPt((Point)pt, (short)((short)(point.x + rect.left)), (short)((short)(point.y + rect.top)));
        int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
        int i = 0;
        while (i < this.itemCount) {
            if (OS.GetDataBrowserItemPartBounds((int)this.handle, (int)(i + 1), (int)columnId, (int)0, (Rect)rect) == 0 && ((this.style & 0x10000) != 0 ? rect.top <= pt.v && pt.v < rect.bottom : OS.PtInRect((Point)pt, (Rect)rect))) {
                return this._getItem(i);
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight((int)this.handle, (short[])height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return false;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle((int)0);
        if (OS.GetDataBrowserItems((int)this.handle, (int)0, (boolean)true, (int)1, (int)ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize((int)ptr) / 4;
        TableItem[] result = new TableItem[count];
        OS.HLock((int)ptr);
        int[] start = new int[1];
        OS.memcpy((int[])start, (int)ptr, (int)4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy((int[])id, (int)(start[0] + i * 4), (int)4);
            result[i] = this._getItem(id[0] - 1);
            ++i;
        }
        OS.HUnlock((int)ptr);
        OS.DisposeHandle((int)ptr);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount((int)this.handle, (int)0, (boolean)true, (int)1, (int[])count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] first = new int[1];
        int[] last = new int[1];
        if (OS.GetDataBrowserSelectionAnchor((int)this.handle, (int[])first, (int[])last) != 0) {
            return -1;
        }
        return first[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int ptr = OS.NewHandle((int)0);
        if (OS.GetDataBrowserItems((int)this.handle, (int)0, (boolean)true, (int)1, (int)ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize((int)ptr) / 4;
        int[] result = new int[count];
        OS.HLock((int)ptr);
        int[] start = new int[1];
        OS.memcpy((int[])start, (int)ptr, (int)4);
        int[] id = new int[1];
        int i = 0;
        while (i < count) {
            OS.memcpy((int[])id, (int)(start[0] + i * 4), (int)4);
            result[i] = id[0] - 1;
            ++i;
        }
        OS.HUnlock((int)ptr);
        OS.DisposeHandle((int)ptr);
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
        return top[0] / this.getItemHeight();
    }

    int hitTestProc(int browser, int id, int property, int theRect, int mouseRect) {
        this.lastHittest = id;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks((DataBrowserCallbacks)callbacks);
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        DataBrowserCustomCallbacks custom = new DataBrowserCustomCallbacks();
        custom.version = 0;
        OS.InitDataBrowserCustomCallbacks((DataBrowserCustomCallbacks)custom);
        custom.v1_drawItemCallback = this.display.drawItemProc;
        custom.v1_hitTestCallback = this.display.hitTestProc;
        custom.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks((int)this.handle, (DataBrowserCustomCallbacks)custom);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        return OS.IsDataBrowserItemSelected((int)this.handle, (int)(index + 1));
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        int row = id - 1;
        if (row < 0 || row >= this.items.length) {
            return 0;
        }
        switch (property) {
            case 1024: {
                TableItem item = this._getItem(row);
                if (setValue != 0) {
                    boolean bl = item.checked = !item.checked;
                    if (item.checked && item.grayed) {
                        OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)2);
                    } else {
                        boolean theData = item.checked;
                        OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)((short)(theData ? 1 : 0)));
                    }
                    Event event = new Event();
                    event.item = item;
                    event.detail = 32;
                    this.postEvent(13, event);
                    break;
                }
                int theData = 0;
                if (item.checked) {
                    theData = item.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue((int)itemData, (short)((short)theData));
            }
        }
        return 0;
    }

    int itemNotificationProc(int browser, int id, int message) {
        if (message == 13) {
            short[] width = new short[1];
            int[] position = new int[1];
            TableColumn[] columns = this.getColumns();
            int i = 0;
            while (i < this.columnCount) {
                TableColumn column = columns[i];
                if (!column.isDisposed()) {
                    OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)column.id, (short[])width);
                    if (width[0] != column.lastWidth) {
                        column.resized(width[0]);
                    }
                }
                if (!column.isDisposed()) {
                    OS.GetDataBrowserTableViewColumnPosition((int)this.handle, (int)column.id, (int[])position);
                    if (position[0] != column.lastPosition) {
                        column.lastPosition = position[0];
                        column.sendEvent(10);
                    }
                }
                ++i;
            }
            return 0;
        }
        int index = id - 1;
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        switch (message) {
            case 5: 
            case 6: {
                TableItem item = this._getItem(index);
                this.wasSelected = true;
                if (this.ignoreSelect) break;
                int[] first = new int[1];
                int[] last = new int[1];
                OS.GetDataBrowserSelectionAnchor((int)this.handle, (int[])first, (int[])last);
                boolean selected = false;
                if ((this.style & 2) != 0) {
                    int modifiers = OS.GetCurrentEventKeyModifiers();
                    selected = (modifiers & 0x200) != 0 ? (message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast) : ((modifiers & 0x100) != 0 ? true : first[0] == last[0]);
                } else {
                    boolean bl = selected = message == 5;
                }
                if (!selected) break;
                this.anchorFirst = first[0];
                this.anchorLast = last[0];
                Event event = new Event();
                event.item = item;
                this.postEvent(13, event);
                break;
            }
            case 7: {
                TableItem item = this._getItem(index);
                this.wasSelected = true;
                Event event = new Event();
                event.item = item;
                this.postEvent(14, event);
            }
        }
        return 0;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int index;
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell shell = this.getShell();
        shell.bringToTop(true);
        Control oldFocus = this.display.getFocusControl();
        this.display.ignoreFocus = true;
        this.wasSelected = false;
        result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        this.display.ignoreFocus = false;
        if (oldFocus != this) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (!this.isDisposed() && this.isEnabled()) {
                this.sendFocusEvent(15, false);
            }
        }
        if (!this.wasSelected && OS.IsDataBrowserItemSelected((int)this.handle, (int)this.lastHittest) && (index = this.lastHittest - 1) >= 0 && index < this.itemCount) {
            Event event = new Event();
            event.item = this._getItem(index);
            this.postEvent(13, event);
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        switch (keyCode[0]) {
            case 36: {
                this.postEvent(14);
                break;
            }
            case 125: {
                int index = this.getSelectionIndex();
                this.setSelection(Math.min(this.itemCount - 1, index + 1), true);
                return 0;
            }
            case 126: {
                int index = this.getSelectionIndex();
                this.setSelection(Math.max(0, index - 1), true);
                return 0;
            }
        }
        return result;
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i;
        }
        this.columns = null;
        i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    public void remove(int index) {
        int[] id;
        this.checkWidget();
        this.checkItems(true);
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if (OS.RemoveDataBrowserItems((int)this.handle, (int)0, (int)(id = new int[]{this.itemCount}).length, (int[])id, (int)0) != 0) {
            this.error(15);
        }
        TableItem item = this.items[index];
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (item != null) {
            item.releaseResources();
        }
        OS.UpdateDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0, (int)0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.removeAll();
        } else {
            int length = end - start + 1;
            int i = 0;
            while (i < length) {
                this.remove(start);
                ++i;
            }
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                this.remove(index);
                last = index;
            }
            ++i;
        }
    }

    public void removeAll() {
        this.checkWidget();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        OS.RemoveDataBrowserItems((int)this.handle, (int)0, (int)0, null, (int)0);
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        OS.SetDataBrowserScrollPosition((int)this.handle, (int)0, (int)0);
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.setTableEmpty();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
    }

    public void select(int index) {
        this.checkWidget();
        this.checkItems(false);
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.select(ids, ids.length, false);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        this.checkItems(false);
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.selectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            int length = end - start + 1;
            int[] ids = new int[length];
            int i = 0;
            while (i < length) {
                ids[i] = end - i + 1;
                ++i;
            }
            this.select(ids, length, false);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        this.checkItems(false);
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = index + 1;
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, false);
        }
    }

    void select(int[] ids, int count, boolean clear) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags((int)this.handle, (int[])selectionFlags);
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)(selectionFlags[0] & 0xFFFFFFBF));
        }
        int operation = 1;
        if ((this.style & 2) != 0 && !clear) {
            operation = 0;
        }
        OS.SetDataBrowserSelectedItems((int)this.handle, (int)count, (int[])ids, (int)operation);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags((int)this.handle, (int)selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    public void selectAll() {
        this.checkWidget();
        this.checkItems(false);
        if ((this.style & 4) != 0) {
            return;
        }
        this.select(null, 0, false);
    }

    void setBackground(float[] color) {
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        int index;
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            TableColumn column;
            i = 0;
            while (i < order.length) {
                index = order[i];
                column = this.columns[index];
                int position = (this.style & 0x20) != 0 ? i + 1 : i;
                OS.SetDataBrowserTableViewColumnPosition((int)this.handle, (int)column.id, (int)position);
                if (position != column.lastPosition) {
                    column.lastPosition = position;
                }
                ++i;
            }
            TableColumn[] newColumns = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            int i2 = 0;
            while (i2 < this.columnCount) {
                column = newColumns[oldOrder[i2]];
                if (!column.isDisposed() && order[i2] != oldOrder[i2]) {
                    column.sendEvent(10);
                }
                ++i2;
            }
        }
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            TableItem item = this.items[i];
            if (item != null) {
                item.width = -1;
            }
            ++i;
        }
        this.setScrollWidth(this.items, true);
        this.setItemHeight(null);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        int height = show ? this.headerHeight : 0;
        OS.SetDataBrowserListViewHeaderBtnHeight((int)this.handle, (short)((short)height));
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.checkItems(true);
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        this.setRedraw(false);
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        if (count < this.itemCount) {
            int index = count;
            while (index < this.itemCount) {
                int[] id = new int[]{index + 1};
                if (OS.RemoveDataBrowserItems((int)this.handle, (int)0, (int)id.length, (int[])id, (int)0) != 0) break;
                TableItem item = this.items[index];
                if (item != null) {
                    item.releaseResources();
                }
                ++index;
            }
            if (index < this.itemCount) {
                this.error(15);
            }
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.itemCount));
        this.items = newItems;
        if ((this.style & 0x10000000) == 0) {
            int i = count;
            while (i < this.itemCount) {
                this.items[i] = new TableItem(this, 0, i, false);
                ++i;
            }
        }
        this.itemCount = count;
        OS.AddDataBrowserItems((int)this.handle, (int)0, (int)this.itemCount, null, (int)0);
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks((int)this.handle, (DataBrowserCallbacks)callbacks);
        this.setRedraw(true);
    }

    void setItemHeight(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds == null) {
            return;
        }
        this.imageBounds = bounds;
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight((int)this.handle, (short[])height) == 0 && height[0] < bounds.height) {
            OS.SetDataBrowserTableViewRowHeight((int)this.handle, (short)((short)bounds.height));
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
                this.items = newItems;
            }
            this.checkItems(true);
        }
    }

    boolean setScrollWidth(TableItem item) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != item) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (this.drawCount != 0) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc);
        gc.dispose();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short[])width);
        if (width[0] < (newWidth += 24)) {
            OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short)((short)newWidth));
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] items, boolean set) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        if (this.drawCount != 0) {
            return false;
        }
        GC gc = new GC(this);
        short newWidth = 0;
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item != null) {
                newWidth = Math.max(newWidth, item.calculateWidth(0, gc));
            }
            ++i;
        }
        gc.dispose();
        newWidth += 24;
        if (!set) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short[])width);
            if (width[0] >= newWidth) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.column_id, (short)newWidth);
        return true;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{index + 1};
            this.select(ids, ids.length, true);
            this.showIndex(index);
            if (notify) {
                Event event = new Event();
                event.item = this._getItem(index);
                this.postEvent(13, event);
            }
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        int length = end - start + 1;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = end - i + 1;
            ++i;
        }
        this.select(ids, length, true);
        this.showIndex(ids[0] - 1);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        this.checkItems(false);
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = index + 1;
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(ids[0] - 1);
        }
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        this.checkItems(false);
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = this.indexOf(items[length - i - 1]);
            if (index != -1) {
                ids[count++] = index + 1;
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(ids[0] - 1);
        }
    }

    void setTableEmpty() {
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.itemCount = 0;
        this.items = new TableItem[4];
        if (this.imageBounds != null) {
            this.imageBounds = null;
            this.setFontStyle(this.font);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        this.checkItems(false);
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
        top[0] = index * this.getItemHeight();
        OS.SetDataBrowserScrollPosition((int)this.handle, (int)top[0], (int)left[0]);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (this.columnCount <= 1 || index < 0 || index >= this.columnCount) {
            return;
        }
        short[] w = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)column.id, (short[])w);
        int width = w[0];
        int x = 0;
        int i = 0;
        while (i < index) {
            w = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth((int)this.handle, (int)this.columns[i].id, (short[])w);
            x += w[0];
            ++i;
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
        if (x < left[0]) {
            OS.SetDataBrowserScrollPosition((int)this.handle, (int)top[0], (int)x);
        } else {
            Rectangle rect = this.getClientArea();
            int maxWidth = rect.width;
            if (x + (width = Math.min(width, maxWidth)) > left[0] + maxWidth) {
                left[0] = x + width - maxWidth;
                OS.SetDataBrowserScrollPosition((int)this.handle, (int)top[0], (int)left[0]);
            }
        }
    }

    void showIndex(int index) {
        if (index >= 0 && index < this.itemCount) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight() || !OS.IsControlVisible((int)this.handle)) {
                this.showIndex = index;
                return;
            }
            this.showIndex = -1;
            TableItem item = this._getItem(index);
            Rectangle itemRect = item.getBounds(0);
            if (!itemRect.isEmpty() && rect.contains(itemRect.x, itemRect.y) && rect.contains(itemRect.x, itemRect.y + itemRect.height)) {
                return;
            }
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition((int)this.handle, (int[])top, (int[])left);
            OS.RevealDataBrowserItem((int)this.handle, (int)(index + 1), (int)0, (byte)2);
            int[] newTop = new int[1];
            int[] newLeft = new int[1];
            OS.GetDataBrowserScrollPosition((int)this.handle, (int[])newTop, (int[])newLeft);
            if (this.horizontalBar != null && newLeft[0] != left[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && newTop[0] != top[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showItem(TableItem item) {
        int index;
        this.checkWidget();
        this.checkItems(false);
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((index = this.indexOf(item)) != -1) {
            this.showIndex(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems(false);
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.showIndex(index);
        }
    }

    int trackingProc(int browser, int id, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }
}

