/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.registry.EclipseBundleListener;
import org.eclipse.core.internal.registry.ExtensionLinker;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryCacheWriter;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static BundleContext context;
    private EclipseBundleListener pluginBundleListener;
    private ExtensionRegistry registry;
    private ServiceReference environmentServiceReference;
    private ServiceReference urlServiceReference;
    private ServiceReference logServiceReference;
    private ServiceReference packageAdminReference;
    private long registryStamp;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        PlatformActivator.context = context;
        this.acquireInfoService();
        this.acquireURLConverterService();
        this.acquireFrameworkLogService();
        this.acquirePackageAdminService();
        this.startInternalPlatform();
        this.startRegistry(context);
        this.installPlatformURLSupport();
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(context);
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLBaseConnection.startup(InternalPlatform.getDefault().getInstallURL());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.url.URLStreamHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)new PlatformURLHandler(), properties);
    }

    private void startRegistry(BundleContext context) {
        Class<?> clazz;
        boolean fromCache = true;
        if (!"true".equals(System.getProperty("eclipse.noRegistryCache"))) {
            MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, "Registry cache problems", null);
            Factory factory = new Factory(problems);
            long start = 0L;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            boolean lazyLoading = !"true".equals(System.getProperty("eclipse.noLazyRegistryCacheLoading"));
            File cacheFile = new File(InternalPlatform.getDefault().getConfigurationLocation().getURL().getPath());
            if ((cacheFile = new File(cacheFile, ".registry")).isFile()) {
                this.registryStamp = this.computeRegistryStamp();
                this.registry = new RegistryCacheReader(cacheFile, factory, lazyLoading).loadCache(this.registryStamp);
            }
            if (InternalPlatform.DEBUG && this.registry != null) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - start));
            }
            if (InternalPlatform.DEBUG_REGISTRY) {
                if (this.registry == null) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache " + (lazyLoading ? "with" : "without") + " lazy element loading...");
                }
            }
            if (!problems.isOK()) {
                System.out.println(problems);
            }
        }
        if (this.registry == null) {
            fromCache = false;
            this.registry = new ExtensionRegistry(new ExtensionLinker());
        }
        this.pluginBundleListener = new EclipseBundleListener(this.registry);
        context.addBundleListener((BundleListener)this.pluginBundleListener);
        if (!fromCache) {
            this.pluginBundleListener.processBundles(context.getBundles());
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)this.registry, new Hashtable());
        InternalPlatform.getDefault().setExtensionRegistry(this.registry);
    }

    private long computeRegistryStamp() {
        if (!"true".equalsIgnoreCase(System.getProperty("osgi.checkConfiguration"))) {
            return 0L;
        }
        Bundle[] allBundles = context.getBundles();
        long result = 0L;
        int i = 0;
        while (i < allBundles.length) {
            URL pluginManifest = allBundles[i].getEntry("plugin.xml");
            if (pluginManifest == null) {
                pluginManifest = allBundles[i].getEntry("fragment.xml");
            }
            if (pluginManifest != null) {
                try {
                    URLConnection connection = pluginManifest.openConnection();
                    result ^= connection.getLastModified() + allBundles[i].getBundleId();
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            ++i;
        }
        return result;
    }

    public void stop(BundleContext context) throws Exception {
        this.stopRegistry(context);
        this.environmentInfoServiceReleased(this.environmentServiceReference);
        this.urlServiceReleased(this.urlServiceReference);
        this.logServiceReleased(this.logServiceReference);
        this.packageAdminServiceReleased(this.packageAdminReference);
        InternalPlatform.getDefault().stop(context);
        InternalPlatform.getDefault().setRuntimeInstance(null);
    }

    private void stopRegistry(BundleContext context) {
        context.removeBundleListener((BundleListener)this.pluginBundleListener);
        if (this.registry != null && this.registry.isDirty()) {
            File cacheFile = new File(InternalPlatform.getDefault().getConfigurationLocation().getURL().getPath());
            cacheFile = new File(cacheFile, ".registry");
            new RegistryCacheWriter(cacheFile).saveCache(this.registry, this.computeRegistryStamp());
            this.registry = null;
        }
    }

    private void acquireInfoService() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.environmentServiceReference = context.getServiceReference(clazz.getName());
        if (this.environmentServiceReference == null) {
            return;
        }
        InternalPlatform.infoService = (EnvironmentInfo)context.getService(this.environmentServiceReference);
    }

    private void acquireURLConverterService() throws Exception {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.urlconversion.URLConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.urlServiceReference = context.getServiceReference(clazz.getName());
        if (this.urlServiceReference == null) {
            return;
        }
        InternalPlatform.urlConverter = (URLConverter)context.getService(this.urlServiceReference);
    }

    private void acquireFrameworkLogService() throws Exception {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logServiceReference = context.getServiceReference(clazz.getName());
        if (this.logServiceReference == null) {
            return;
        }
        InternalPlatform.frameworkLog = (FrameworkLog)context.getService(this.logServiceReference);
    }

    private void acquirePackageAdminService() throws Exception {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminReference = context.getServiceReference(clazz.getName());
        if (this.packageAdminReference == null) {
            return;
        }
        InternalPlatform.packageAdmin = (PackageAdmin)context.getService(this.packageAdminReference);
    }

    private void startInternalPlatform() {
        InternalPlatform.getDefault().start(context);
    }

    private void environmentInfoServiceReleased(ServiceReference reference) {
        if (this.environmentServiceReference == null) {
            return;
        }
        if (this.environmentServiceReference != reference) {
            return;
        }
        InternalPlatform.infoService = null;
        context.ungetService(this.environmentServiceReference);
        this.environmentServiceReference = null;
    }

    private void urlServiceReleased(ServiceReference reference) {
        if (this.urlServiceReference == null) {
            return;
        }
        if (this.urlServiceReference != reference) {
            return;
        }
        InternalPlatform.urlConverter = null;
        context.ungetService(this.urlServiceReference);
        this.urlServiceReference = null;
    }

    private void logServiceReleased(ServiceReference reference) {
        if (this.logServiceReference == null) {
            return;
        }
        if (this.logServiceReference != reference) {
            return;
        }
        InternalPlatform.frameworkLog = null;
        context.ungetService(this.logServiceReference);
        this.logServiceReference = null;
    }

    private void packageAdminServiceReleased(ServiceReference reference) {
        if (this.packageAdminReference == null) {
            return;
        }
        if (this.packageAdminReference != reference) {
            return;
        }
        InternalPlatform.packageAdmin = null;
        context.ungetService(this.packageAdminReference);
        this.packageAdminReference = null;
    }

    private void registerApplicationService() {
        ParameterizedRunnable work = new ParameterizedRunnable(){

            public Object run(Object arg) {
                IProduct product;
                IPlatformRunnable application = null;
                String applicationId = System.getProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION);
                if (applicationId == null && (product = InternalPlatform.getDefault().getProduct()) != null) {
                    applicationId = product.getApplication();
                    System.setProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION, applicationId);
                }
                if (applicationId == null) {
                    throw new RuntimeException("No application id found");
                }
                IExtension applicationExtension = PlatformActivator.this.registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                if (applicationExtension == null) {
                    throw new RuntimeException("Unable to locate application extension: " + applicationId);
                }
                IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                if (configs.length == 0) {
                    throw new RuntimeException("Invalid (empty) application extension: " + applicationId);
                }
                IConfigurationElement config = configs[0];
                try {
                    application = (IPlatformRunnable)config.createExecutableExtension("run");
                }
                catch (CoreException ce) {
                    throw new RuntimeException("Error running application", ce);
                }
                if (arg == null) {
                    arg = InternalPlatform.getDefault().getApplicationArgs();
                }
                try {
                    Object result = application.run(arg);
                    int exitCode = result instanceof Integer ? (Integer)result : 0;
                    System.setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
                    if (InternalPlatform.DEBUG) {
                        System.out.println(Policy.bind("application.returned", new String[]{applicationId, result.toString()}));
                    }
                    return result;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error running application", e);
                }
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put(PROP_ECLIPSE_APPLICATION, "default");
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)work, properties);
    }
}

